/*
 * Decompiled with CFR 0.152.
 */
package com.anf.utils;

import com.anf.cryptotoken.log.Logger;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.apache.commons.io.IOUtils;

public class Sound {
    private static final Logger log = Logger.getLogger(Sound.class);
    byte[] audioContent = null;
    private Clip clip;
    private AtomicInteger orders = new AtomicInteger();

    public Sound(String fileName, boolean resource) throws IOException {
        InputStream stream = Sound.getStream(fileName, resource);
        this.audioContent = IOUtils.toByteArray((InputStream)stream);
    }

    public void playSound() {
        this.playSound(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playSound(boolean forced) {
        try {
            boolean play = false;
            AtomicInteger atomicInteger = this.orders;
            synchronized (atomicInteger) {
                if (forced || this.orders.get() == 0) {
                    play = true;
                }
                if (!forced) {
                    this.orders.incrementAndGet();
                }
            }
            if (play) {
                Clip clip = this.getClip();
                clip.start();
            }
        }
        catch (IOException | LineUnavailableException | UnsupportedAudioFileException e) {
            log.error(e);
        }
    }

    private Clip getClip() throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        if (this.clip == null) {
            AudioInputStream stream = AudioSystem.getAudioInputStream(new ByteArrayInputStream(this.audioContent));
            AudioFormat format = Sound.getAudioFormat(stream);
            DataLine.Info info = new DataLine.Info(Clip.class, stream.getFormat(), (int)stream.getFrameLength() * format.getFrameSize());
            this.clip = (Clip)AudioSystem.getLine(info);
            this.clip.open(stream);
            this.clip.addLineListener(new LineListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void update(LineEvent event) {
                    if (event.getType() == LineEvent.Type.STOP) {
                        Sound sound = Sound.this;
                        synchronized (sound) {
                            try {
                                Sound.this.getClip().setFramePosition(0);
                                boolean play = false;
                                AtomicInteger atomicInteger = Sound.this.orders;
                                synchronized (atomicInteger) {
                                    if (Sound.this.orders.decrementAndGet() > 0) {
                                        play = true;
                                    }
                                }
                                if (play) {
                                    Sound.this.playSound(true);
                                }
                            }
                            catch (IOException | LineUnavailableException | UnsupportedAudioFileException e) {
                                log.error(e);
                            }
                        }
                    }
                }
            });
        }
        return this.clip;
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        ExecutorService executor = Executors.newFixedThreadPool(100);
        Sound sound = new Sound("/sounds/tecladoTerminate.wav", true);
        for (int i = 0; i < 10; ++i) {
            executor.execute(() -> sound.playSound());
        }
        TimeUnit.SECONDS.sleep(15L);
        System.exit(0);
        sound.playSound();
        sound.playSound();
        File file = new File("C:\\Torrent\\wav", "Aviso5.wav");
        System.out.println(file.exists());
        Sound.playSound(file.getCanonicalPath(), false);
        String res = "sounds/Aviso5.wav";
        Sound.playSound(res, true);
        System.out.println("hola concha");
    }

    public static Clip playSound(String fileName, boolean resource) {
        Clip clip = Sound.createClip(fileName, resource);
        if (clip != null) {
            clip.start();
        }
        return clip;
    }

    public static Clip createClip(String fileName, boolean resource) {
        if (resource && Sound.class.getClassLoader().getResourceAsStream(fileName) == null) {
            return null;
        }
        if (!resource && !new File(fileName).exists()) {
            return null;
        }
        try {
            AudioInputStream stream = Sound.getAudioStream(fileName, resource);
            AudioFormat format = Sound.getAudioFormat(stream);
            DataLine.Info info = new DataLine.Info(Clip.class, stream.getFormat(), (int)stream.getFrameLength() * format.getFrameSize());
            Clip clip = (Clip)AudioSystem.getLine(info);
            clip.open(stream);
            return clip;
        }
        catch (IOException | LineUnavailableException | UnsupportedAudioFileException e) {
            log.error(e);
            return null;
        }
    }

    private static AudioFormat getAudioFormat(AudioInputStream stream) {
        AudioFormat format = stream.getFormat();
        return format;
    }

    private static AudioInputStream getAudioStream(String fileName, boolean resource) throws UnsupportedAudioFileException, IOException {
        InputStream in = Sound.getStream(fileName, resource);
        AudioInputStream stream = AudioSystem.getAudioInputStream(in);
        return stream;
    }

    private static InputStream getStream(String fileName, boolean resource) throws FileNotFoundException {
        InputStream in = null;
        if (resource) {
            in = Sound.class.getResourceAsStream(fileName);
            in = new BufferedInputStream(in);
        } else {
            FileInputStream fin = new FileInputStream(new File(fileName));
            in = new BufferedInputStream(fin);
        }
        return in;
    }
}

