/*
 * Decompiled with CFR 0.152.
 */
package com.anf.utils;

import com.anf.cryptotoken.log.Logger;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.nio.channels.SocketChannel;
import java.util.Enumeration;

public class NetworkConfig {
    private static final Logger log = Logger.getLogger(NetworkConfig.class);
    private NetworkInterface netWorkInterface;
    private InetAddress ipAddress;
    private String macAddress;
    private static NetworkConfig network;

    private NetworkConfig() {
    }

    public static NetworkConfig get() {
        if (network == null) {
            network = new NetworkConfig();
            network.load();
        }
        return network;
    }

    public void load() {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface ni = networkInterfaces.nextElement();
                if (ni.isLoopback() || !ni.isUp() || ni.getHardwareAddress() == null) continue;
                Enumeration<InetAddress> inetAddresses = ni.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddress = inetAddresses.nextElement();
                    if (!(inetAddress instanceof Inet4Address) || !inetAddress.isSiteLocalAddress() || !inetAddress.isReachable(3000)) continue;
                    try {
                        SocketChannel socket = SocketChannel.open();
                        try {
                            socket.socket().setSoTimeout(3000);
                            socket.bind(new InetSocketAddress(inetAddress, 8080));
                            socket.connect(new InetSocketAddress("google.com", 80));
                            this.netWorkInterface = ni;
                            this.ipAddress = inetAddress;
                            byte[] hardwareAddress = this.netWorkInterface.getHardwareAddress();
                            if (hardwareAddress == null) continue;
                            CharSequence[] hexadecimalFormat = new String[hardwareAddress.length];
                            for (int i = 0; i < hardwareAddress.length; ++i) {
                                hexadecimalFormat[i] = String.format("%02X", hardwareAddress[i]);
                            }
                            this.macAddress = String.join((CharSequence)"-", hexadecimalFormat);
                            System.out.println(this.netWorkInterface.getDisplayName() + " " + this.macAddress);
                        }
                        finally {
                            if (socket == null) continue;
                            socket.close();
                        }
                    }
                    catch (IOException ex) {
                        log.info((Object)("skipping network interface " + ni.getDisplayName()));
                    }
                }
            }
        }
        catch (IOException e) {
            log.error(e);
        }
    }

    public NetworkInterface getNetWorkInterface() {
        return this.netWorkInterface;
    }

    public InetAddress getIpAddress() {
        return this.ipAddress;
    }

    public String getMacAddress() {
        return this.macAddress;
    }
}

