/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.utils;

import java.io.Serializable;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiFunction;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;

public class DatosPersonales
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String OID;
    private String OI;
    private String C;
    private String ST;
    private String L;
    private String EMAILADDRESS;
    private String SERIALNUMBER;
    private String CN;
    private String SURNAME;
    private String GIVENNAME;
    private String O;
    private String OU;
    private String T;
    private RDN[] fields;
    private Map<String, List<String>> allFields = new TreeMap<String, List<String>>();

    public DatosPersonales() {
    }

    public DatosPersonales(X509Certificate cert) throws CertificateEncodingException {
        this(new JcaX509CertificateHolder(cert).getSubject());
    }

    public DatosPersonales(X500Principal subject) {
        this(new X500Name(subject.getName()));
    }

    public DatosPersonales(String subject) {
        this(new X500Principal(subject));
    }

    public DatosPersonales(X500Name subject) {
        this.fields = subject.getRDNs();
        DatosPersonales.matchRDNValue(this.fields, (ASN1ObjectIdentifier oid, ASN1Encodable value) -> {
            String textValue = IETFUtils.valueToString((ASN1Encodable)value);
            if (oid.equals((ASN1Primitive)BCStyle.C)) {
                this.C = textValue;
            } else if (oid.equals((ASN1Primitive)BCStyle.ST)) {
                this.ST = textValue;
            } else if (oid.equals((ASN1Primitive)BCStyle.L)) {
                this.L = textValue;
            } else if (oid.equals((ASN1Primitive)BCStyle.EmailAddress)) {
                this.EMAILADDRESS = textValue;
            } else if (oid.equals((ASN1Primitive)BCStyle.SERIALNUMBER)) {
                this.SERIALNUMBER = textValue;
            } else if (oid.equals((ASN1Primitive)BCStyle.CN)) {
                this.CN = textValue;
            } else if (oid.equals((ASN1Primitive)BCStyle.SURNAME)) {
                this.SURNAME = textValue;
            } else if (oid.equals((ASN1Primitive)BCStyle.GIVENNAME)) {
                this.GIVENNAME = textValue;
            } else if (oid.equals((ASN1Primitive)BCStyle.O)) {
                this.O = textValue;
            } else if (oid.equals((ASN1Primitive)BCStyle.OU)) {
                this.OU = textValue;
            } else if (oid.equals((ASN1Primitive)BCStyle.T)) {
                this.T = textValue;
            } else if (oid.equals((ASN1Primitive)BCStyle.ORGANIZATION_IDENTIFIER)) {
                this.OI = textValue;
            } else if (oid.getId().equals("1.3.6.1.4.1.18838.1.1")) {
                this.OID = textValue;
            }
            this.allFields.putIfAbsent(oid.getId(), this.allFields.computeIfAbsent(oid.getId(), v -> new ArrayList<String>(List.of(textValue))));
            return null;
        });
    }

    public List<String> getValues(ASN1ObjectIdentifier oid) {
        return this.allFields.get(oid.getId());
    }

    public String getFirstValue(ASN1ObjectIdentifier oid) {
        List<String> list = this.allFields.get(oid.getId());
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public <R> R matchRDNValue(BiFunction<ASN1ObjectIdentifier, ASN1Encodable, R> action) {
        return DatosPersonales.matchRDNValue(this.fields, action);
    }

    public static <R> R matchRDNValue(RDN[] fields, BiFunction<ASN1ObjectIdentifier, ASN1Encodable, R> action) {
        R result = null;
        for (int i = 0; result == null && i < fields.length; ++i) {
            result = DatosPersonales.matchRDNValue(fields[i], action);
        }
        return result;
    }

    public static <R> R matchRDNValue(RDN field, BiFunction<ASN1ObjectIdentifier, ASN1Encodable, R> action) {
        R result = null;
        AttributeTypeAndValue[] typesAndValues = field.getTypesAndValues();
        for (int v = 0; result == null && v < typesAndValues.length; ++v) {
            AttributeTypeAndValue attributeTypeAndValue = typesAndValues[v];
            ASN1ObjectIdentifier oid = attributeTypeAndValue.getType();
            ASN1Encodable value = attributeTypeAndValue.getValue();
            result = action.apply(oid, value);
        }
        return result;
    }

    public String getOI() {
        return this.OI;
    }

    public String getOID() {
        return this.OID;
    }

    public String getC() {
        return this.C;
    }

    public String getST() {
        return this.ST;
    }

    public String getL() {
        return this.L;
    }

    public String getEMAILADDRESS() {
        return this.EMAILADDRESS;
    }

    public String getSERIALNUMBER() {
        return this.SERIALNUMBER;
    }

    public String getCN() {
        return this.CN;
    }

    public String getSURNAME() {
        return this.SURNAME;
    }

    public String getGIVENNAME() {
        return this.GIVENNAME;
    }

    public String getO() {
        return this.O;
    }

    public String getOU() {
        return this.OU;
    }

    public String getT() {
        return this.T;
    }
}

