/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.utils;

import com.anf.cryptotoken.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class CifradoXML {
    private static final Logger log = Logger.getLogger(CifradoXML.class);

    public static String asHex(byte[] buf) {
        StringBuffer strbuf = new StringBuffer(buf.length * 2);
        for (int i = 0; i < buf.length; ++i) {
            if ((buf[i] & 0xFF) < 16) {
                strbuf.append("0");
            }
            strbuf.append(Long.toString(buf[i] & 0xFF, 16));
        }
        return strbuf.toString();
    }

    public static boolean decrypt(String psw, String fileencrypted, String filenameout) {
        try {
            FileInputStream fi = new FileInputStream(fileencrypted);
            FileOutputStream fo = new FileOutputStream(filenameout);
            return CifradoXML.decrypt(psw, fi, fo);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean decrypt(String psw, InputStream encrypted, OutputStream out) {
        try {
            byte[] salt = new byte[8];
            encrypted.read(salt, 0, 8);
            byte[] CipherIV = new byte[16];
            encrypted.read(CipherIV, 0, 16);
            MessageDigest msgDigest = MessageDigest.getInstance("MD5");
            msgDigest.update(salt);
            msgDigest.update(psw.getBytes());
            byte[] keyScretD = msgDigest.digest();
            SecretKeySpec skeySpec = new SecretKeySpec(keyScretD, "AES");
            IvParameterSpec algParam = new IvParameterSpec(CipherIV, 0, 16);
            Cipher cipher = Cipher.getInstance("AES/OFB/NoPadding");
            cipher.init(2, (Key)skeySpec, algParam);
            byte[] input = IOUtils.toByteArray((InputStream)encrypted);
            byte[] doFinal = cipher.doFinal(input);
            out.write(doFinal);
            out.close();
            return true;
        }
        catch (Exception ex) {
            log.error(ex);
            return false;
        }
    }

    public static boolean decryptFile(FileInputStream encrypted, OutputStream out, String key) throws Throwable {
        byte[] salt = new byte[8];
        encrypted.read(salt, 0, 8);
        byte[] CipherIV = new byte[16];
        encrypted.read(CipherIV, 0, 16);
        MessageDigest msgDigest = MessageDigest.getInstance("MD5");
        msgDigest.update(salt);
        msgDigest.update(key.getBytes());
        try {
            byte[] secret = msgDigest.digest();
            SecretKeySpec skey = new SecretKeySpec(secret, "AES");
            IvParameterSpec algParam = new IvParameterSpec(CipherIV, 0, 16);
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            cipher.init(2, (Key)skey, algParam);
            byte[] input = IOUtils.toByteArray((InputStream)encrypted);
            byte[] doFinal = cipher.doFinal(input);
            out.write(doFinal);
            out.close();
            return true;
        }
        catch (Exception e) {
            log.warn((Object)e);
            return false;
        }
    }

    public static byte[] getRandomKey(int count) {
        byte[] result = new byte[count];
        for (int cont = 0; cont < count; ++cont) {
            result[cont] = (byte)(Math.random() * 100.0);
        }
        return result;
    }

    public static boolean encrypt(String psw, InputStream original, OutputStream out) {
        try {
            Cipher cipher = Cipher.getInstance("AES/OFB/NoPadding");
            byte[] salt = CifradoXML.getRandomKey(8);
            out.write(salt);
            byte[] CipherIV = CifradoXML.getRandomKey(16);
            out.write(CipherIV);
            MessageDigest msgDigest = MessageDigest.getInstance("MD5");
            msgDigest.update(salt);
            msgDigest.update(psw.getBytes());
            byte[] keyScretD = msgDigest.digest();
            SecretKeySpec skeySpec = new SecretKeySpec(keyScretD, "AES");
            IvParameterSpec algParam = new IvParameterSpec(CipherIV, 0, 16);
            cipher.init(1, (Key)skeySpec, algParam);
            out = new CipherOutputStream(out, cipher);
            IOUtils.copy((InputStream)original, (OutputStream)out);
            out.flush();
            out.close();
            return true;
        }
        catch (Exception ex) {
            log.error(ex);
            return false;
        }
    }

    public static void getProviderInformation() {
        Provider[] provList = Security.getProviders();
        for (int i = 0; i < provList.length; ++i) {
            ArrayList<Object> keyList = new ArrayList<Object>(provList[i].keySet());
            Collections.sort(keyList);
            for (String string : keyList) {
                log.info((Object)("Information - \t" + string + ": " + provList[i].getProperty(string)));
            }
        }
        Set<String> AlgorithmSet = Security.getAlgorithms("Cipher");
        Iterator<String> it = AlgorithmSet.iterator();
        while (it.hasNext()) {
            log.info((Object)("Information - " + it.next().toString()));
        }
    }

    private static InputStream fromStringBuffer(StringBuffer buf) throws UnsupportedEncodingException {
        return new ByteArrayInputStream(buf.toString().getBytes("UTF-8"));
    }

    public static void identXml(StringBuffer xmlData, OutputStream out) throws SAXException, IOException, ParserConfigurationException, IllegalArgumentException, TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException {
        InputStream fromStringBuffer = CifradoXML.fromStringBuffer(xmlData);
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(fromStringBuffer);
        DOMSource source = new DOMSource(doc);
        StreamResult streamResult = new StreamResult(out);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        transformer.transform(source, streamResult);
    }
}

