/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.utils;

import com.anf.cert.utils.CertUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1IA5String;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;

public class CertURLUtils {
    public static final String ID_PKCS7_DATA = "1.2.840.113549.1.7.1";
    public static final String ID_PKCS7_SIGNED_DATA = "1.2.840.113549.1.7.2";
    public static final String ID_RSA = "1.2.840.113549.1.1.1";
    public static final String ID_DSA = "1.2.840.10040.4.1";
    public static final String ID_ECDSA = "1.2.840.10045.2.1";
    public static final String ID_CONTENT_TYPE = "1.2.840.113549.1.9.3";
    public static final String ID_MESSAGE_DIGEST = "1.2.840.113549.1.9.4";
    public static final String ID_SIGNING_TIME = "1.2.840.113549.1.9.5";
    public static final String ID_ADBE_REVOCATION = "1.2.840.113583.1.1.8";
    public static final String ID_TSA = "1.2.840.113583.1.1.9.1";
    public static final String ID_OCSP = "1.3.6.1.5.5.7.48.1";
    public static final String ID_AA_SIGNING_CERTIFICATE_V1 = "1.2.840.113549.1.9.16.2.12";
    public static final String ID_AA_SIGNING_CERTIFICATE_V2 = "1.2.840.113549.1.9.16.2.47";

    public static CRL getCRL(X509Certificate certificate) throws CertificateException, CRLException, IOException {
        return CertURLUtils.getCRL(CertURLUtils.getCRLURL(certificate));
    }

    public static String getCRLURL(X509Certificate certificate) {
        DistributionPoint[] dists;
        ASN1Primitive obj;
        try {
            obj = CertUtils.getExtensionValue((X509Certificate)certificate, (String)Extension.cRLDistributionPoints.getId());
        }
        catch (IOException e) {
            obj = null;
        }
        if (obj == null) {
            return null;
        }
        CRLDistPoint dist = CRLDistPoint.getInstance((Object)obj);
        for (DistributionPoint p : dists = dist.getDistributionPoints()) {
            GeneralName[] names;
            DistributionPointName distributionPointName = p.getDistributionPoint();
            if (0 != distributionPointName.getType()) continue;
            GeneralNames generalNames = (GeneralNames)distributionPointName.getName();
            for (GeneralName name : names = generalNames.getNames()) {
                if (name.getTagNo() != 6) continue;
                ASN1IA5String derStr = ASN1IA5String.getInstance((ASN1TaggedObject)((ASN1TaggedObject)name.toASN1Primitive()), (boolean)false);
                return derStr.getString();
            }
        }
        return null;
    }

    public static CRL getCRL(String url) throws IOException, CertificateException, CRLException {
        if (url == null) {
            return null;
        }
        try (InputStream is = new URL(url).openStream();){
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            CRL cRL = cf.generateCRL(is);
            return cRL;
        }
    }

    public static String getOCSPURL(X509Certificate certificate) {
        try {
            ASN1Primitive obj = CertUtils.getExtensionValue((X509Certificate)certificate, (String)Extension.authorityInfoAccess.getId());
            if (obj == null) {
                return null;
            }
            ASN1Sequence accessDescriptions = (ASN1Sequence)obj;
            for (int i = 0; i < accessDescriptions.size(); ++i) {
                ASN1ObjectIdentifier id;
                ASN1Encodable aSN1Encodable;
                ASN1Sequence accessDescription = (ASN1Sequence)accessDescriptions.getObjectAt(i);
                if (accessDescription.size() != 2 || !((aSN1Encodable = accessDescription.getObjectAt(0)) instanceof ASN1ObjectIdentifier) || !ID_OCSP.equals((id = (ASN1ObjectIdentifier)aSN1Encodable).getId())) continue;
                ASN1Primitive description = (ASN1Primitive)accessDescription.getObjectAt(1);
                String accessLocation = CertURLUtils.getStringFromGeneralName(description);
                if (accessLocation == null) {
                    return "";
                }
                return accessLocation;
            }
        }
        catch (IOException e) {
            return null;
        }
        return null;
    }

    public static String getTSAURL(X509Certificate certificate) {
        byte[] der = certificate.getExtensionValue(ID_TSA);
        if (der == null) {
            return null;
        }
        try {
            ASN1Primitive asn1obj = ASN1Primitive.fromByteArray((byte[])der);
            DEROctetString octets = (DEROctetString)asn1obj;
            asn1obj = ASN1Primitive.fromByteArray((byte[])octets.getOctets());
            ASN1Sequence asn1seq = ASN1Sequence.getInstance((Object)asn1obj);
            return CertURLUtils.getStringFromGeneralName(asn1seq.getObjectAt(1).toASN1Primitive());
        }
        catch (IOException e) {
            return null;
        }
    }

    private static String getStringFromGeneralName(ASN1Primitive names) {
        if (names instanceof ASN1TaggedObject) {
            ASN1TaggedObject taggedObject = (ASN1TaggedObject)names;
            return new String(ASN1OctetString.getInstance((ASN1TaggedObject)taggedObject, (boolean)false).getOctets(), StandardCharsets.ISO_8859_1);
        }
        return null;
    }
}

