/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.utils;

import com.anf.cert.utils.CertUtils;
import com.anf.cryptotoken.log.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.tsp.cms.CMSTimeStampedData;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;

public class CMSUtils {
    private static final Logger log = Logger.getLogger(CMSUtils.class);

    public static X509Certificate[] getCertificates(CMSSignedData data) throws CertificateException {
        SignerInformation sigInfo = (SignerInformation)data.getSignerInfos().getSigners().iterator().next();
        Store certificates = data.getCertificates();
        return CMSUtils.getCertificates(certificates, sigInfo);
    }

    public static X509Certificate[] getCertificates(Store certificates, SignerInformation sigInfo) throws CertificateException {
        SignerId sid = null;
        if (sigInfo != null) {
            sid = sigInfo.getSID();
        }
        Collection matches = certificates.getMatches((Selector)sid);
        X509Certificate[] chain = new X509Certificate[matches.size()];
        int i = 0;
        for (Object object : matches) {
            X509CertificateHolder certHolder = (X509CertificateHolder)object;
            X509Certificate cert = new JcaX509CertificateConverter().setProvider("BC").getCertificate(certHolder);
            chain[i++] = cert;
        }
        if (chain.length == 1) {
            X509Certificate signCert = chain[0];
            matches = certificates.getMatches(null);
            chain = new X509Certificate[matches.size()];
            i = 0;
            for (Object object : matches) {
                X509CertificateHolder certHolder = (X509CertificateHolder)object;
                X509Certificate cert = new JcaX509CertificateConverter().setProvider("BC").getCertificate(certHolder);
                chain[i++] = cert;
            }
            ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
            certs.add(signCert);
            if (!CertUtils.isSelfSigned((X509Certificate)signCert)) {
                X509Certificate issuer = signCert;
                while (issuer != null) {
                    if ((issuer = CertUtils.getIssuerCertificate((X509Certificate[])chain, (X509Certificate)issuer)) == null) continue;
                    certs.add(issuer);
                    if (!CertUtils.isRootCert((X509Certificate)issuer) && !CertUtils.isSelfSigned((X509Certificate)issuer)) continue;
                }
            }
            chain = new X509Certificate[certs.size()];
            certs.toArray(chain);
            return chain;
        }
        return chain;
    }

    public static Object extractCMS(CMSProcessable cmsProcessableFile, InputStream stream) throws CMSException, IOException {
        Object data = null;
        byte[] signed = IOUtils.toByteArray((InputStream)stream);
        Object signedData = CMSUtils.isTSP(signed);
        data = signedData != null && signedData instanceof CMSTimeStampedData ? (CMSTimeStampedData)signedData : (cmsProcessableFile == null ? new CMSSignedData(signed) : new CMSSignedData(cmsProcessableFile, signed));
        return data;
    }

    public static Object isTSP(byte[] signed) {
        try {
            CMSTimeStampedData tsd = new CMSTimeStampedData(signed);
            return tsd;
        }
        catch (IOException e) {
            log.info((Object)"NO CMSTimeStampedData detected");
            return null;
        }
    }

    public static X509Certificate[] getCertificates(InputStream pkcs7Response) throws CMSException, CertificateException {
        CMSSignedData data = new CMSSignedData(pkcs7Response);
        Store store = data.getCertificates();
        Collection hold = store.getMatches(null);
        Iterator it = hold.iterator();
        X509Certificate[] chain = new X509Certificate[hold.size()];
        int x = 0;
        while (it.hasNext()) {
            X509CertificateHolder hold1 = (X509CertificateHolder)it.next();
            chain[x] = new JcaX509CertificateConverter().setProvider("BC").getCertificate(hold1);
            ++x;
        }
        return chain;
    }
}

