/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.oid;

import com.anf.cryptotoken.oid.PolicyOID;
import com.anf.cryptotoken.oid.ProfilePolicy;
import com.anf.cryptotoken.qc.QcStatementsOID;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class QcpPolicy {
    private String policyOid;
    private boolean qcNaturalRepresentanteSoftware = false;
    private boolean qcNaturalRepresentanteQscd = true;
    private Set<String> qcpNaturalPolicies = new TreeSet<String>();
    private Set<String> qcpNaturalQscdPolicies = new TreeSet<String>();
    private Set<String> qcpLegalPolicies = new TreeSet<String>();
    private Set<String> qcpLegalQscdPolicies = new TreeSet<String>();

    public QcpPolicy(String policyOid, boolean qcNaturalRepresentanteSoftware, boolean qcNaturalRepresentanteQscd) {
        this.policyOid = policyOid;
        this.qcNaturalRepresentanteSoftware = qcNaturalRepresentanteSoftware;
        this.qcNaturalRepresentanteQscd = qcNaturalRepresentanteQscd;
        PolicyOID policy = PolicyOID.fromOid(policyOid);
        if (policy != null) {
            this.fillQcpNaturalPolicies(policy);
            this.fillQcpNaturalQscdPolicies(policy);
            this.fillRLPolicies(policy);
            this.fillEmpleadoPolicies(policy);
            this.fillRLPoliciesQSCD(policy);
            this.fillSealPolicies(policy);
            this.fillSealQSCDPolicies(policy);
        }
    }

    private void fillSealPolicies(PolicyOID policy) {
        List<String> repLegalPolicies = Arrays.asList(policy.oid(ProfilePolicy.QSeal_Software), policy.oid(ProfilePolicy.QSeal_AP_Software), policy.oid(ProfilePolicy.QSeal_PSD2_Software), policy.oid(ProfilePolicy.QSeal_DistClaves), policy.oid(ProfilePolicy.QSeal_AP_DistClaves), policy.oid(ProfilePolicy.QSeal_PSD2_DistClaves));
        this.qcpLegalPolicies.addAll(repLegalPolicies);
    }

    private void fillSealQSCDPolicies(PolicyOID policy) {
        List<String> repLegalPolicies = Arrays.asList(policy.oid(ProfilePolicy.QSeal_QSCD), policy.oid(ProfilePolicy.QSeal_AP_QSCD), policy.oid(ProfilePolicy.QSeal_PSD2_QSCD), policy.oid(ProfilePolicy.QSeal_Centralizado), policy.oid(ProfilePolicy.QSeal_AP_Centralizado), policy.oid(ProfilePolicy.QSeal_PSD2_Centralizado));
        this.qcpLegalQscdPolicies.addAll(repLegalPolicies);
    }

    public QcpPolicy(String policyOid) {
        this(policyOid, false, true);
    }

    private void fillRLPolicies(PolicyOID policy) {
        List<String> repLegalPolicies = Arrays.asList(policy.oid(ProfilePolicy.RL_PJ_Firma), ProfilePolicy.RL_PJ_Firma_SegSocial.getOid(), policy.oid(ProfilePolicy.RL_AU_Firma), policy.oid(ProfilePolicy.RL_SPJ_Firma));
        if (this.qcNaturalRepresentanteSoftware) {
            this.qcpNaturalPolicies.addAll(repLegalPolicies);
        } else {
            this.qcpLegalPolicies.addAll(repLegalPolicies);
        }
    }

    private void fillEmpleadoPolicies(PolicyOID policy) {
        this.qcpNaturalPolicies.add(policy.oid(ProfilePolicy.EP_Medio_Firma));
        this.qcpNaturalQscdPolicies.add(policy.oid(ProfilePolicy.EP_Alto_Firma));
    }

    private void fillRLPoliciesQSCD(PolicyOID policy) {
        List<String> repLegalPolicies = Arrays.asList(policy.oid(ProfilePolicy.RL_PJ_Firma_QSCD), policy.oid(ProfilePolicy.RL_PJ_Firma_Centralizado), policy.oid(ProfilePolicy.RL_AU_Firma_QSCD), policy.oid(ProfilePolicy.RL_AU_Firma_Centralizado), policy.oid(ProfilePolicy.RL_SPJ_Firma_QSCD), policy.oid(ProfilePolicy.RL_SPJ_Firma_Centralizado));
        if (this.qcNaturalRepresentanteQscd) {
            this.qcpNaturalQscdPolicies.addAll(repLegalPolicies);
        } else {
            this.qcpLegalQscdPolicies.addAll(repLegalPolicies);
        }
    }

    private void fillQcpNaturalPolicies(PolicyOID policy) {
        this.qcpNaturalPolicies.addAll(Arrays.asList(policy.oid(ProfilePolicy.PF_Firma), policy.oid(ProfilePolicy.PFC_Firma), policy.oid(ProfilePolicy.AR_Firma), policy.oid(ProfilePolicy.RDE_Firma), policy.oid(ProfilePolicy.PKI_Firma)));
    }

    private void fillQcpNaturalQscdPolicies(PolicyOID policy) {
        this.qcpNaturalQscdPolicies.addAll(Arrays.asList(policy.oid(ProfilePolicy.PF_Firma_Centralizado), policy.oid(ProfilePolicy.PF_Firma_QSCD), policy.oid(ProfilePolicy.PFC_Firma_Centralizado), policy.oid(ProfilePolicy.PFC_Firma_QSCD)));
    }

    private String getQcpLegalOid(boolean qscd) {
        return qscd ? QcStatementsOID.qcp_legal_qscd.getId() : QcStatementsOID.qcp_legal.getId();
    }

    private String getQcpNaturalOid(boolean qscd) {
        return qscd ? QcStatementsOID.qcp_natural_qscd.getId() : QcStatementsOID.qcp_natural.getId();
    }

    public void setQcNaturalRepresentanteQscd(boolean qcNaturalRepresentanteQscd) {
        this.qcNaturalRepresentanteQscd = qcNaturalRepresentanteQscd;
    }

    public void setQcNaturalRepresentanteSoftware(boolean qcNaturalRepresentanteSoftware) {
        this.qcNaturalRepresentanteSoftware = qcNaturalRepresentanteSoftware;
    }

    public String getQcpOId() {
        if (this.qcpNaturalPolicies.contains(this.policyOid)) {
            return this.getQcpNaturalOid(false);
        }
        if (this.qcpNaturalQscdPolicies.contains(this.policyOid)) {
            return this.getQcpNaturalOid(true);
        }
        if (this.qcpLegalPolicies.contains(this.policyOid)) {
            return this.getQcpLegalOid(false);
        }
        if (this.qcpLegalQscdPolicies.contains(this.policyOid)) {
            return this.getQcpLegalOid(true);
        }
        return null;
    }
}

