/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.oid;

import com.anf.cert.utils.CertType;

public enum ProfilePolicy {
    PF_Firma("3.4.1.2.22"),
    PF_Firma_Centralizado("3.4.1.5.22"),
    PF_Firma_QSCD("3.4.1.4.22"),
    PF_Auth("3.4.1.1.22"),
    PF_Cifrado("3.4.1.3.22"),
    PFC_Firma("3.4.1.6.22"),
    PFC_Firma_QSCD("3.4.1.7.22"),
    PFC_Firma_Centralizado("3.4.1.8.22"),
    CC_Firma("3.4.1.9.22"),
    CC_Firma_QSCD("3.4.1.10.22"),
    CC_Firma_Centralizado("3.4.1.11.22"),
    AR_Firma("22.1.3.22"),
    RDE_Firma("23.1.4.22"),
    PKI_Firma("23.1.6.22"),
    PKI_ADMIN_Firma("23.1.6.23"),
    RL_SPJ_Firma("2.5.1.6"),
    RL_SPJ_Firma_Centralizado("2.5.1.15"),
    RL_SPJ_Firma_QSCD("2.5.1.11"),
    RL_SPJ_Auth("2.5.1.4"),
    RL_SPJ_Cifrado("2.5.1.5"),
    RL_AU_Firma("2.5.1.9"),
    RL_AU_Firma_Centralizado("2.5.1.13"),
    RL_AU_Firma_QSCD("2.5.1.12"),
    RL_AU_Auth("2.5.1.7"),
    RL_AU_Cifrado("2.5.1.8"),
    RL_PJ_Firma("2.5.1.3"),
    RL_PJ_Firma_Centralizado("2.5.1.14"),
    RL_PJ_Firma_QSCD("2.5.1.10"),
    RL_PJ_Auth("2.5.1.1"),
    RL_PJ_Cifrado("2.5.1.2"),
    RL_PJ_Firma_SegSocial("2.16.724.1.3.5.8"),
    RL_SPJ_Firma_SegSocial("2.16.724.1.3.5.9"),
    EP_Alto_Firma("4.1.3.22"),
    EP_Medio_Firma("4.1.2.22"),
    EP_Alto_Firma_SegSocial("2.16.724.1.3.5.7.1"),
    EP_Medio_Firma_SegSocial("2.16.724.1.3.5.7.2"),
    PN_Archivo("2.1.1"),
    PN_DSCF("2.1.2"),
    ME_ERD_Archivo("2.2.1"),
    ME_ERD_DSCF("2.2.2"),
    RL_Archivo("2.3.1"),
    RL_DSCF("2.3.2"),
    QSEAL_Archivo("2.4.1"),
    QSEAL_DSCF("2.4.2"),
    TSU_EC("2.6.1"),
    QSeal_Software("25.1.1.1"),
    QSeal_QSCD("25.1.1.4"),
    QSeal_Centralizado("25.1.1.9"),
    QSeal_DistClaves("25.1.1.10"),
    QSeal_PSD2_Software("25.1.1.5"),
    QSeal_PSD2_QSCD("25.1.1.6"),
    QSeal_PSD2_Centralizado("25.1.1.7"),
    QSeal_PSD2_DistClaves("25.1.1.8"),
    QSeal_AP_Software("25.1.1.3"),
    QSeal_AP_QSCD("25.1.1.2"),
    QSeal_AP_Centralizado("25.1.1.11"),
    QSeal_AP_DistClaves("25.1.1.12"),
    SSL_DV("55.1.1.1.322"),
    SSL_OV("55.1.1.7.322"),
    SSL_EV("55.1.1.2.322"),
    SSL_PSD2("55.1.1.8.322"),
    SSL_IV("55.1.1.10.322"),
    SSL_DV_OLD("55.1.1.1.22"),
    SSL_OV_OLD("55.1.1.7.22"),
    SSL_EV_OLD("55.1.1.2.22"),
    SSL_PSD2_OLD("55.1.1.8.22"),
    SSL_IV_OLD("55.1.1.10.22"),
    SEDE_EV_ALTO("55.1.1.6.322"),
    SEDE_EV_MEDIO("55.1.1.5.322"),
    SEDE_EV_ALTO_OLD("55.1.1.6.22"),
    SEDE_EV_MEDIO_OLD("55.1.1.5.22"),
    OCSP("56.1.1"),
    TSU("15.1");

    String oid;

    private ProfilePolicy(String oid) {
        this.oid = oid;
    }

    public String getOid() {
        return this.oid;
    }

    public static boolean isQSCD(ProfilePolicy profile) {
        return profile != null && (profile.name().contains("QSCD") || profile.name().contains("DSCF") || profile == EP_Alto_Firma);
    }

    public static boolean isCentral(ProfilePolicy profile) {
        return profile != null && (profile.name().contains("Centralizado") || profile == EP_Alto_Firma);
    }

    public static boolean isPFC(ProfilePolicy profile) {
        return profile != null && profile.name().startsWith("PFC_");
    }

    public static boolean isPF(ProfilePolicy profile) {
        return profile != null && profile.name().startsWith("PF_");
    }

    public static boolean isRL(ProfilePolicy profile) {
        return profile != null && profile.name().startsWith("RL_");
    }

    public static boolean isEP(ProfilePolicy profile) {
        return profile != null && profile.name().startsWith("EP_");
    }

    public static boolean isSSL(ProfilePolicy profile) {
        return profile != null && profile.name().startsWith("SSL_");
    }

    public static boolean isQSealAP(ProfilePolicy profile) {
        return profile != null && profile.name().startsWith("QSeal_AP");
    }

    public static boolean isQSeal(ProfilePolicy profile) {
        return profile != null && (profile.name().startsWith("QSeal_") || profile.name().startsWith("QSEAL_"));
    }

    public static boolean isQSealPSD2(ProfilePolicy profile) {
        return profile != null && profile.name().startsWith("QSeal_PSD2");
    }

    public static boolean isSede(ProfilePolicy profile) {
        return profile != null && profile.name().startsWith("SEDE_");
    }

    public CertType getCertType() {
        if (this.name().contains("Firma")) {
            return CertType.signature;
        }
        if (ProfilePolicy.isQSeal(this)) {
            return CertType.seal;
        }
        if (this.name().endsWith("Archivo") || this.name().endsWith("DSCF")) {
            return CertType.signature;
        }
        if (this.name().contains("Auth")) {
            return CertType.auth;
        }
        if (this.name().contains("Cifrado")) {
            return CertType.cipher;
        }
        return CertType.unknokn;
    }
}

