/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.oid;

import com.anf.cryptotoken.oid.ProfilePolicy;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;

public class PolicyOID {
    public static final ASN1ObjectIdentifier root = new ASN1ObjectIdentifier("1.3.6.1.4.1");
    private String ianaCode;

    private PolicyOID(String ianaCode) {
        this.ianaCode = ianaCode;
    }

    public static PolicyOID fromIANACode(String ianaCode) {
        return new PolicyOID(ianaCode);
    }

    public ASN1ObjectIdentifier policyRoot() {
        return root.branch(this.ianaCode);
    }

    public final String oid(ProfilePolicy policy) {
        return this.policyRoot().branch(policy.getOid()).getId();
    }

    public static PolicyOID fromOid(String policyOID) {
        String id = root.getId();
        if (policyOID.startsWith(id)) {
            int nextPoint = (policyOID = policyOID.substring(id.length() + 1)).indexOf(".");
            if (nextPoint > 0) {
                policyOID = policyOID.substring(0, nextPoint);
            }
            return new PolicyOID(policyOID);
        }
        return null;
    }

    public String getIanaCode() {
        return this.ianaCode;
    }

    public static ProfilePolicy getProfilePolicy(String oid) {
        PolicyOID policy = PolicyOID.fromOid(oid);
        if (policy != null) {
            ProfilePolicy[] values;
            for (ProfilePolicy profilePolicy : values = ProfilePolicy.values()) {
                if (!oid.equals(policy.policyRoot().branch(profilePolicy.getOid()).getId())) continue;
                return profilePolicy;
            }
        }
        return null;
    }
}

