/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.oid;

import com.anf.cert.utils.CertType;
import com.anf.cert.utils.CertUtils;
import com.anf.cryptotoken.oid.IANACode;
import com.anf.cryptotoken.oid.PolicyOID;
import com.anf.cryptotoken.oid.QcStatementsUtils;
import com.anf.cryptotoken.qc.QcStatementsOID;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.UnaryOperator;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1UTF8String;
import org.bouncycastle.asn1.DERUTF8String;

public class OIDUtils {
    public static PolicyOID getIANACode(X509Certificate cert) {
        List policyOids = CertUtils.getPolicyOids((X509Certificate)cert);
        for (String oid : policyOids) {
            PolicyOID policyOid = PolicyOID.fromOid(oid);
            if (policyOid == null) continue;
            return policyOid;
        }
        return null;
    }

    public static String getMainPolicy(X509Certificate cert) throws IOException {
        List policyOids = CertUtils.getPolicyOids((X509Certificate)cert);
        for (String oid : policyOids) {
            PolicyOID policyOid = PolicyOID.fromOid(oid);
            if (policyOid == null) continue;
            return oid;
        }
        throw new IOException("ERR_NO_MAIN_POLICY");
    }

    public static byte[] getExtensionValue(X509Certificate cert, UnaryOperator<ASN1ObjectIdentifier> transform) {
        ASN1ObjectIdentifier oid;
        byte[] val = null;
        PolicyOID ianaCode = OIDUtils.getIANACode(cert);
        if (ianaCode != null && (val = cert.getExtensionValue((oid = (ASN1ObjectIdentifier)transform.apply(ianaCode.policyRoot())).toString())) == null) {
            ianaCode = PolicyOID.fromIANACode(IANACode.ANF_ES.getIanaCode());
            oid = (ASN1ObjectIdentifier)transform.apply(ianaCode.policyRoot());
            val = cert.getExtensionValue(oid.toString());
        }
        return val;
    }

    public static String getLocalizator(X509Certificate cert) {
        String localizator = null;
        byte[] val = OIDUtils.getExtensionValue(cert, oid -> oid.branch("19"));
        if (val != null) {
            localizator = OIDUtils.parseUTF8StringValue(val);
        }
        return localizator;
    }

    public static String findOid(X509Certificate cert, String oid) throws IOException {
        String result = null;
        Set<String> nonCriticalExtensionOIDs = cert.getNonCriticalExtensionOIDs();
        TreeSet<String> extensions = new TreeSet<String>(nonCriticalExtensionOIDs);
        extensions.addAll(cert.getCriticalExtensionOIDs());
        for (String extOid : extensions) {
            System.out.println("buscando oid " + oid + " dentro de extension " + extOid);
            byte[] value = cert.getExtensionValue(extOid);
            if (value == null || (result = OIDUtils.findOid(extOid, value, oid)) == null) continue;
            break;
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    private static String findOid(String parentOid, byte[] value, String oid) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 19[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String findOid(String parentOid, ASN1Sequence seq, String oid) throws IOException {
        Iterator iterator;
        ArrayList<ASN1Encodable> objects = Collections.list(seq.getObjects());
        if (objects.size() == 2 && (iterator = objects.get(0)) instanceof ASN1ObjectIdentifier) {
            ASN1ObjectIdentifier id = (ASN1ObjectIdentifier)iterator;
            if (!(objects.get(1) instanceof ASN1ObjectIdentifier)) {
                return OIDUtils.findOid(id.getId(), ((ASN1Encodable)objects.get(1)).toASN1Primitive().getEncoded(), oid);
            }
        }
        for (ASN1Encodable obj : objects) {
            String result = OIDUtils.findOid(parentOid, obj.toASN1Primitive().getEncoded(), oid);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static String getStringExtensionValue(X509Certificate cert, String oid) {
        byte[] value = cert.getExtensionValue(oid);
        if (value != null) {
            return OIDUtils.parseUTF8StringValue(value);
        }
        return null;
    }

    public static String getPolicyExtensionValue(X509Certificate cert, String oidBranch) {
        if (cert == null) {
            return null;
        }
        PolicyOID ianaCode = OIDUtils.getIANACode(cert);
        if (ianaCode == null) {
            return null;
        }
        return OIDUtils.getStringExtensionValue(cert, ianaCode.policyRoot().branch(oidBranch).getId());
    }

    public static String parseUTF8StringValue(byte[] value) {
        byte[] octets = ASN1OctetString.getInstance((Object)value).getOctets();
        return ASN1UTF8String.getInstance((Object)octets).getString();
    }

    public static String getHashOIDValue(X509Certificate cert) {
        String hash = null;
        byte[] val = OIDUtils.getExtensionValue(cert, oid -> oid.branch("10").branch("10"));
        if (val != null) {
            hash = OIDUtils.parseUTF8StringValue(val);
        }
        return hash;
    }

    public static boolean isRDECert(X509Certificate cert) {
        return OIDUtils.hasPolicyExtension(cert, "42.3");
    }

    public static boolean hasPolicyExtension(X509Certificate cert, String ... oidBranches) {
        if (cert == null || cert.getNonCriticalExtensionOIDs() == null) {
            return false;
        }
        PolicyOID ianaCode = OIDUtils.getIANACode(cert);
        if (ianaCode == null) {
            return false;
        }
        for (String oidBranch : oidBranches) {
            ASN1ObjectIdentifier rdeOid = ianaCode.policyRoot().branch(oidBranch);
            if (!cert.getNonCriticalExtensionOIDs().contains(rdeOid.toString())) continue;
            return true;
        }
        return false;
    }

    public static boolean isARCert(X509Certificate cert) {
        for (int i = 2; i <= 4; ++i) {
            if (!OIDUtils.hasPolicyExtension(cert, "42." + i)) continue;
            return true;
        }
        return false;
    }

    public static boolean isQualified(X509Certificate cert) {
        ASN1ObjectIdentifier subOid;
        PolicyOID ianaCode;
        return cert != null && (ianaCode = OIDUtils.getIANACode(cert)) != null && (OIDUtils.getStringExtensionValue(cert, (subOid = ianaCode.policyRoot().branch("40").branch("1")).toString()) != null || cert.getExtensionValue(subOid.toString()) != null);
    }

    public static String getUseLimitation(X509Certificate cert) {
        return OIDUtils.getPolicyExtensionValue(cert, "59");
    }

    public static boolean isSerialNumerOID(String oid) {
        if (oid.endsWith("47.1")) {
            PolicyOID policy = PolicyOID.fromOid(oid);
            return policy != null && OIDUtils.getSerialNumberOID(policy.policyRoot()).getId().equals(oid);
        }
        return false;
    }

    public static ASN1ObjectIdentifier getSerialNumberOID(ASN1ObjectIdentifier root) {
        return root.branch("47").branch("1");
    }

    public static ASN1ObjectIdentifier startsWithRoot(String oid) {
        PolicyOID policy = PolicyOID.fromOid(oid);
        if (policy != null) {
            return policy.policyRoot();
        }
        return null;
    }

    public static ASN1ObjectIdentifier getHSMOID(ASN1ObjectIdentifier policyRoot) {
        if (policyRoot == null) {
            policyRoot = PolicyOID.fromIANACode(IANACode.ANF_ES.getIanaCode()).policyRoot();
        }
        return policyRoot.branch("47").branch("3");
    }

    public static ASN1EncodableVector getCompanyID(X509Certificate cert) {
        if (cert != null) {
            String val;
            PolicyOID ianaCode = PolicyOID.fromIANACode(IANACode.ANF_ES.getIanaCode());
            ASN1ObjectIdentifier companyOID = null;
            if (ianaCode != null) {
                companyOID = ianaCode.policyRoot().branch("19").branch("2");
            }
            if (companyOID == null && (ianaCode = OIDUtils.getIANACode(cert)) != null) {
                companyOID = ianaCode.policyRoot().branch("19").branch("2");
            }
            if (companyOID != null && (val = OIDUtils.getStringExtensionValue(cert, companyOID.getId())) != null && !val.isEmpty()) {
                ASN1EncodableVector v = new ASN1EncodableVector();
                v.add((ASN1Encodable)companyOID);
                v.add((ASN1Encodable)new DERUTF8String(val));
                return v;
            }
        }
        return null;
    }

    public static boolean isRLPJ(X509Certificate cert) {
        return OIDUtils.checkCertProfilePolicy(cert, ".2.5.1.%s", 1, 2, 3);
    }

    public static boolean isRLSPJ(X509Certificate cert) {
        return OIDUtils.checkCertProfilePolicy(cert, ".2.5.1.%s", 4, 5, 6);
    }

    public static boolean isPF(X509Certificate cert) {
        return OIDUtils.checkCertProfilePolicy(cert, ".3.4.1.%s.22", 1, 2, 3);
    }

    public static boolean isSelloElec(X509Certificate cert) {
        return OIDUtils.checkCertProfilePolicy(cert, ".25.1.1.%s", 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12);
    }

    private static boolean checkCertProfilePolicy(X509Certificate cert, String match, int ... iterator) {
        List policyOids = CertUtils.getPolicyOids((X509Certificate)cert);
        for (String oid : policyOids) {
            PolicyOID policy = PolicyOID.fromOid(oid);
            if (policy == null) continue;
            for (int i = 0; i < iterator.length; ++i) {
                if (!oid.endsWith(String.format(match, iterator[i]))) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public CertType checkQcType(X509Certificate[] chain) throws IOException {
        int finalCert = CertUtils.getFinalCert((X509Certificate[])chain);
        if (finalCert == -1) {
            throw new IOException("ERR_NO_USER_CERT");
        }
        X509Certificate cert = chain[finalCert];
        return this.checkQcType(cert);
    }

    public CertType checkQcType(X509Certificate cert) throws IOException {
        ASN1ObjectIdentifier qcType = QcStatementsUtils.checkQcType(cert);
        if (qcType == null) {
            return CertType.unknokn;
        }
        if (qcType.equals((ASN1Primitive)QcStatementsOID.id_etsi_qct_eseal)) {
            return CertType.seal;
        }
        if (qcType.equals((ASN1Primitive)QcStatementsOID.id_etsi_qct_esign)) {
            return CertType.signature;
        }
        if (qcType.equals((ASN1Primitive)QcStatementsOID.id_etsi_qct_web)) {
            return CertType.ssl;
        }
        return CertType.unknokn;
    }
}

