/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.oid;

import java.util.HashSet;
import java.util.Set;

public class KeyUsagesUtils {
    public static final String DIGITAL_SIGNATURE_KEY_USAGE_LITERAL = "firma digital";
    public static final String NON_REPUDIATION_KEY_USAGE_LITERAL = "no repudio";
    public static final String KEY_ENCIPHERMENT_KEY_USAGE_LITERAL = "cifrado de claves";
    public static final String DATA_ENCIPHERMENT_KEY_USAGE_LITERAL = "cifrado de datos";
    public static final String KEY_AGREEMENT_KEY_USAGE_LITERAL = "acuerdo de claves";
    public static final String KEY_CERT_SIGN_KEY_USAGE_LITERAL = "firma de certificados";
    public static final String CRL_SIGN_KEY_USAGE_LITERAL = "crl";
    public static final String ENCIPHER_ONLY_KEY_USAGE_LITERAL = "solo cifrado";
    public static final String DECIPHER_ONLY_KEY_USAGE_LITERAL = "solo descifrado";

    public static Set<Integer> getKeyUsagesValues(Set<String> literalValues) {
        HashSet<Integer> intValues = new HashSet<Integer>();
        for (String currentLiteral : literalValues) {
            int currentIntValue = 128;
            if (DIGITAL_SIGNATURE_KEY_USAGE_LITERAL.equals(currentLiteral)) {
                currentIntValue = 128;
            }
            if (NON_REPUDIATION_KEY_USAGE_LITERAL.equals(currentLiteral)) {
                currentIntValue = 64;
            }
            if (KEY_ENCIPHERMENT_KEY_USAGE_LITERAL.equals(currentLiteral)) {
                currentIntValue = 32;
            }
            if (DATA_ENCIPHERMENT_KEY_USAGE_LITERAL.equals(currentLiteral)) {
                currentIntValue = 16;
            }
            if (KEY_AGREEMENT_KEY_USAGE_LITERAL.equals(currentLiteral)) {
                currentIntValue = 8;
            }
            if (KEY_CERT_SIGN_KEY_USAGE_LITERAL.equals(currentLiteral)) {
                currentIntValue = 4;
            }
            if (CRL_SIGN_KEY_USAGE_LITERAL.equals(currentLiteral)) {
                currentIntValue = 2;
            }
            if (ENCIPHER_ONLY_KEY_USAGE_LITERAL.equals(currentLiteral)) {
                currentIntValue = 1;
            }
            if (DECIPHER_ONLY_KEY_USAGE_LITERAL.equals(currentLiteral)) {
                currentIntValue = 32768;
            }
            intValues.add(currentIntValue);
        }
        return intValues;
    }

    public static int getKeyUsageIDs(Set<Integer> profileUsages) {
        int keyUsage = 0;
        for (Integer currProfileID : profileUsages) {
            keyUsage |= currProfileID.intValue();
        }
        return keyUsage;
    }
}

