/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.io;

import com.anf.cryptotoken.api.io.Locker;
import com.anf.cryptotoken.api.io.exception.LockException;
import com.anf.cryptotoken.log.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.FileLockInterruptionException;
import java.nio.channels.OverlappingFileLockException;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;

public final class LockerImpl
implements Locker {
    private static final Logger log = Logger.getLogger(LockerImpl.class);
    private static TreeMap<String, LockerImpl> locks = new TreeMap();
    private static final File anfDir = new File(System.getenv("PUBLIC"), "ANF");
    private static File lockTempDir = new File(anfDir, "locks");
    private FileLock fileLock = null;
    private String name;
    private int calls = 0;
    private RandomAccessFile randomAccessFile;
    private Thread owner;

    private LockerImpl(String name) {
        this.name = name;
    }

    public static LockerImpl get(String name) {
        LockerImpl locker = locks.get(name);
        if (locker == null) {
            locker = new LockerImpl(name);
            locks.put(name, locker);
        }
        return locker;
    }

    public static LockerImpl lock(String name) {
        return LockerImpl.get(name).acquireLock();
    }

    public static void main(String[] args) {
        int i = 0;
        while (i++ < 10) {
            Thread d = new Thread(){

                @Override
                public void run() {
                    LockerImpl l = LockerImpl.get("lock");
                    try {
                        l.acquireLock();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return;
                    }
                    log.info((Object)("I have the lock " + Thread.currentThread()));
                    l.releaseLock();
                    l.releaseLock();
                }
            };
            d.start();
            d = new Thread(){

                @Override
                public void run() {
                    LockerImpl l = LockerImpl.get("lock");
                    try {
                        l.acquireLock();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return;
                    }
                    log.info((Object)("I have the lock " + Thread.currentThread()));
                    l.releaseLock();
                    l.releaseLock();
                }
            };
            d.start();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                log.error(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, R> R lock(Function<T, R> action, T input) throws LockException {
        R result = null;
        try {
            try {
                this.acquireLock();
                result = action.apply(input);
            }
            finally {
                this.releaseLock();
            }
        }
        catch (Throwable e) {
            throw new LockException(e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockerImpl acquireLock() throws LockException {
        int x;
        log.info((Object)("trying to acquire lock: " + this.name));
        if (this.name.equals("bit4id") && (x = 0) == 0) {
            ++x;
        }
        int attempts = 10000;
        while (attempts-- > 0 && !this.crossProcessLockAcquire(2L)) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException e) {
                log.error(e);
            }
        }
        if (attempts <= 0) {
            LockException err = new LockException("ERR_LOCKING_FILE_ERROR:" + this.getFile());
            log.error(err);
            throw err;
        }
        LockerImpl lockerImpl = this;
        synchronized (lockerImpl) {
            ++this.calls;
        }
        log.info((Object)("lock acquired: " + this.name));
        System.out.println("lock acquired: " + this.name);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryLock() throws FileLockInterruptionException {
        if (!this.crossProcessLockAcquire(1L)) {
            throw new FileLockInterruptionException();
        }
        LockerImpl lockerImpl = this;
        synchronized (lockerImpl) {
            ++this.calls;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean releaseLock() {
        int x;
        boolean release = false;
        LockerImpl lockerImpl = this;
        synchronized (lockerImpl) {
            release = this.calls > 0 && --this.calls == 0;
        }
        if (this.name.equals("bit4id") && (x = 0) == 0) {
            ++x;
        }
        if (release) {
            this.crossProcessLockRelease();
        }
        log.info((Object)("released lock: " + this.name + ": " + (this.calls == 0)));
        System.out.println("released lock: " + this.name + ": " + (this.calls == 0));
        return this.calls == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean crossProcessLockAcquire(long tries) {
        if (this.fileLock == null && tries > 0L) {
            try {
                FileChannel fileChannel = this.buildRandomAccessFile().getChannel();
                while (tries-- > 0L) {
                    try {
                        LockerImpl lockerImpl = this;
                        synchronized (lockerImpl) {
                            if (this.fileLock == null) {
                                this.fileLock = fileChannel.tryLock();
                                if (this.fileLock != null) {
                                    this.owner = Thread.currentThread();
                                    return true;
                                }
                            }
                        }
                    }
                    catch (ClosedChannelException | OverlappingFileLockException e) {
                        log.info(this.name, " reintentando bloqueo, quedan ", tries);
                    }
                    catch (Exception e) {
                        log.debug(e);
                    }
                    Thread.sleep(250L);
                }
            }
            catch (Exception e) {
                log.error(e);
            }
        }
        boolean b = this.owner != null && this.owner.equals(Thread.currentThread());
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RandomAccessFile buildRandomAccessFile() throws Exception, FileNotFoundException {
        File file = this.getFile();
        LockerImpl lockerImpl = this;
        synchronized (lockerImpl) {
            if (this.randomAccessFile == null) {
                if (!file.exists()) {
                    try {
                        file.getParentFile().mkdirs();
                        file.createNewFile();
                    }
                    catch (Exception e) {
                        log.error("****ERROR CREANDO ARCHIVO DE LOCK EN " + file);
                        throw e;
                    }
                }
                log.debug("creando acceso a archivo de lock " + file);
                this.randomAccessFile = new RandomAccessFile(file, "rw");
                return this.randomAccessFile;
            }
        }
        return this.randomAccessFile;
    }

    public File getFile() {
        lockTempDir.mkdirs();
        return new File(lockTempDir, this.name + ".lock");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean crossProcessLockRelease() {
        boolean released = false;
        if (this.fileLock != null) {
            try {
                LockerImpl lockerImpl = this;
                synchronized (lockerImpl) {
                    this.fileLock.release();
                }
                this.fileLock = null;
                lockerImpl = this;
                synchronized (lockerImpl) {
                    if (this.randomAccessFile != null) {
                        this.randomAccessFile.close();
                        this.randomAccessFile = null;
                    }
                }
                released = this.getFile().delete();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (released) {
            this.owner = null;
        }
        return released;
    }

    public void close() {
        this.releaseLock();
    }

    static {
        try {
            anfDir.mkdirs();
            lockTempDir.mkdirs();
        }
        catch (Exception e) {
            lockTempDir = new File(System.getProperty("user.home"), "locks");
            lockTempDir.mkdirs();
            if (!lockTempDir.canWrite()) {
                lockTempDir = new File(System.getProperty("user.dir"), "locks");
            }
            e.printStackTrace();
        }
        lockTempDir.mkdirs();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Set<Map.Entry<String, LockerImpl>> set = locks.entrySet();
                for (Map.Entry<String, LockerImpl> e : set) {
                    e.getValue().crossProcessLockRelease();
                }
            }
        });
    }
}

