/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509;

import eu.europa.esig.dss.model.identifier.EntityIdentifier;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.x509.CertificateSourceEntity;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EquivalentCertificatesEntity
implements CertificateSourceEntity {
    private static final long serialVersionUID = -8670353777128605464L;
    private static final Logger LOG = LoggerFactory.getLogger(EquivalentCertificatesEntity.class);
    private final EntityIdentifier identifier;
    private final byte[] ski;
    private final Set<CertificateToken> equivalentCertificates = new HashSet<CertificateToken>();

    EquivalentCertificatesEntity(CertificateToken initialCert) {
        this.identifier = initialCert.getEntityKey();
        this.ski = DSSASN1Utils.computeSkiFromCert(initialCert);
        this.equivalentCertificates.add(initialCert);
    }

    void addEquivalentCertificate(CertificateToken token) {
        if (!this.equivalentCertificates.contains(token)) {
            LOG.trace("Certificate with same public key detected : {}", (Object)token.getAbbreviation());
            byte[] newSKI = DSSASN1Utils.computeSkiFromCert(token);
            if (!Arrays.equals(newSKI, this.ski)) {
                LOG.warn("Token {} is skipped", (Object)token.getAbbreviation());
            } else {
                this.equivalentCertificates.add(token);
            }
        }
    }

    void removeEquivalentCertificate(CertificateToken token) {
        if (this.equivalentCertificates.contains(token)) {
            if (this.equivalentCertificates.size() == 1) {
                LOG.warn("Only one token found in the pool. Empty pool is not allowed. Removing of token {} is skipped.", (Object)token.getAbbreviation());
            } else {
                LOG.trace("Removing certificate from the pool : {}", (Object)token.getAbbreviation());
                this.equivalentCertificates.remove(token);
            }
        }
    }

    byte[] getSki() {
        return this.ski;
    }

    Set<CertificateToken> getEquivalentCertificates() {
        return Collections.unmodifiableSet(this.equivalentCertificates);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.identifier == null ? 0 : this.identifier.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EquivalentCertificatesEntity other = (EquivalentCertificatesEntity)obj;
        return !(this.identifier == null ? other.identifier != null : !this.identifier.equals((Object)other.identifier));
    }
}

