/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.validation.analyzer;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.ManifestFile;
import eu.europa.esig.dss.model.identifier.TokenIdentifierProvider;
import eu.europa.esig.dss.spi.policy.SignaturePolicyProvider;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.validation.ValidationContext;
import eu.europa.esig.dss.spi.validation.ValidationDataContainer;
import eu.europa.esig.dss.spi.validation.executor.ValidationContextExecutor;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.evidencerecord.EvidenceRecord;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public interface DocumentAnalyzer {
    public DSSDocument getDocument();

    public List<AdvancedSignature> getSignatures();

    public List<TimestampToken> getDetachedTimestamps();

    public List<EvidenceRecord> getDetachedEvidenceRecords();

    public void setCertificateVerifier(CertificateVerifier var1);

    public void setValidationContextExecutor(ValidationContextExecutor var1);

    public TokenIdentifierProvider getTokenIdentifierProvider();

    public void setTokenIdentifierProvider(TokenIdentifierProvider var1);

    public Date getValidationTime();

    public void setValidationTime(Date var1);

    public void setDetachedContents(List<DSSDocument> var1);

    public void setDetachedEvidenceRecordDocuments(List<DSSDocument> var1);

    public void setContainerContents(List<DSSDocument> var1);

    public void setManifestFile(ManifestFile var1);

    public boolean isSupported(DSSDocument var1);

    public void setSigningCertificateSource(CertificateSource var1);

    public void setSignaturePolicyProvider(SignaturePolicyProvider var1);

    public List<DSSDocument> getOriginalDocuments(String var1);

    public List<DSSDocument> getOriginalDocuments(AdvancedSignature var1);

    public <T extends AdvancedSignature> ValidationDataContainer getValidationData(Collection<T> var1);

    public <T extends AdvancedSignature> ValidationDataContainer getValidationData(Collection<T> var1, Collection<TimestampToken> var2);

    public ValidationContext validate();
}

