/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.validation;

import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.validation.RevocationDataVerifier;
import eu.europa.esig.dss.spi.validation.TrustAnchorVerifier;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimestampTokenVerifier {
    private static final Logger LOG = LoggerFactory.getLogger(TimestampTokenVerifier.class);
    private TrustAnchorVerifier trustAnchorVerifier;
    private RevocationDataVerifier revocationDataVerifier;

    protected TimestampTokenVerifier() {
    }

    public static TimestampTokenVerifier createEmptyTimestampTokenVerifier() {
        return new TimestampTokenVerifier();
    }

    public static TimestampTokenVerifier createDefaultTimestampTokenVerifier() {
        TimestampTokenVerifier timestampTokenVerifier = new TimestampTokenVerifier();
        return timestampTokenVerifier;
    }

    @Deprecated
    public CertificateSource getTrustedCertificateSource() {
        return this.getTrustAnchorVerifier().getTrustedCertificateSource();
    }

    @Deprecated
    protected void setTrustedCertificateSource(CertificateSource trustedCertificateSource) {
        TrustAnchorVerifier currentTrustAnchorVerifier = this.getTrustAnchorVerifier();
        if (currentTrustAnchorVerifier == null) {
            throw new NullPointerException("TrustAnchorVerifier is not defined! Please set TrustAnchorVerifier in order to provide a trustedCertificateSource.");
        }
        currentTrustAnchorVerifier.setTrustedCertificateSource(trustedCertificateSource);
    }

    @Deprecated
    public void setAcceptUntrustedCertificateChains(boolean acceptUntrustedCertificateChains) {
        TrustAnchorVerifier currentTrustAnchorVerifier = this.getTrustAnchorVerifier();
        if (currentTrustAnchorVerifier == null) {
            throw new NullPointerException("TrustAnchorVerifier is not defined! Please set TrustAnchorVerifier in order to provide an acceptUntrustedCertificateChains constraint.");
        }
        currentTrustAnchorVerifier.setAcceptTimestampUntrustedCertificateChains(acceptUntrustedCertificateChains);
    }

    public TrustAnchorVerifier getTrustAnchorVerifier() {
        return this.trustAnchorVerifier;
    }

    public void setTrustAnchorVerifier(TrustAnchorVerifier trustAnchorVerifier) {
        this.trustAnchorVerifier = trustAnchorVerifier;
    }

    public RevocationDataVerifier getRevocationDataVerifier() {
        if (this.revocationDataVerifier != null && this.revocationDataVerifier.getTrustAnchorVerifier() == null) {
            this.revocationDataVerifier.setTrustAnchorVerifier(this.getTrustAnchorVerifier());
        }
        return this.revocationDataVerifier;
    }

    public void setRevocationDataVerifier(RevocationDataVerifier revocationDataVerifier) {
        this.revocationDataVerifier = revocationDataVerifier;
    }

    public boolean isAcceptable(TimestampToken timestampToken) {
        return this.isAcceptable(timestampToken, new Date());
    }

    public boolean isAcceptable(TimestampToken timestampToken, Date controlTime) {
        return this.isAcceptable(timestampToken, Collections.emptyList(), controlTime);
    }

    public boolean isAcceptable(TimestampToken timestampToken, List<CertificateToken> certificateChain) {
        return this.isAcceptable(timestampToken, certificateChain, new Date());
    }

    public boolean isAcceptable(TimestampToken timestampToken, List<CertificateToken> certificateChain, Date controlTime) {
        return this.isTrustedTimestampToken(timestampToken, certificateChain, controlTime) && this.isCryptographicallyValid(timestampToken) && this.isCertificateChainValid(certificateChain, controlTime);
    }

    @Deprecated
    protected boolean isTrustedTimestampToken(TimestampToken timestampToken, List<CertificateToken> certificateChain) {
        return this.isTrustedTimestampToken(timestampToken, certificateChain, new Date());
    }

    protected boolean isTrustedTimestampToken(TimestampToken timestampToken, List<CertificateToken> certificateChain, Date controlTime) {
        if (this.containsTrustAnchor(certificateChain, controlTime)) {
            return true;
        }
        LOG.warn("POE extraction is skipped for untrusted timestamp : {}.", (Object)timestampToken.getDSSIdAsString());
        return false;
    }

    protected boolean containsTrustAnchor(List<CertificateToken> certChain, Date controlTime) {
        TrustAnchorVerifier currentTrustAnchorVerifier = this.getTrustAnchorVerifier();
        if (currentTrustAnchorVerifier == null) {
            LOG.debug("TrustAnchorVerifier is not defined! None of the certificates will be considered as a trust anchor.");
            return false;
        }
        return currentTrustAnchorVerifier.isTrustedCertificateChain(certChain, controlTime, Context.TIMESTAMP);
    }

    protected boolean isCryptographicallyValid(TimestampToken timestampToken) {
        if (!timestampToken.isMessageImprintDataIntact()) {
            LOG.warn("POE extraction is skipped for timestamp : {}. The message-imprint is not intact!", (Object)timestampToken.getDSSIdAsString());
            return false;
        }
        if (!timestampToken.isSignatureIntact()) {
            LOG.warn("POE extraction is skipped for timestamp : {}. The signature is not intact!", (Object)timestampToken.getDSSIdAsString());
            return false;
        }
        return true;
    }

    protected boolean isCertificateChainValid(List<CertificateToken> certificateChain, Date controlTime) {
        RevocationDataVerifier currentRevocationDataVerifier = this.getRevocationDataVerifier();
        if (this.revocationDataVerifier == null) {
            LOG.warn("No RevocationDataVerifier is provided! Revocation check is skipped.");
            return true;
        }
        return currentRevocationDataVerifier.isCertificateChainValid(certificateChain, controlTime, Context.TIMESTAMP);
    }
}

