/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.signature;

import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.signature.SignaturePolicy;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.signature.DefaultAdvancedSignature;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.validation.SignatureValidationContext;
import eu.europa.esig.dss.spi.validation.ValidationContext;
import eu.europa.esig.dss.spi.x509.CandidatesForSigningCertificate;
import eu.europa.esig.dss.spi.x509.CertificateValidity;
import eu.europa.esig.dss.spi.x509.ListCertificateSource;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.utils.Utils;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaselineRequirementsChecker<AS extends DefaultAdvancedSignature> {
    private static final Logger LOG = LoggerFactory.getLogger(BaselineRequirementsChecker.class);
    protected final AS signature;
    protected final CertificateVerifier offlineCertificateVerifier;
    private ValidationContext validationContext;

    protected BaselineRequirementsChecker(AS signature) {
        this(signature, null);
    }

    protected BaselineRequirementsChecker(AS signature, CertificateVerifier offlineCertificateVerifier) {
        this.signature = signature;
        this.offlineCertificateVerifier = offlineCertificateVerifier;
    }

    public abstract boolean hasBaselineBProfile();

    public abstract boolean hasBaselineTProfile();

    public abstract boolean hasBaselineLTProfile();

    public abstract boolean hasBaselineLTAProfile();

    public boolean hasExtendedBESProfile() {
        return false;
    }

    public boolean hasExtendedEPESProfile() {
        return false;
    }

    public boolean hasExtendedTProfile() {
        return false;
    }

    public boolean hasExtendedCProfile() {
        return false;
    }

    public boolean hasExtendedXProfile() {
        return false;
    }

    public boolean hasExtendedXLProfile() {
        return false;
    }

    public boolean hasExtendedAProfile() {
        return false;
    }

    protected boolean signatureTimestampsCreatedBeforeSignCertExpiration() {
        CertificateToken signingCertificate = ((DefaultAdvancedSignature)this.signature).getSigningCertificateToken();
        if (signingCertificate != null && signingCertificate.getNotAfter() != null) {
            for (TimestampToken timestampToken : ((DefaultAdvancedSignature)this.signature).getSignatureTimestamps()) {
                if (!signingCertificate.getNotAfter().before(timestampToken.getGenerationTime())) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean minimalTRequirement() {
        if (Utils.isCollectionEmpty(((DefaultAdvancedSignature)this.signature).getSignatureTimestamps())) {
            LOG.trace("SignatureTimeStamp shall be present for BASELINE-T signature (cardinality >= 1)!");
            return false;
        }
        CertificateToken signingCertificate = ((DefaultAdvancedSignature)this.signature).getSigningCertificateToken();
        if (signingCertificate != null) {
            for (TimestampToken timestampToken : ((DefaultAdvancedSignature)this.signature).getSignatureTimestamps()) {
                if (timestampToken.getCreationDate().before(signingCertificate.getNotAfter())) continue;
                LOG.warn("SignatureTimeStamp shall be generated before the signing certificate expiration for BASELINE-T signature!");
                return false;
            }
        }
        return true;
    }

    public boolean minimalLTRequirement() {
        boolean minimalLTRequirement;
        Objects.requireNonNull(this.offlineCertificateVerifier, "offlineCertificateVerifier cannot be null for LT-level verification!");
        ListCertificateSource certificateSources = this.getCertificateSourcesExceptLastArchiveTimestamp();
        boolean certificateFound = certificateSources.getNumberOfCertificates() > 0;
        boolean allSelfSigned = certificateFound && certificateSources.isAllSelfSigned();
        boolean emptyCRLs = ((DefaultAdvancedSignature)this.signature).getCompleteCRLSource().getAllRevocationBinaries().isEmpty();
        boolean emptyOCSPs = ((DefaultAdvancedSignature)this.signature).getCompleteOCSPSource().getAllRevocationBinaries().isEmpty();
        boolean emptyRevocation = emptyCRLs && emptyOCSPs;
        boolean bl = minimalLTRequirement = !allSelfSigned && !emptyRevocation;
        if (minimalLTRequirement) {
            return this.isAllRevocationDataPresent();
        }
        if (allSelfSigned) {
            return this.containsLTLevelCertificates();
        }
        return minimalLTRequirement;
    }

    protected boolean containsLTLevelCertificates() {
        return false;
    }

    protected ListCertificateSource getCertificateSourcesExceptLastArchiveTimestamp() {
        ListCertificateSource certificateSource = new ListCertificateSource(this.signature.getCertificateSource());
        certificateSource.addAll(this.signature.getTimestampSource().getTimestampCertificateSourcesExceptLastArchiveTimestamp());
        certificateSource.addAll(((DefaultAdvancedSignature)this.signature).getCounterSignaturesCertificateSource());
        return certificateSource;
    }

    private boolean isAllRevocationDataPresent() {
        return this.getValidationContext().checkAllRequiredRevocationDataPresent();
    }

    protected ValidationContext getValidationContext() {
        if (this.validationContext == null) {
            this.validationContext = new SignatureValidationContext();
            this.validationContext.initialize(this.offlineCertificateVerifier);
            this.validationContext.addDocumentCertificateSource(((DefaultAdvancedSignature)this.signature).getCompleteCertificateSource());
            this.validationContext.addDocumentCRLSource(((DefaultAdvancedSignature)this.signature).getCompleteCRLSource());
            this.validationContext.addDocumentOCSPSource(((DefaultAdvancedSignature)this.signature).getCompleteOCSPSource());
            this.addSignatureForVerification(this.validationContext, (AdvancedSignature)this.signature);
            this.validationContext.validate();
        }
        return this.validationContext;
    }

    private void addSignatureForVerification(ValidationContext validationContext, AdvancedSignature signature) {
        CertificateToken signingCertificate = signature.getSigningCertificateToken();
        if (signingCertificate != null) {
            validationContext.addCertificateTokenForVerification(signingCertificate);
        } else {
            CandidatesForSigningCertificate candidatesForSigningCertificate = signature.getCandidatesForSigningCertificate();
            List<CertificateValidity> certificateValidities = candidatesForSigningCertificate.getCertificateValidityList();
            if (Utils.isCollectionNotEmpty(certificateValidities)) {
                for (CertificateValidity certificateValidity : certificateValidities) {
                    if (!certificateValidity.isValid() || certificateValidity.getCertificateToken() == null) continue;
                    validationContext.addCertificateTokenForVerification(certificateValidity.getCertificateToken());
                }
            }
        }
        for (TimestampToken timestampToken : signature.getTimestampSource().getAllTimestampsExceptLastArchiveTimestamp()) {
            validationContext.addTimestampTokenForVerification(timestampToken);
        }
    }

    public boolean minimalLTARequirement() {
        if (Utils.isCollectionEmpty(((DefaultAdvancedSignature)this.signature).getArchiveTimestamps())) {
            LOG.trace("ArchiveTimeStamp shall be present for BASELINE-LTA signature (cardinality >= 1)!");
            return false;
        }
        return true;
    }

    protected boolean containsSigningCertificate(Collection<CertificateToken> certificateTokens) {
        CandidatesForSigningCertificate candidatesForSigningCertificate = ((DefaultAdvancedSignature)this.signature).getCandidatesForSigningCertificate();
        CertificateValidity certificateValidity = candidatesForSigningCertificate.getTheCertificateValidity();
        if (certificateValidity != null && certificateValidity.getCertificateToken() != null) {
            CertificateToken signingCertificate = certificateValidity.getCertificateToken();
            for (CertificateToken certificate : certificateTokens) {
                if (!certificate.equals((Object)signingCertificate)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isSignaturePolicyIdentifierHashPresent() {
        SignaturePolicy signaturePolicyIdentifier = ((DefaultAdvancedSignature)this.signature).getSignaturePolicy();
        if (signaturePolicyIdentifier != null) {
            Digest digest = signaturePolicyIdentifier.getDigest();
            return digest != null && digest.getAlgorithm() != null;
        }
        return false;
    }
}

