/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.policy;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.signature.SignaturePolicy;
import eu.europa.esig.dss.model.signature.SignaturePolicyValidationResult;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.policy.AbstractSignaturePolicyValidator;
import eu.europa.esig.dss.utils.Utils;
import java.util.Arrays;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicASN1SignaturePolicyValidator
extends AbstractSignaturePolicyValidator {
    private static final Logger LOG = LoggerFactory.getLogger(BasicASN1SignaturePolicyValidator.class);

    @Override
    public boolean canValidate(SignaturePolicy signaturePolicy) {
        if (signaturePolicy.getPolicyContent() != null) {
            byte firstByte = DSSUtils.readFirstByte(signaturePolicy.getPolicyContent());
            return DSSASN1Utils.isASN1SequenceTag(firstByte);
        }
        return false;
    }

    @Override
    public SignaturePolicyValidationResult validate(SignaturePolicy signaturePolicy) {
        SignaturePolicyValidationResult validationResult = new SignaturePolicyValidationResult();
        DSSDocument policyContent = signaturePolicy.getPolicyContent();
        if (policyContent == null) {
            validationResult.addError("general", "The signature policy content is not obtained.");
            return validationResult;
        }
        validationResult.setIdentified(true);
        Digest digest = signaturePolicy.getDigest();
        if (digest == null) {
            validationResult.addError("general", "The policy digest value is not defined.");
            return validationResult;
        }
        validationResult.setDigestValid(true);
        try {
            byte[] policyBytes = DSSUtils.toByteArray(policyContent);
            ASN1Sequence asn1Sequence = (ASN1Sequence)DSSASN1Utils.toASN1Primitive(policyBytes);
            if (asn1Sequence != null) {
                validationResult.setAsn1Processable(true);
                ASN1Sequence signPolicyHashAlgObject = (ASN1Sequence)asn1Sequence.getObjectAt(0);
                AlgorithmIdentifier signPolicyHashAlgIdentifier = AlgorithmIdentifier.getInstance((Object)signPolicyHashAlgObject);
                DigestAlgorithm signPolicyHashAlgFromPolicy = DigestAlgorithm.forOID((String)signPolicyHashAlgIdentifier.getAlgorithm().getId());
                if (signPolicyHashAlgFromPolicy.equals((Object)digest.getAlgorithm())) {
                    validationResult.setDigestAlgorithmsEqual(true);
                    Digest recalculatedDigest = this.getComputedDigest(policyContent, signPolicyHashAlgFromPolicy);
                    validationResult.setDigest(recalculatedDigest);
                    boolean equal = digest.equals((Object)recalculatedDigest);
                    validationResult.setDigestValid(equal);
                    if (!equal) {
                        validationResult.addError("general", "The policy digest value (" + Utils.toBase64((byte[])digest.getValue()) + ") does not match the re-calculated digest value (" + Utils.toBase64((byte[])recalculatedDigest.getValue()) + ").");
                    }
                    ASN1OctetString signPolicyHash = (ASN1OctetString)asn1Sequence.getObjectAt(2);
                    byte[] policyDigestValueFromPolicy = signPolicyHash.getOctets();
                    equal = Arrays.equals(digest.getValue(), policyDigestValueFromPolicy);
                    validationResult.setDigestValid(equal);
                    if (!equal) {
                        validationResult.addError("general", "The policy digest value (" + Utils.toBase64((byte[])digest.getValue()) + ") does not match the digest value from the policy file (" + Utils.toBase64((byte[])policyDigestValueFromPolicy) + ").");
                    }
                } else {
                    validationResult.addError("general", "The digest algorithm indicated in the SignPolicyHashAlg from the resulting document (" + signPolicyHashAlgFromPolicy + ") is not equal to the digest algorithm (" + digest.getAlgorithm() + ").");
                    validationResult.setDigestAlgorithmsEqual(false);
                    validationResult.setDigestValid(false);
                }
            }
        }
        catch (Exception e) {
            validationResult.setDigestValid(false);
            validationResult.addError("general", e.getMessage());
            LOG.warn(e.getMessage(), (Throwable)e);
        }
        return validationResult;
    }

    @Override
    public Digest getComputedDigest(DSSDocument policyDocument, DigestAlgorithm digestAlgorithm) {
        byte[] asn1SignaturePolicyDigest = DSSASN1Utils.getAsn1SignaturePolicyDigest(digestAlgorithm, DSSUtils.toByteArray(policyDocument));
        return new Digest(digestAlgorithm, asn1SignaturePolicyDigest);
    }
}

