/*
 * Decompiled with CFR 0.152.
 */
package com.anf.pkcs11.provider.model;

import com.anf.pkcs11.jna.PKCS11Constants;
import com.anf.pkcs11.jna.PKCS11Exception;
import com.anf.pkcs11.provider.exception.P11ProviderException;
import com.anf.pkcs11.provider.model.JNAToken;
import com.anf.pkcs11.provider.model.Session;
import java.security.ProviderException;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class SessionManager
implements PKCS11Constants {
    private static final Logger log = LogManager.getLogger(SessionManager.class);
    private static final int DEFAULT_MAX_SESSIONS = 32;
    private final JNAToken token;
    private final int maxSessions;
    private final LinkedList<Session> sessions = new LinkedList();
    private int maxActiveSessions;
    private Object maxActiveSessionsLock;
    private final long openSessionFlags;
    private static Object debug = System.getProperty("pkcs11.debug");

    SessionManager(JNAToken token) {
        long n;
        if (token.isWriteProtected()) {
            this.openSessionFlags = 4L;
            n = token.getTokenInfo().getUlMaxSessionCount();
        } else {
            this.openSessionFlags = 6L;
            n = token.getTokenInfo().getUlMaxRwSessionCount();
        }
        if (n == 0L) {
            n = Integer.MAX_VALUE;
        } else if (n == -1L || n < 0L) {
            n = 32L;
        }
        this.maxSessions = (int)Math.min(n, Integer.MAX_VALUE);
        this.token = token;
        if (debug != null) {
            this.maxActiveSessionsLock = new Object();
        }
    }

    boolean lowMaxSessions() {
        return this.maxSessions <= 32;
    }

    synchronized Session getLastSession() throws PKCS11Exception {
        Session session = this.sessions.pollLast();
        if (session != null) {
            log.debug("using last session {}", (Object)session.id());
            return this.ensureValid(session);
        }
        log.debug("no session found in list, opening new one {}");
        session = this.openNewSession();
        if (session == null) {
            throw new P11ProviderException("Could not obtain session");
        }
        return session;
    }

    public synchronized Session openNewSession() {
        if (this.maxSessions == Integer.MAX_VALUE || this.sessions.size() < this.maxSessions) {
            Session session = this.openSession();
            return this.ensureValid(session);
        }
        return null;
    }

    private Session ensureValid(Session session) {
        session.id();
        return session;
    }

    synchronized void killSession(Session session) {
        if (session == null || !this.token.isValid()) {
            return;
        }
        if (debug != null) {
            String location = new Exception().getStackTrace()[2].toString();
            log.debug("Killing session (" + location + ") active: " + this.sessions.size());
        }
        this.closeSession(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Session openSession() throws PKCS11Exception {
        if (this.maxSessions != Integer.MAX_VALUE && this.sessions.size() >= this.maxSessions) {
            throw new ProviderException("No more sessions available");
        }
        long id = this.token.p11().C_OpenSession(this.token.getSlot(), this.openSessionFlags);
        log.debug("new Session opened: {}", (Object)id);
        Session session = new Session(this.token, id);
        this.sessions.add(session);
        if (debug != null) {
            Object object = this.maxActiveSessionsLock;
            synchronized (object) {
                if (this.sessions.size() > this.maxActiveSessions) {
                    this.maxActiveSessions = this.sessions.size();
                    if (this.maxActiveSessions % 10 == 0) {
                        log.debug("Open sessions: " + this.maxActiveSessions);
                    }
                }
            }
        }
        return session;
    }

    private void closeSession(Session session) {
        session.close();
        this.sessions.remove(session);
    }

    public void dump() {
        log.debug("sesiones totales: {}", (Object)this.sessions.size());
        this.sessions.forEach(ses -> log.debug("sesion: {}", ses));
    }

    public void addNewFreeSession(Session session) {
        if (!session.hasObjects()) {
            this.sessions.add(session);
        }
    }
}

