/*
 * Decompiled with CFR 0.152.
 */
package com.anf.pkcs11.provider.model;

import com.anf.cert.utils.CertUtils;
import com.anf.pkcs11.jna.CK_ATTRIBUTE;
import com.anf.pkcs11.jna.CK_SESSION_INFO;
import com.anf.pkcs11.jna.CK_SLOT_INFO;
import com.anf.pkcs11.jna.CK_TOKEN_INFO;
import com.anf.pkcs11.jna.P11Manager;
import com.anf.pkcs11.jna.PKCS11Constants;
import com.anf.pkcs11.jna.PKCS11Exception;
import com.anf.pkcs11.provider.cert.CertService;
import com.anf.pkcs11.provider.exception.P11ProviderException;
import com.anf.pkcs11.provider.model.CertInfo;
import com.anf.pkcs11.provider.model.JNAPrivateKey;
import com.anf.pkcs11.provider.model.Session;
import com.anf.pkcs11.provider.model.SessionManager;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.util.encoders.Hex;

public class JNAToken
implements PKCS11Constants {
    private static final Logger log = LogManager.getLogger(JNAToken.class);
    private static final long CHECK_INTERVAL = 50L;
    private static final Object CHECK_LOCK = new Object();
    private P11Manager p11;
    private long slot;
    private Map<String, CertInfo> certMap = new TreeMap<String, CertInfo>();
    private Map<String, CertInfo> caMap = new TreeMap<String, CertInfo>();
    private boolean removable;
    private boolean valid = true;
    private long lastPresentCheck;
    private CK_TOKEN_INFO tokenInfo;
    private boolean writeProtected;
    private SessionManager sessionManager;
    private boolean loggedIn;
    private long lastLoginCheck;
    private long lastUpdate;

    public JNAToken(P11Manager p11, long slot) {
        this.p11 = p11;
        this.slot = slot;
        p11.initialize();
        CK_SLOT_INFO slotInfo = p11.getSlotInfo(slot);
        this.removable = (slotInfo.flags & 2L) != 0L;
        this.tokenInfo = p11.getTokenInfo(slot);
        this.writeProtected = (this.tokenInfo.getFlags() & 2L) != 0L;
        this.sessionManager = new SessionManager(this);
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public boolean isWriteProtected() {
        return this.writeProtected;
    }

    public CK_TOKEN_INFO getTokenInfo() {
        return this.tokenInfo;
    }

    public Enumeration<String> aliases() {
        return Collections.enumeration(new ArrayList<String>(this.certMap.keySet()));
    }

    public void updateCertificates() {
        long[] certs;
        if (this.lastUpdate != 0L && System.currentTimeMillis() - this.lastUpdate < 30000L) {
            return;
        }
        Session session = this.sessionManager.getLastSession();
        for (long certId : certs = this.p11().findCertificates(session.id())) {
            CertInfo certInfo;
            X509Certificate cert;
            CK_ATTRIBUTE id = new CK_ATTRIBUTE(258L);
            CK_ATTRIBUTE label = new CK_ATTRIBUTE(3L);
            CK_ATTRIBUTE[] aliasTemplate = new CK_ATTRIBUTE[]{id, label};
            this.p11().C_GetAttributeValue(session.id(), certId, aliasTemplate);
            String alias = null;
            if (label.pValue != null) {
                alias = label.getValueStr();
            }
            if (alias == null || (cert = this.p11.getCertificate(session.id(), certId)) == null) continue;
            boolean ca = cert.getBasicConstraints() != -1;
            CertInfo certInfo2 = certInfo = ca ? this.caMap.get(alias) : this.certMap.get(alias);
            if (certInfo != null) {
                if (Arrays.equals(certInfo.getCert().getSignature(), cert.getSignature())) continue;
                certInfo.setCert(cert);
                certInfo.setSession(session);
                continue;
            }
            certInfo = new CertInfo(session, alias, id.pValue, certId, cert);
            if (ca) {
                this.caMap.put(certInfo.getAlias(), certInfo);
                continue;
            }
            this.certMap.put(certInfo.getAlias(), certInfo);
        }
        this.lastUpdate = System.currentTimeMillis();
    }

    public void fillCertificates() {
        if (this.certMap.isEmpty()) {
            Session session = this.sessionManager.getLastSession();
            ArrayList<CertInfo> certList = new ArrayList<CertInfo>();
            long[] certs = this.p11().findCertificates(session.id());
            for (long certId : certs) {
                CK_ATTRIBUTE id = new CK_ATTRIBUTE(258L);
                CK_ATTRIBUTE label = new CK_ATTRIBUTE(3L);
                CK_ATTRIBUTE[] aliasTemplate = new CK_ATTRIBUTE[]{id, label};
                this.p11().C_GetAttributeValue(session.id(), certId, aliasTemplate);
                String alias = null;
                if (label.pValue != null) {
                    alias = label.getValueStr();
                }
                if (alias == null) continue;
                certList.add(new CertInfo(session, alias, id.pValue, certId, this.p11.getCertificate(session.id(), certId)));
            }
            Object object = certList.iterator();
            while (object.hasNext()) {
                CertInfo certInfo = (CertInfo)object.next();
                if (certInfo.isCa()) {
                    this.caMap.put(certInfo.getAlias(), certInfo);
                    continue;
                }
                this.certMap.put(certInfo.getAlias(), certInfo);
            }
            this.lastUpdate = System.currentTimeMillis();
        }
    }

    public void updateKeys(Session opSession) {
        if (this.isLoggedIn(opSession)) {
            for (CertInfo certInfo : this.certMap.values()) {
                Long pkey;
                if (certInfo.getPrivateKey() != null) continue;
                if (opSession == null) {
                    opSession = this.getLastSession();
                }
                if ((pkey = this.p11.findPrivateKey(opSession.id(), certInfo.getId())) == null) continue;
                RSAPublicKey publicKey = (RSAPublicKey)certInfo.getCert().getPublicKey();
                certInfo.setPrivateKey(new JNAPrivateKey(opSession, pkey, certInfo.getId(), publicKey.getModulus(), publicKey.getAlgorithm()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session logIn(char[] pin) {
        if ((this.tokenInfo.getFlags() & 4L) == 0L) {
            log.debug("login operation not required for token - ignoring login request");
            return null;
        }
        Session session = this.getLastSession();
        if (this.isLoggedInNow(session)) {
            log.debug("user is already logged in");
            return session;
        }
        if (session == null) {
            session = this.sessionManager.openNewSession();
        }
        try {
            try {
                this.p11.C_Login(new String(pin), 1L, session.id());
            }
            catch (PKCS11Exception e) {
                if (e.getErrorCode() == 48L) {
                    this.p11.C_Login(new String(pin), 1L, session.id());
                }
                throw e;
            }
            log.debug("logged in session {}", (Object)session.id());
        }
        finally {
            if (pin != null) {
                Arrays.fill(pin, ' ');
            }
        }
        return session;
    }

    boolean isLoggedIn(Session session) throws PKCS11Exception {
        long time = System.currentTimeMillis();
        if (time - this.lastLoginCheck > 50L) {
            this.isLoggedInNow(session);
            this.lastLoginCheck = time;
        }
        return this.loggedIn;
    }

    public boolean isLoggedInNow(Session session) throws PKCS11Exception {
        if (session == null) {
            session = this.getLastSession();
        }
        CK_SESSION_INFO info = this.p11.getSessionInfo(session.id());
        this.loggedIn = info.state == 1L || info.state == 3L;
        return this.loggedIn;
    }

    public Session getLastSession() {
        return this.sessionManager.getLastSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isPresent(long sessionID) {
        if (!this.removable) {
            return true;
        }
        if (!this.valid) {
            return false;
        }
        long time = System.currentTimeMillis();
        if (time - this.lastPresentCheck >= 50L) {
            Object object = CHECK_LOCK;
            synchronized (object) {
                if (time - this.lastPresentCheck >= 50L) {
                    boolean ok = false;
                    try {
                        CK_SLOT_INFO slotInfo = this.p11.getSlotInfo(this.slot);
                        if ((slotInfo.flags & 1L) != 0L) {
                            CK_SESSION_INFO sessInfo = this.p11.getSessionInfo(sessionID);
                            ok = sessInfo != null;
                        }
                    }
                    catch (PKCS11Exception e) {
                        log.warn(e.getMessage());
                    }
                    this.valid = ok;
                    this.lastPresentCheck = System.currentTimeMillis();
                    if (!ok) {
                        this.destroy();
                    }
                }
            }
        }
        return this.valid;
    }

    public void ensureLoggedIn(Session session) throws PKCS11Exception {
        if (!this.isLoggedIn(session)) {
            throw new PKCS11Exception(257L);
        }
        log.debug("session {} is logged in", (Object)session.id());
    }

    void ensureValid() {
        if (!this.isValid()) {
            throw new P11ProviderException("Token has been removed");
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    void destroy() {
        this.valid = false;
        log.debug("token destroy executed on slot {}", (Object)this.slot);
    }

    public P11Manager p11() {
        return this.p11;
    }

    public long getSlot() {
        return this.slot;
    }

    public CK_SLOT_INFO getSlotInfo() {
        return this.p11.getSlotInfo(this.slot);
    }

    public boolean containsKey(String arg0) {
        return this.certMap.containsKey(arg0);
    }

    public CertInfo getCertInfo(String alias) {
        return this.certMap.get(alias);
    }

    public CertInfo getCaInfo(String alias) {
        return this.caMap.get(alias);
    }

    public String getAlias(Certificate cert) {
        return this.certMap.entrySet().stream().filter(e -> ((CertInfo)e.getValue()).getCert() != null && ((CertInfo)e.getValue()).getCert() == cert).map(Map.Entry::getKey).findFirst().orElse(null);
    }

    public Certificate[] getCertificateChain(String alias) {
        X509Certificate cert = (X509Certificate)this.getCertificate(alias);
        if (cert == null) {
            return null;
        }
        List<X509Certificate> caCerts = this.caMap.entrySet().stream().map(Map.Entry::getValue).map(CertInfo::getCert).toList();
        if (caCerts != null && !caCerts.isEmpty()) {
            return CertService.buildChain(cert, caCerts);
        }
        return new Certificate[]{cert};
    }

    public Certificate getCertificate(String alias) {
        CertInfo info = this.getCertInfo(alias);
        if (info != null) {
            if (info.getCert() != null) {
                return info.getCert();
            }
            Session opSession = this.sessionManager.getLastSession();
            X509Certificate cert = this.p11().getCertificate(opSession.id(), info.getObjectId());
            info.setCert(cert);
            return cert;
        }
        return null;
    }

    public int size() {
        return this.certMap.size();
    }

    public List<X509Certificate> getCACertificates() {
        ArrayList<X509Certificate> cas = new ArrayList<X509Certificate>();
        cas.addAll(this.caMap.values().stream().map(CertInfo::getCert).toList());
        cas.addAll(this.certMap.values().stream().map(CertInfo::getCert).filter(cert -> cert.getBasicConstraints() != -1).toList());
        return cas;
    }

    public boolean delete(CertInfo certInfo, boolean deletePrivateKey) {
        TreeSet deleteCAs = new TreeSet();
        this.caMap.entrySet().forEach(ca -> {
            if (this.certMap.values().stream().noneMatch(info -> this.chainsTo(info.getCert(), ((CertInfo)ca.getValue()).getCert()))) {
                deleteCAs.add((String)ca.getKey());
            }
        });
        boolean deleted = this.deleteCert(certInfo.getAlias(), deletePrivateKey);
        deleteCAs.forEach(this::deleteCA);
        this.dump();
        return deleted;
    }

    private boolean chainsTo(X509Certificate cert, X509Certificate issuer) {
        AtomicReference<X509Certificate> cursor = new AtomicReference<X509Certificate>(cert);
        CertInfo caIssuer;
        while ((caIssuer = (CertInfo)this.caMap.values().stream().filter(ca -> CertService.checkIssuer(ca.getCert(), (X509Certificate)cursor.get())).findAny().orElse(null)) != null) {
            if (Arrays.equals(caIssuer.getCert().getSignature(), issuer.getSignature())) {
                return true;
            }
            if (CertUtils.isSelfSigned((X509Certificate)caIssuer.getCert())) {
                return false;
            }
            cursor.set(caIssuer.getCert());
        }
        return false;
    }

    private boolean deleteCert(String alias, boolean deletePrivateKey) {
        log.info("eliminando certificado final con alias {}", (Object)alias);
        CertInfo info = this.certMap.get(alias);
        if (info != null) {
            this.destroy(info);
            this.certMap.remove(alias);
            if (deletePrivateKey && info.getPrivateKey() != null && this.isLoggedInNow(info.getPrivateKey().getSession())) {
                this.destroy(info.getPrivateKey());
                info.setPrivateKey(null);
            }
            return true;
        }
        return false;
    }

    private void destroy(JNAPrivateKey privateKey) {
        String keyId = new String(privateKey.getId());
        log.info("destruyendo objeto pkcs11 de llave privada con id {}", (Object)keyId);
        Session session = privateKey.getSession();
        this.p11().C_DestroyObject(session.id(), privateKey.getKeyHandle());
        log.info("destruido objeto pkcs11 de llave privada con id {}", (Object)keyId);
        this.freeSession(session);
    }

    public void deleteCA(String alias) {
        log.info("eliminando CA con alias {}", (Object)alias);
        CertInfo info = this.caMap.get(alias);
        if (info != null) {
            this.destroy(info);
            this.caMap.remove(alias);
        }
    }

    private void destroy(CertInfo info) {
        log.info("destruyendo objeto pkcs11 de certificado con alias {}", (Object)info.getAlias());
        Session session = info.getSession();
        this.p11().C_DestroyObject(session.id(), info.getObjectId());
        log.info("destruido objeto pkcs11 de certificado con alias {}", (Object)info.getAlias());
        this.freeSession(session);
    }

    public void freeSession(Session session) {
        if (session != null) {
            session.removeObject();
            this.sessionManager.addNewFreeSession(session);
        }
    }

    public void insert(CertInfo certInfo) {
        if (certInfo.isCa()) {
            this.caMap.put(certInfo.getAlias(), certInfo);
        } else {
            this.certMap.put(certInfo.getAlias(), certInfo);
        }
    }

    public void deleteOrphanKeys() {
        long[] keys;
        Session session = this.getLastSession();
        this.ensureLoggedIn(session);
        for (long keyId : keys = this.p11.findPrivateKeys(session.id())) {
            CK_ATTRIBUTE id = new CK_ATTRIBUTE(258L);
            CK_ATTRIBUTE label = new CK_ATTRIBUTE(3L);
            CK_ATTRIBUTE[] aliasTemplate = new CK_ATTRIBUTE[]{id, label};
            this.p11().C_GetAttributeValue(session.id(), keyId, aliasTemplate);
            if (!this.certMap.values().stream().noneMatch(cert -> Arrays.equals(cert.getId(), id.pValue))) continue;
            if (log.isInfoEnabled()) {
                log.info("destruyendo llave privada con key id {}, cka_id: {} y alias {}", (Object)Hex.toHexString((byte[])id.pValue), (Object)label.getValueStr());
            }
            this.p11.C_DestroyObject(session.id(), keyId);
        }
        for (long keyId : keys = this.p11.findPublicKeys(session.id())) {
            log.info("destruyendo llave publica con key id {}", (Object)keyId);
            this.p11.C_DestroyObject(session.id(), keyId);
        }
    }

    public void dump() {
        log.debug("logged in: {}", (Object)this.loggedIn);
        log.debug("certiticados totales: {}", (Object)this.certMap.size());
        this.certMap.entrySet().forEach(e -> log.debug("alias: {} cert info [{}, private key: [{}]]", e.getKey(), e.getValue(), (Object)((CertInfo)e.getValue()).getPrivateKey()));
        log.debug("CAs totales: {}", (Object)this.caMap.size());
        this.caMap.entrySet().forEach(e -> log.debug("alias: {} ca info [{}]", e.getKey(), e.getValue()));
        this.sessionManager.dump();
    }
}

