/*
 * Decompiled with CFR 0.152.
 */
package com.anf.pkcs11.provider.model;

import com.anf.pkcs11.provider.model.JNAPrivateKey;
import com.anf.pkcs11.provider.model.Session;
import java.security.cert.X509Certificate;
import java.util.Date;

public class CertInfo {
    private String alias;
    private byte[] id;
    private long objectId;
    private X509Certificate cert;
    private Date date = new Date();
    private boolean ca;
    private Session session;
    private JNAPrivateKey privateKey;

    public CertInfo(Session session, String alias, byte[] id, long objectId, X509Certificate cert) {
        this.session = session;
        this.alias = alias;
        this.id = id;
        this.objectId = objectId;
        this.cert = cert;
        this.ca = cert.getBasicConstraints() != -1;
        session.addObject();
    }

    public void setPrivateKey(JNAPrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public JNAPrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        if (session != null) {
            this.session.removeObject();
            this.session = session;
        }
    }

    public boolean isCa() {
        return this.ca;
    }

    public void setCa(boolean ca) {
        this.ca = ca;
    }

    public Date getDate() {
        return this.date;
    }

    public byte[] getId() {
        return this.id;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public long getObjectId() {
        return this.objectId;
    }

    public void setObjectId(long objectId) {
        this.objectId = objectId;
    }

    public X509Certificate getCert() {
        return this.cert;
    }

    public void setCert(X509Certificate cert) {
        this.cert = cert;
    }

    public String toString() {
        return "cert id: " + this.objectId + ", cka_id: " + new String(this.id) + ", session: " + this.session;
    }
}

