/*
 * Decompiled with CFR 0.152.
 */
package com.anf.pkcs11.provider.impl;

import com.anf.pkcs11.jna.CKM;
import com.anf.pkcs11.jna.LongRef;
import com.anf.pkcs11.provider.impl.SignatureAlgorithmParam;
import com.anf.pkcs11.provider.model.JNAPrivateKey;
import com.anf.pkcs11.provider.model.JNAToken;
import com.anf.pkcs11.provider.model.Session;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.util.encoders.Hex;

public class JNASignature
extends SignatureSpi {
    private static final Logger log = LogManager.getLogger(JNASignature.class);
    private Map<String, Object> params = new TreeMap<String, Object>();
    private JNAToken token;
    private Action action;
    private Signature verify;
    private MessageDigest digester;
    private Session session;
    private ByteArrayOutputStream buffer;
    private SignatureAlgorithmParam param;

    public JNASignature(JNAToken token, SignatureAlgorithmParam param) throws NoSuchAlgorithmException {
        this.token = token;
        this.param = param;
        this.verify = Signature.getInstance(param.getSignAlg());
        if (param.getHashAlg() != null) {
            this.digester = MessageDigest.getInstance(param.getHashAlg());
        } else {
            this.buffer = new ByteArrayOutputStream();
        }
    }

    @Override
    protected Object engineGetParameter(String arg0) throws InvalidParameterException {
        return this.params.get(arg0);
    }

    @Override
    protected void engineInitSign(PrivateKey arg0) throws InvalidKeyException {
        this.action = Action.SIGN;
        if (!(arg0 instanceof JNAPrivateKey)) {
            throw new InvalidKeyException("private key is not instance of JNAPrivateKey");
        }
        JNAPrivateKey privateKey = (JNAPrivateKey)arg0;
        this.session = privateKey.getSession();
        this.token.ensureLoggedIn(this.session);
        this.token.p11().validate(this.token.p11().getPkcs11().SignInit(privateKey.getSession().id(), new CKM(this.param.getMechanism()), privateKey.getKeyHandle()));
    }

    @Override
    protected void engineInitVerify(PublicKey arg0) throws InvalidKeyException {
        this.action = Action.VERIFY;
        this.verify.initVerify(arg0);
    }

    @Override
    protected void engineSetParameter(String arg0, Object arg1) throws InvalidParameterException {
        this.params.put(arg0, arg1);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        if (this.action == null || this.action != Action.SIGN) {
            throw new SignatureException("invalid state, call initSign first");
        }
        this.token.ensureLoggedIn(this.session);
        byte[] hash = null;
        if (this.digester != null) {
            hash = this.digester.digest();
            log.debug("hash before padding: {}", (Object)Hex.toHexString((byte[])hash));
            try {
                hash = new DigestInfo(new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256, (ASN1Encodable)DERNull.INSTANCE), hash).getEncoded();
            }
            catch (IOException e) {
                throw new SignatureException(e);
            }
            log.debug("hash after padding: {}", (Object)Hex.toHexString((byte[])hash));
        } else {
            hash = this.buffer.toByteArray();
            log.debug("hash to sign: {}", (Object)Hex.toHexString((byte[])hash));
        }
        LongRef len = new LongRef();
        this.token.p11().validate(this.token.p11().getPkcs11().Sign(this.session.id(), hash, null, len));
        byte[] signature = new byte[(int)len.value];
        this.token.p11().validate(this.token.p11().getPkcs11().Sign(this.session.id(), hash, signature, len));
        return signature;
    }

    @Override
    protected void engineUpdate(byte arg0) throws SignatureException {
        if (this.action == null) {
            throw new SignatureException("invalid state, call initSign or initVerify first");
        }
        if (this.action == Action.SIGN) {
            this.token.ensureLoggedIn(this.session);
            if (this.digester != null) {
                this.digester.update(arg0);
            } else {
                try {
                    this.buffer.write(new byte[]{arg0});
                }
                catch (IOException e) {
                    throw new SignatureException("update byte error", e);
                }
            }
        } else {
            this.verify.update(arg0);
        }
    }

    @Override
    protected void engineUpdate(byte[] bytes, int from, int length) throws SignatureException {
        if (this.action == null) {
            throw new SignatureException("invalid state, call initSign or initVerify first");
        }
        byte[] update = new byte[length];
        System.arraycopy(bytes, from, update, 0, update.length);
        if (this.action == Action.SIGN) {
            this.token.ensureLoggedIn(this.session);
            if (this.digester != null) {
                this.digester.update(bytes, from, length);
            } else {
                try {
                    this.buffer.write(update);
                }
                catch (IOException e) {
                    throw new SignatureException("update byte array error", e);
                }
            }
        } else {
            this.verify.update(update);
        }
    }

    @Override
    protected boolean engineVerify(byte[] arg0) throws SignatureException {
        log.info("signature to verify: [{}] {}", (Object)arg0.length, (Object)Hex.toHexString((byte[])arg0));
        if (this.action == null || this.action != Action.VERIFY) {
            throw new SignatureException("invalid state, call initSign first");
        }
        return this.verify.verify(arg0);
    }

    private static enum Action {
        SIGN,
        VERIFY;

    }
}

