/*
 * Decompiled with CFR 0.152.
 */
package com.anf.pkcs11.jna;

import com.anf.pkcs11.jna.Buf;
import com.anf.pkcs11.jna.CKM;
import com.anf.pkcs11.jna.CKR;
import com.anf.pkcs11.jna.CKU;
import com.anf.pkcs11.jna.CK_ATTRIBUTE;
import com.anf.pkcs11.jna.CK_C_INITIALIZE_ARGS;
import com.anf.pkcs11.jna.CK_INFO;
import com.anf.pkcs11.jna.CK_MECHANISM_INFO;
import com.anf.pkcs11.jna.CK_NOTIFY;
import com.anf.pkcs11.jna.CK_SESSION_INFO;
import com.anf.pkcs11.jna.CK_SLOT_INFO;
import com.anf.pkcs11.jna.CK_TOKEN_INFO;
import com.anf.pkcs11.jna.Hex;
import com.anf.pkcs11.jna.LongRef;
import com.anf.pkcs11.jna.NativePointer;
import com.anf.pkcs11.jna.NativeProvider;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PKCS11Impl {
    private static final Logger log = LogManager.getLogger(PKCS11Impl.class);
    private NativeProvider provider;
    private final NativePointer NULL = new NativePointer(0L);

    public PKCS11Impl(NativeProvider nativeProvider) {
        this.provider = nativeProvider;
    }

    public long Initialize() {
        CK_C_INITIALIZE_ARGS args = new CK_C_INITIALIZE_ARGS(null, null, null, null, 2L);
        return this.Initialize(args);
    }

    public long Initialize(CK_C_INITIALIZE_ARGS pInitArgs) {
        if (log.isDebugEnabled()) {
            log.debug("> C_Initialize " + pInitArgs);
        }
        long rv = this.provider.C_Initialize(pInitArgs);
        if (log.isDebugEnabled()) {
            log.debug(String.format("< C_Initialize rv=0x%08x{%s}", rv, CKR.L2S(rv)));
        }
        return rv;
    }

    public long WaitForSlotEvent(long flags, LongRef slot, NativePointer reserved) {
        if (log.isDebugEnabled()) {
            log.debug("> C_WaitForSlotEvent");
        }
        long rv = this.provider.C_WaitForSlotEvent(flags, slot, reserved != null ? reserved : this.NULL);
        if (log.isDebugEnabled()) {
            log.debug(String.format("< C_WaitForSlotEvent rv=0x%08x{%s} slot=%d", rv, CKR.L2S(rv), slot.value()));
        }
        return rv;
    }

    public long Finalize() {
        if (log.isDebugEnabled()) {
            log.debug("> C_Finalize");
        }
        long rv = this.provider.C_Finalize(this.NULL);
        if (log.isDebugEnabled()) {
            log.debug(String.format("< C_Finalize rv=0x%08x{%s}", rv, CKR.L2S(rv)));
        }
        return rv;
    }

    public long GetInfo(CK_INFO info) {
        if (log.isDebugEnabled()) {
            log.debug("> C_GetInfo");
        }
        long rv = this.provider.C_GetInfo(info);
        if (log.isDebugEnabled()) {
            log.debug(String.format("< C_GetInfo rv=0x%08x{%s}\n%s", rv, CKR.L2S(rv), info));
        }
        return rv;
    }

    public long GetSlotList(boolean tokenPresent, long[] slotList, LongRef count) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("> C_GetSlotList tokenPresent=%b count=%d", tokenPresent, count.value()));
        }
        long rv = this.provider.C_GetSlotList(tokenPresent, slotList, count);
        if (log.isDebugEnabled()) {
            log.debug(String.format("< C_GetSlotList rv=0x%08x{%s} count=%d\n  %s", rv, CKR.L2S(rv), count.value(), Arrays.toString(slotList)));
        }
        return rv;
    }

    public long GetSlotInfo(long slotID, CK_SLOT_INFO info) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("> C_GetSlotInfo slotID=%d", slotID));
        }
        long rv = this.provider.C_GetSlotInfo(slotID, info);
        if (log.isDebugEnabled()) {
            log.debug(String.format("< C_GetSlotInfo rv=0x%08x{%s}\n%s", rv, CKR.L2S(rv), info));
        }
        return rv;
    }

    public long GetTokenInfo(long slotID, CK_TOKEN_INFO info) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("> C_GetTokenInfo slotID=%d", slotID));
        }
        long rv = this.provider.C_GetTokenInfo(slotID, info);
        if (log.isDebugEnabled()) {
            log.debug(String.format("< C_GetTokenInfo rv=0x%08x{%s}\n%s", rv, CKR.L2S(rv), info));
        }
        return rv;
    }

    public long GetMechanismList(long slotID, long[] mechanismList, LongRef count) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("> C_GetMechanismList slotID=%d count=%d", slotID, count.value()));
        }
        long rv = this.provider.C_GetMechanismList(slotID, mechanismList, count);
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(String.format("< C_GetMechanismList rv=0x%08x{%s} count=%d", rv, CKR.L2S(rv), count.value()));
            if (mechanismList != null) {
                sb.append('\n');
                for (long m : mechanismList) {
                    sb.append(String.format("  0x%08x{%s}\n", m, CKM.L2S(m)));
                }
            }
            log.debug((CharSequence)sb);
        }
        return rv;
    }

    public long GetMechanismInfo(long slotID, long type, CK_MECHANISM_INFO info) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("> C_GetMechanismInfo slotID=%d type=0x%08x{%s}", slotID, type, CKM.L2S(type)));
        }
        long rv = this.provider.C_GetMechanismInfo(slotID, type, info);
        if (log.isDebugEnabled()) {
            log.debug(String.format("< C_GetMechanismInfo rv=0x%08x{%s}\n%s", rv, CKR.L2S(rv), info));
        }
        return rv;
    }

    public long InitToken(long slotID, byte[] pin, byte[] label) {
        byte[] label32;
        if (label != null && label.length == 32) {
            label32 = label;
        } else {
            label32 = new byte[32];
            Arrays.fill(label32, (byte)32);
            if (label != null) {
                System.arraycopy(label, 0, label32, 0, Math.min(label32.length, label.length));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("> C_InitToken slotID=%d pin=*** label=%s", slotID, Buf.escstr(label32)));
        }
        long rv = this.provider.C_InitToken(slotID, pin, this.baLen(pin), label32);
        if (log.isDebugEnabled()) {
            log.debug(String.format("< C_InitToken rv=0x%08x{%s}", rv, CKR.L2S(rv)));
        }
        return rv;
    }

    public long InitPIN(long session, byte[] pin) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("> C_InitPIN session=0x%08x pin=***", session));
        }
        long rv = this.provider.C_InitPIN(session, pin, this.baLen(pin));
        if (log.isDebugEnabled()) {
            log.debug(String.format("< C_InitPIN rv=0x%08x{%s}", rv, CKR.L2S(rv)));
        }
        return rv;
    }

    public long SetPIN(long session, byte[] oldPin, byte[] newPin) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("> C_SetPIN session=0x%08x oldPin=*** newPin=***", session));
        }
        long rv = this.provider.C_SetPIN(session, oldPin, this.baLen(oldPin), newPin, this.baLen(newPin));
        if (log.isDebugEnabled()) {
            log.debug(String.format("< C_SetPIN rv=0x%08x{%s}", rv, CKR.L2S(rv)));
        }
        return rv;
    }

    public long OpenSession(long slotID, long flags, NativePointer application, CK_NOTIFY notify, LongRef session) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("> C_OpenSession slotID=%d flags=0x%08x{%s} application=%s notify=%s", slotID, flags, CK_SESSION_INFO.f2s(flags), application, notify));
        }
        long rv = this.provider.C_OpenSession(slotID, flags, application != null ? application : this.NULL, notify, session);
        if (log.isDebugEnabled()) {
            log.debug(String.format("< C_OpenSession rv=0x%08x{%s} session=0x%08x", rv, CKR.L2S(rv), session.value()));
        }
        return rv;
    }

    public long CloseSession(long session) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("> C_CloseSession session=0x%08x", session));
        }
        long rv = this.provider.C_CloseSession(session);
        if (log.isDebugEnabled()) {
            log.debug(String.format("< C_CloseSession rv=0x%08x{%s}", rv, CKR.L2S(rv)));
        }
        return rv;
    }

    public long CloseAllSessions(long slotID) {
        if (log.isDebugEnabled()) {
            log.debug("> C_CloseAllSessions");
        }
        long rv = this.provider.C_CloseAllSessions(slotID);
        if (log.isDebugEnabled()) {
            log.debug(String.format("< C_CloseAllSessions rv=0x%08x{%s}", rv, CKR.L2S(rv)));
        }
        return rv;
    }

    public long GetSessionInfo(long session, CK_SESSION_INFO info) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("> C_GetSessionInfo session=0x%08x", session));
        }
        long rv = this.provider.C_GetSessionInfo(session, info);
        if (log.isDebugEnabled()) {
            log.debug(String.format("< C_GetSessionInfo rv=0x%08x{%s}\n%s", rv, CKR.L2S(rv), info));
        }
        return rv;
    }

    public long GetOperationState(long session, byte[] operationState, LongRef operationStateLen) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("> C_GetOperationState session=0x%08x operationStateLen=%d", session, operationStateLen.value()));
        }
        long rv = this.provider.C_GetOperationState(session, operationState, operationStateLen);
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(String.format("< C_GetOperationState rv=0x%08x{%s}\n  operationState (len=%d):\n", rv, CKR.L2S(rv), operationStateLen.value()));
            if (operationState != null) {
                Hex.dump(sb, operationState, 0, (int)operationStateLen.value(), "  ", 32, false);
            }
            log.debug((CharSequence)sb);
        }
        return rv;
    }

    public long SetOperationState(long session, byte[] operationState, long encryptionKey, long authenticationKey) {
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(String.format("> C_SetOperationState session=0x%08x encryptionKey=0x%08x authenticationKey=0x%08x\n  operationState (len=%d):\n", session, encryptionKey, authenticationKey, operationState.length));
            Hex.dump(sb, operationState, 0, operationState.length, "  ", 32, false);
            log.debug((CharSequence)sb);
        }
        long rv = this.provider.C_SetOperationState(session, operationState, this.baLen(operationState), encryptionKey, authenticationKey);
        if (log.isDebugEnabled()) {
            log.debug(String.format("< C_SetOperationState rv=0x%08x{%s}", rv, CKR.L2S(rv)));
        }
        return rv;
    }

    public long Login(long session, long userType, byte[] pin) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("> C_Login session=0x%08x userType=0x%08x{%s} pin=***", session, userType, CKU.L2S(userType)));
        }
        long rv = this.provider.C_Login(session, userType, pin, this.baLen(pin));
        if (log.isDebugEnabled()) {
            log.debug(String.format("< C_Login rv=0x%08x{%s}", rv, CKR.L2S(rv)));
        }
        return rv;
    }

    public long Logout(long session) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("> C_Logout session=0x%08x", session));
        }
        long rv = this.provider.C_Logout(session);
        if (log.isDebugEnabled()) {
            log.debug(String.format("< C_Logout rv=0x%08x{%s}", rv, CKR.L2S(rv)));
        }
        return rv;
    }

    public long CreateObject(long session, CK_ATTRIBUTE[] templ, LongRef object) {
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(String.format("> C_CreateObject session=0x%08x\n", session));
            this.dumpTemplate(sb, templ);
            log.debug((CharSequence)sb);
        }
        long rv = this.provider.C_CreateObject(session, templ, this.templLen(templ), object);
        if (log.isDebugEnabled()) {
            log.debug(String.format("< C_CreateObject rv=0x%08x{%s} object=0x%08x", rv, CKR.L2S(rv), object.value()));
        }
        return rv;
    }

    public long CopyObject(long session, long object, CK_ATTRIBUTE[] templ, LongRef newObject) {
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(String.format("> C_CopyObject session=0x%08x object=0x%08x\n", session, object));
            this.dumpTemplate(sb, templ);
            log.debug((CharSequence)sb);
        }
        long rv = this.provider.C_CopyObject(session, object, templ, this.templLen(templ), newObject);
        if (log.isDebugEnabled()) {
            log.debug(String.format("< C_CopyObject rv=0x%08x{%s} newObject=0x%08x", rv, CKR.L2S(rv), newObject.value()));
        }
        return rv;
    }

    public long DestroyObject(long session, long object) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("> C_DestroyObject session=0x%08x object=0x%08x", session, object));
        }
        long rv = this.provider.C_DestroyObject(session, object);
        if (log.isDebugEnabled()) {
            log.debug(String.format("< C_DestroyObject rv=0x%08x{%s}", rv, CKR.L2S(rv)));
        }
        return rv;
    }

    public long GetObjectSize(long session, long object, LongRef size) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("> C_GetObjectSize session=0x%08x object=0x%08x", session, object));
        }
        long rv = this.provider.C_GetObjectSize(session, object, size);
        if (log.isDebugEnabled()) {
            log.debug(String.format("< C_GetObjectSize rv=0x%08x{%s} size=%d", rv, CKR.L2S(rv), size.value()));
        }
        return rv;
    }

    public long GetAttributeValue(long session, long object, CK_ATTRIBUTE[] template) {
        if (template == null) {
            return 5L;
        }
        if (log.isDebugEnabled()) {
            StringBuilder stringBuilder = new StringBuilder(String.format("> C_GetAttributeValue session=0x%08x object=0x%08x\n", session, object));
            this.dumpTemplate(stringBuilder, template);
            log.debug((CharSequence)stringBuilder);
        }
        for (CK_ATTRIBUTE attr : template) {
            attr.ulValueLen = 0L;
            attr.pValue = null;
        }
        long l = this.provider.C_GetAttributeValue(session, object, template, this.templLen(template));
        if (0L == l) {
            for (CK_ATTRIBUTE attr : template) {
                if (attr.ulValueLen < 0L) continue;
                attr.pValue = new byte[(int)attr.ulValueLen];
            }
            l = this.provider.C_GetAttributeValue(session, object, template, this.templLen(template));
        }
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(String.format("< C_GetAttributeValue rv=0x%08x{%s}\n", l, CKR.L2S(l)));
            this.dumpTemplate(sb, template);
            log.debug((CharSequence)sb);
        }
        return l;
    }

    public long SetAttributeValue(long session, long object, CK_ATTRIBUTE[] templ) {
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(String.format("> C_SetAttributeValue session=0x%08x object=0x%08x\n", session, object));
            this.dumpTemplate(sb, templ);
            log.debug((CharSequence)sb);
        }
        long rv = this.provider.C_SetAttributeValue(session, object, templ, this.templLen(templ));
        if (log.isDebugEnabled()) {
            log.debug(String.format("< C_SetAttributeValue rv=0x%08x{%s}", rv, CKR.L2S(rv)));
        }
        return rv;
    }

    public long FindObjectsInit(long session, CK_ATTRIBUTE[] templ) {
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(String.format("> C_FindObjectsInit session=0x%08x\n", session));
            this.dumpTemplate(sb, templ);
            log.debug((CharSequence)sb);
        }
        long rv = this.provider.C_FindObjectsInit(session, templ, this.templLen(templ));
        if (log.isDebugEnabled()) {
            log.debug(String.format("< C_FindObjectsInit rv=0x%08x{%s}", rv, CKR.L2S(rv)));
        }
        return rv;
    }

    public long FindObjects(long session, long[] found, LongRef objectCount) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("> C_FindObjects session=0x%08x maxObjectCount=%d", session, found != null ? found.length : 0));
        }
        long rv = this.provider.C_FindObjects(session, found, found == null ? 0L : (long)found.length, objectCount);
        if (log.isDebugEnabled()) {
            int count = (int)objectCount.value();
            if (found != null) {
                long[] toDisplay = found;
                if (count < found.length) {
                    toDisplay = new long[count];
                    System.arraycopy(found, 0, toDisplay, 0, count);
                }
                log.debug(String.format("< C_FindObjects rv=0x%08x{%s} objectCount=%d\n  %s", rv, CKR.L2S(rv), objectCount.value(), Arrays.toString(toDisplay)));
            }
        }
        return rv;
    }

    public long FindObjectsFinal(long session) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("> C_FindObjectsFinal session=0x%08x", session));
        }
        long rv = this.provider.C_FindObjectsFinal(session);
        if (log.isDebugEnabled()) {
            log.debug(String.format("< C_FindObjectsFinal rv=0x%08x{%s}", rv, CKR.L2S(rv)));
        }
        return rv;
    }

    public long EncryptInit(long session, CKM mechanism, long key) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("> C_EncryptInit session=0x%08x key=0x%08x\n  %s", session, key, mechanism));
        }
        long rv = this.provider.C_EncryptInit(session, mechanism, key);
        if (log.isDebugEnabled()) {
            log.debug(String.format("< C_EncryptInit rv=0x%08x{%s}", rv, CKR.L2S(rv)));
        }
        return rv;
    }

    public long Encrypt(long session, byte[] data, byte[] encryptedData, LongRef encryptedDataLen) {
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(String.format("> C_Encrypt session=0x%08x encryptedDataLen=%d data\n  (len=%d):\n", session, encryptedDataLen.value(), data.length));
            Hex.dump(sb, data, 0, data.length, "  ", 32, false);
            log.debug((CharSequence)sb);
        }
        long rv = this.provider.C_Encrypt(session, data, this.baLen(data), encryptedData, encryptedDataLen);
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(String.format("< C_Encrypt rv=0x%08x{%s}\n  encryptedData (len=%d):\n", rv, CKR.L2S(rv), encryptedDataLen.value()));
            Hex.dump(sb, encryptedData, 0, (int)encryptedDataLen.value(), "  ", 32, false);
            log.debug((CharSequence)sb);
        }
        return rv;
    }

    public long EncryptUpdate(long session, byte[] part, byte[] encryptedPart, LongRef encryptedPartLen) {
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(String.format("> C_EncryptUpdate session=0x%08x encryptedPartLen=%d\n  part (len=%d):\n", session, encryptedPartLen.value(), part.length));
            Hex.dump(sb, part, 0, part.length, "  ", 32, false);
            log.debug((CharSequence)sb);
        }
        long rv = this.provider.C_EncryptUpdate(session, part, this.baLen(part), encryptedPart, encryptedPartLen);
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(String.format("< C_EncryptUpdate rv=0x%08x{%s}\n  encryptedPart (len=%d):\n", rv, CKR.L2S(rv), encryptedPartLen.value()));
            Hex.dump(sb, encryptedPart, 0, (int)encryptedPartLen.value(), "  ", 32, false);
            log.debug((CharSequence)sb);
        }
        return rv;
    }

    public long EncryptFinal(long session, byte[] lastEncryptedPart, LongRef lastEncryptedPartLen) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("> C_EncryptFinal session=0x%08x lastEncryptedPartLen=%d", session, lastEncryptedPartLen.value()));
        }
        long rv = this.provider.C_EncryptFinal(session, lastEncryptedPart, lastEncryptedPartLen);
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(String.format("< C_EncryptFinal rv=0x%08x{%s}\n  lastEncryptedPart (len=%d):\n", rv, CKR.L2S(rv), lastEncryptedPartLen.value()));
            Hex.dump(sb, lastEncryptedPart, 0, (int)lastEncryptedPartLen.value(), "  ", 32, false);
            log.debug((CharSequence)sb);
        }
        return rv;
    }

    public long DecryptInit(long session, CKM mechanism, long key) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("> C_DecryptInit session=0x%08x key=0x%08x\n  %s", session, key, mechanism));
        }
        long rv = this.provider.C_DecryptInit(session, mechanism, key);
        if (log.isDebugEnabled()) {
            log.debug(String.format("< C_DecryptInit rv=0x%08x{%s}", rv, CKR.L2S(rv)));
        }
        return rv;
    }

    public long Decrypt(long session, byte[] encryptedData, byte[] data, LongRef dataLen) {
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(String.format("> C_Decrypt session=0x%08x dataLen=%d\n encryptedData (len=%d):\n", session, dataLen.value(), encryptedData.length));
            Hex.dump(sb, encryptedData, 0, encryptedData.length, "  ", 32, false);
            log.debug((CharSequence)sb);
        }
        long rv = this.provider.C_Decrypt(session, encryptedData, this.baLen(encryptedData), data, dataLen);
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(String.format("< C_Decrypt rv=0x%08x{%s}\n  data (len=%d):\n", rv, CKR.L2S(rv), dataLen.value()));
            Hex.dump(sb, data, 0, (int)dataLen.value(), "  ", 32, false);
            log.debug((CharSequence)sb);
        }
        return rv;
    }

    public long DecryptUpdate(long session, byte[] encryptedPart, byte[] data, LongRef dataLen) {
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(String.format("> C_DecryptUpdate session=0x%08x dataLen=%d\n  encryptedPart (len=%d):\n", session, dataLen.value(), encryptedPart.length));
            Hex.dump(sb, encryptedPart, 0, encryptedPart.length, "  ", 32, false);
            log.debug((CharSequence)sb);
        }
        long rv = this.provider.C_DecryptUpdate(session, encryptedPart, this.baLen(encryptedPart), data, dataLen);
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(String.format("< C_DecryptUpdate rv=0x%08x{%s}\n  data (len=%d):\n", rv, CKR.L2S(rv), dataLen.value()));
            Hex.dump(sb, data, 0, (int)dataLen.value(), "  ", 32, false);
            log.debug((CharSequence)sb);
        }
        return rv;
    }

    public long DecryptFinal(long session, byte[] lastPart, LongRef lastPartLen) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("> C_DecryptFinal session=0x%08x lastPartLen=%d", session, lastPartLen.value()));
        }
        long rv = this.provider.C_DecryptFinal(session, lastPart, lastPartLen);
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(String.format("< C_DecryptFinal rv=0x%08x{%s}\n  lastPart (len=%d):\n", rv, CKR.L2S(rv), lastPartLen.value()));
            Hex.dump(sb, lastPart, 0, (int)lastPartLen.value(), "  ", 32, false);
            log.debug((CharSequence)sb);
        }
        return rv;
    }

    public long DigestInit(long session, CKM mechanism) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("> C_DigestInit session=0x%08x\n  %s", session, mechanism));
        }
        long rv = this.provider.C_DigestInit(session, mechanism);
        if (log.isDebugEnabled()) {
            log.debug(String.format("< C_DigestInit rv=0x%08x{%s}", rv, CKR.L2S(rv)));
        }
        return rv;
    }

    public long Digest(long session, byte[] data, byte[] digest, LongRef digestLen) {
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(String.format("> C_Digest session=0x%08x digestLen=%d\n  data (len=%d):\n", session, digestLen.value(), data.length));
            Hex.dump(sb, data, 0, data.length, "  ", 32, false);
            log.debug((CharSequence)sb);
        }
        long rv = this.provider.C_Digest(session, data, this.baLen(data), digest, digestLen);
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(String.format("< C_Digest rv=0x%08x{%s}\n  digest (len=%d):\n", rv, CKR.L2S(rv), digestLen.value()));
            Hex.dump(sb, digest, 0, (int)digestLen.value(), "  ", 32, false);
            log.debug((CharSequence)sb);
        }
        return rv;
    }

    public long DigestUpdate(long session, byte[] part) {
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(String.format("> C_DigestUpdate session=0x%08x\n  part (len=%d):\n", session, part.length));
            Hex.dump(sb, part, 0, part.length, "  ", 32, false);
            log.debug((CharSequence)sb);
        }
        long rv = this.provider.C_DigestUpdate(session, part, this.baLen(part));
        if (log.isDebugEnabled()) {
            log.debug(String.format("< C_DigestUpdate rv=0x%08x{%s}", rv, CKR.L2S(rv)));
        }
        return rv;
    }

    public long DigestKey(long session, long key) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("> C_DigestKey session=0x%08x key=0x%08x", session, key));
        }
        long rv = this.provider.C_DigestKey(session, key);
        if (log.isDebugEnabled()) {
            log.debug(String.format("< C_DigestKey rv=0x%08x{%s}", rv, CKR.L2S(rv)));
        }
        return rv;
    }

    public long DigestFinal(long session, byte[] digest, LongRef digestLen) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("> C_DigestFial session=0x%08x digestLen=%d", session, digestLen.value()));
        }
        long rv = this.provider.C_DigestFinal(session, digest, digestLen);
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(String.format("< C_DigestFinal rv=0x%08x{%s}\n  digest (len=%d):\n", rv, CKR.L2S(rv), digestLen.value()));
            Hex.dump(sb, digest, 0, (int)digestLen.value(), "  ", 32, false);
            log.debug((CharSequence)sb);
        }
        return rv;
    }

    public long SignInit(long session, CKM mechanism, long key) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("> C_SignInit session=0x%08x key=0x%08x\n  %s", session, key, mechanism));
        }
        long rv = this.provider.C_SignInit(session, mechanism, key);
        if (log.isDebugEnabled()) {
            log.debug(String.format("< C_SignInit rv=0x%08x{%s}", rv, CKR.L2S(rv)));
        }
        return rv;
    }

    public long Sign(long session, byte[] data, byte[] signature, LongRef signatureLen) {
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(String.format("> C_Sign session=0x%08x signatureLen=%d\n  data (len=%d):\n", session, signatureLen.value(), data.length));
            Hex.dump(sb, data, 0, data.length, "  ", 32, false);
            log.debug((CharSequence)sb);
        }
        long rv = this.provider.C_Sign(session, data, this.baLen(data), signature, signatureLen);
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(String.format("< C_Sign rv=0x%08x{%s}\n  signature (len=%d):\n", rv, CKR.L2S(rv), signatureLen.value()));
            Hex.dump(sb, signature, 0, (int)signatureLen.value(), "  ", 32, false);
            log.debug((CharSequence)sb);
        }
        return rv;
    }

    public long SignUpdate(long session, byte[] part) {
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(String.format("> C_SignUpdate session=0x%08x\n  part (len=%d):\n", session, part.length));
            Hex.dump(sb, part, 0, part.length, "  ", 32, false);
            log.debug((CharSequence)sb);
        }
        long rv = this.provider.C_SignUpdate(session, part, this.baLen(part));
        if (log.isDebugEnabled()) {
            log.debug(String.format("< C_SignUpdate rv=0x%08x{%s}", rv, CKR.L2S(rv)));
        }
        return rv;
    }

    public long SignFinal(long session, byte[] signature, LongRef signatureLen) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("> C_SignFinal session=0x%08x signatureLen=%d", session, signatureLen.value()));
        }
        long rv = this.provider.C_SignFinal(session, signature, signatureLen);
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(String.format("< C_SignFinal rv=0x%08x{%s}\n  signature (len=%d):\n", rv, CKR.L2S(rv), signatureLen.value()));
            Hex.dump(sb, signature, 0, (int)signatureLen.value(), "  ", 32, false);
            log.debug((CharSequence)sb);
        }
        return rv;
    }

    public long SignRecoverInit(long session, CKM mechanism, long key) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("> C_SignRecoverInit session=0x%08x key=0x%08x\n  %s", session, key, mechanism));
        }
        long rv = this.provider.C_SignRecoverInit(session, mechanism, key);
        if (log.isDebugEnabled()) {
            log.debug(String.format("< C_SignRecoverInit rv=0x%08x{%s}", rv, CKR.L2S(rv)));
        }
        return rv;
    }

    public long SignRecover(long session, byte[] data, byte[] signature, LongRef signatureLen) {
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(String.format("> C_SignRecover session=0x%08x signatureLen=%d\n  data (len=%d):\n", session, signatureLen.value(), data.length));
            Hex.dump(sb, data, 0, data.length, "  ", 32, false);
            log.debug((CharSequence)sb);
        }
        long rv = this.provider.C_SignRecover(session, data, this.baLen(data), signature, signatureLen);
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(String.format("< C_SignRecover rv=0x%08x{%s}\n  signature (len=%d):\n", rv, CKR.L2S(rv), signatureLen.value()));
            Hex.dump(sb, signature, 0, (int)signatureLen.value(), "  ", 32, false);
            log.debug((CharSequence)sb);
        }
        return rv;
    }

    public long VerifyInit(long session, CKM mechanism, long key) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("> C_VerifyInit session=0x%08x key=0x%08x\n  %s", session, key, mechanism));
        }
        long rv = this.provider.C_VerifyInit(session, mechanism, key);
        if (log.isDebugEnabled()) {
            log.debug(String.format("< C_VerifyInit rv=0x%08x{%s}", rv, CKR.L2S(rv)));
        }
        return rv;
    }

    public long Verify(long session, byte[] data, byte[] signature) {
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(String.format("> C_Verify session=0x%08x\n  data (len=%d):\n", session, data.length));
            Hex.dump(sb, data, 0, data.length, "  ", 32, false);
            sb.append("\n  signature (len=%d):\n");
            Hex.dump(sb, signature, 0, signature.length, "  ", 32, false);
            log.debug((CharSequence)sb);
        }
        long rv = this.provider.C_Verify(session, data, this.baLen(data), signature, this.baLen(signature));
        log.debug(String.format("< C_Verify rv=0x%08x{%s} ", rv, CKR.L2S(rv)));
        return rv;
    }

    public long VerifyUpdate(long session, byte[] part) {
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(String.format("> C_VerifyUpdate session=0x%08x\n  part (len=%d):\n", session, part.length));
            Hex.dump(sb, part, 0, part.length, "  ", 32, false);
            log.debug((CharSequence)sb);
        }
        long rv = this.provider.C_VerifyUpdate(session, part, this.baLen(part));
        if (log.isDebugEnabled()) {
            log.debug(String.format("< C_VerifyUpdate rv=0x%08x{%s}", rv, CKR.L2S(rv)));
        }
        return rv;
    }

    public long VerifyFinal(long session, byte[] signature) {
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(String.format("> C_VerifyFinal session=0x%08x\n  signature (len=%d):\n", session, signature.length));
            Hex.dump(sb, signature, 0, signature.length, "  ", 32, false);
            log.debug((CharSequence)sb);
        }
        long rv = this.provider.C_VerifyFinal(session, signature, this.baLen(signature));
        if (log.isDebugEnabled()) {
            log.debug(String.format("< C_VerifyFinal rv=0x%08x{%s}", rv, CKR.L2S(rv)));
        }
        return rv;
    }

    public long VerifyRecoverInit(long session, CKM mechanism, long key) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("> C_VerifyRecoverInit session=0x%08x key=0x%08x\n  %s", session, key, mechanism));
        }
        long rv = this.provider.C_VerifyRecoverInit(session, mechanism, key);
        if (log.isDebugEnabled()) {
            log.debug(String.format("< C_VerifyRecoverInit rv=0x%08x{%s}", rv, CKR.L2S(rv)));
        }
        return rv;
    }

    public long VerifyRecover(long session, byte[] signature, byte[] data, LongRef dataLen) {
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(String.format("> C_VerifyRecover session=0x%08x dataLen=%d\n  signature (len=%d):\n", session, dataLen.value(), signature.length));
            Hex.dump(sb, signature, 0, signature.length, "  ", 32, false);
            log.debug((CharSequence)sb);
        }
        long rv = this.provider.C_VerifyRecover(session, signature, this.baLen(signature), data, dataLen);
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(String.format("< C_VerifyRecover rv=0x%08x{%s}\n  data (len=%d):\n", rv, CKR.L2S(rv), dataLen.value()));
            Hex.dump(sb, data, 0, (int)dataLen.value(), "  ", 32, false);
            log.debug((CharSequence)sb);
        }
        return rv;
    }

    public long DigestEncryptUpdate(long session, byte[] part, byte[] encryptedPart, LongRef encryptedPartLen) {
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(String.format("> C_DigestEncryptUpdate session=0x%08x encryptedPartLen=%d\n  part (len=%d):\n", session, encryptedPartLen, part.length));
            Hex.dump(sb, part, 0, part.length, "  ", 32, false);
            log.debug((CharSequence)sb);
        }
        long rv = this.provider.C_DigestEncryptUpdate(session, part, this.baLen(part), encryptedPart, encryptedPartLen);
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(String.format("< C_DigestEncryptUpdate rv=0x%08x{%s}\n  encryptedPart (len=%d):\n", rv, CKR.L2S(rv), encryptedPartLen));
            Hex.dump(sb, encryptedPart, 0, (int)encryptedPartLen.value, "  ", 32, false);
            log.debug((CharSequence)sb);
        }
        return rv;
    }

    public long DecryptDigestUpdate(long session, byte[] encryptedPart, byte[] part, LongRef partLen) {
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(String.format("> C_DecryptDigestUpdate session=0x%08x partLen=%d\n  encryptedPart (len=%d):\n", session, partLen.value(), encryptedPart.length));
            Hex.dump(sb, encryptedPart, 0, encryptedPart.length, "  ", 32, false);
            log.debug((CharSequence)sb);
        }
        long rv = this.provider.C_DecryptDigestUpdate(session, encryptedPart, this.baLen(encryptedPart), part, partLen);
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(String.format("< C_DecryptDigestUpdate rv=0x%08x{%s}\n  part (len=%d):\n", rv, CKR.L2S(rv), partLen.value()));
            Hex.dump(sb, part, 0, (int)partLen.value(), "  ", 32, false);
            log.debug((CharSequence)sb);
        }
        return rv;
    }

    public long SignEncryptUpdate(long session, byte[] part, byte[] encryptedPart, LongRef encryptedPartLen) {
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(String.format("> C_SignEncryptUdate session=0x%08x encryptedPartLen=%d\n  part (len=%d):\n", session, encryptedPartLen.value(), part.length));
            Hex.dump(sb, part, 0, part.length, "  ", 32, false);
            log.debug((CharSequence)sb);
        }
        long rv = this.provider.C_SignEncryptUpdate(session, part, this.baLen(part), encryptedPart, encryptedPartLen);
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(String.format("< C_SignEncryptUpdate rv=0x%08x{%s}\n  encryptedPart (len=%d):\n", rv, CKR.L2S(rv), encryptedPartLen.value()));
            Hex.dump(sb, encryptedPart, 0, (int)encryptedPartLen.value(), "  ", 32, false);
            log.debug((CharSequence)sb);
        }
        return rv;
    }

    public long DecryptVerifyUpdate(long session, byte[] encryptedPart, byte[] part, LongRef partLen) {
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(String.format("> C_DecryptVerifyUpdate session=0x%08x partLen=%d\n  encryptedPart (len=%d):\n", session, partLen.value(), encryptedPart.length));
            Hex.dump(sb, encryptedPart, 0, encryptedPart.length, "  ", 32, false);
            log.debug((CharSequence)sb);
        }
        long rv = this.provider.C_DecryptVerifyUpdate(session, encryptedPart, this.baLen(encryptedPart), part, partLen);
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(String.format("< C_DecryptVerifyUpdate rv=0x%08x{%s}\n  part (len=%d):\n", rv, CKR.L2S(rv), partLen.value()));
            Hex.dump(sb, part, 0, (int)partLen.value(), "  ", 32, false);
            log.debug((CharSequence)sb);
        }
        return rv;
    }

    public long GenerateKey(long session, CKM mechanism, CK_ATTRIBUTE[] templ, LongRef key) {
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(String.format("> C_GenerateKey session=0x%08x %s\n", session, mechanism));
            this.dumpTemplate(sb, templ);
            log.debug((CharSequence)sb);
        }
        long rv = this.provider.C_GenerateKey(session, mechanism, templ, this.templLen(templ), key);
        if (log.isDebugEnabled()) {
            log.debug(String.format("< C_GenerateKey rv=0x%08x{%s} key=0x%08x", rv, CKR.L2S(rv), key.value()));
        }
        return rv;
    }

    public long GenerateKeyPair(long session, CKM mechanism, CK_ATTRIBUTE[] publicKeyTemplate, CK_ATTRIBUTE[] privateKeyTemplate, LongRef publicKey, LongRef privateKey) {
        if (publicKey == null) {
            publicKey = new LongRef();
        }
        if (privateKey == null) {
            privateKey = new LongRef();
        }
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(String.format("> C_GenerateKeyPair session=0x%08x\n  %s", session, mechanism));
            sb.append("\n  publicKeyTemplate:\n");
            this.dumpTemplate(sb, publicKeyTemplate);
            sb.append("\n  privateKeyTemplate:\n");
            this.dumpTemplate(sb, privateKeyTemplate);
            log.debug((CharSequence)sb);
        }
        long rv = this.provider.C_GenerateKeyPair(session, mechanism, publicKeyTemplate, this.templLen(publicKeyTemplate), privateKeyTemplate, this.templLen(privateKeyTemplate), publicKey, privateKey);
        if (log.isDebugEnabled()) {
            log.debug(String.format("< C_GenerateKeyPair rv=0x%08x{%s} publicKey=0x%08x privateKey=0x%08x", rv, CKR.L2S(rv), publicKey.value(), privateKey.value()));
        }
        return rv;
    }

    public long WrapKey(long session, CKM mechanism, long wrappingKey, long key, byte[] wrappedKey, LongRef wrappedKeyLen) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("> C_WrapKey session=0x%08x key=0x%08x\n  %s", session, key, mechanism));
        }
        long rv = this.provider.C_WrapKey(session, mechanism, wrappingKey, key, wrappedKey, wrappedKeyLen);
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(String.format("< C_WrapKey rv=0x%08x{%s}\n  wrappedKey (len=%d):\n", rv, CKR.L2S(rv), wrappedKeyLen.value()));
            Hex.dump(sb, wrappedKey, 0, (int)wrappedKeyLen.value(), "  ", 32, false);
            log.debug((CharSequence)sb);
        }
        return rv;
    }

    public long UnwrapKey(long session, CKM mechanism, long unwrappingKey, byte[] wrappedKey, CK_ATTRIBUTE[] templ, LongRef key) {
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(String.format("> C_UnwrapKey session=0x%08x unwrappingKey=0x%08x %s\n  wrappedKey (len=%d):\n", session, unwrappingKey, mechanism, wrappedKey.length));
            Hex.dump(sb, wrappedKey, 0, wrappedKey.length, "  ", 32, false);
            sb.append('\n');
            this.dumpTemplate(sb, templ);
            log.debug((CharSequence)sb);
        }
        long rv = this.provider.C_UnwrapKey(session, mechanism, unwrappingKey, wrappedKey, this.baLen(wrappedKey), templ, this.templLen(templ), key);
        if (log.isDebugEnabled()) {
            log.debug(String.format("< C_UnwrapKey rv=0x%08x{%s} key=0x%08x", rv, CKR.L2S(rv), key.value()));
        }
        return rv;
    }

    public long DeriveKey(long session, CKM mechanism, long baseKey, CK_ATTRIBUTE[] templ, LongRef key) {
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(String.format("> C_DeriveKey session=0x%08x baseKey=0x%08x %s\n", session, baseKey, mechanism));
            this.dumpTemplate(sb, templ);
            log.debug((CharSequence)sb);
        }
        long rv = this.provider.C_DeriveKey(session, mechanism, baseKey, templ, this.templLen(templ), key);
        if (log.isDebugEnabled()) {
            log.debug(String.format("< C_DeriveKey rv=0x%08x{%s} key=0x%08x", rv, CKR.L2S(rv), key.value()));
        }
        return rv;
    }

    public long SeedRandom(long session, byte[] seed) {
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(String.format("> C_SeedRandom session=0x%08x\n  seed (len=%d):\n", session, seed.length));
            Hex.dump(sb, seed, 0, seed.length, "  ", 32, false);
            log.debug((CharSequence)sb);
        }
        long rv = this.provider.C_SeedRandom(session, seed, this.baLen(seed));
        if (log.isDebugEnabled()) {
            log.debug(String.format("< C_SeedRandom rv=0x%08x{%s}", rv, CKR.L2S(rv)));
        }
        return rv;
    }

    public long GenerateRandom(long session, byte[] randomData) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("> C_GenerateRandom session=0x%08x randomLen=%d", session, randomData.length));
        }
        long rv = this.provider.C_GenerateRandom(session, randomData, this.baLen(randomData));
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(String.format("< C_GenerateRandom rv=0x%08x{%s}\n  randomData (len=%d):\n", rv, CKR.L2S(rv), randomData.length));
            Hex.dump(sb, randomData, 0, randomData.length, "  ", 32, false);
            log.debug((CharSequence)sb);
        }
        return rv;
    }

    public long GetFunctionStatus(long session) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("> C_GetFunctionStatus session=0x%08x", session));
        }
        long rv = this.provider.C_GetFunctionStatus(session);
        if (log.isDebugEnabled()) {
            log.debug(String.format("< C_GetFunctionStatus rv=0x%08x{%s}", rv, CKR.L2S(rv)));
        }
        return rv;
    }

    public long CancelFunction(long session) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("> C_CancelFunction session=0x%08x", session));
        }
        long rv = this.provider.C_CancelFunction(session);
        if (log.isDebugEnabled()) {
            log.debug(String.format("< C_CancelFunction rv=0x%08x{%s}", rv, CKR.L2S(rv)));
        }
        return rv;
    }

    private int baLen(byte[] buf) {
        return buf == null ? 0 : buf.length;
    }

    private int templLen(CK_ATTRIBUTE[] templ) {
        return templ == null ? 0 : templ.length;
    }

    private void dumpTemplate(StringBuilder sb, CK_ATTRIBUTE[] template) {
        int templateLen = this.templLen(template);
        sb.append("  template (size=").append(templateLen).append(')');
        for (int i = 0; i < templateLen; ++i) {
            sb.append("\n  ");
            template[i].dump(sb);
        }
    }

    public static Map<Long, String> createL2SMap(Class<?> c) {
        HashMap<Long, String> map = new HashMap<Long, String>();
        try {
            for (Field f : c.getDeclaredFields()) {
                if (f.getType() != Long.TYPE || !Modifier.isPublic(f.getModifiers()) || !Modifier.isStatic(f.getModifiers()) || !Modifier.isFinal(f.getModifiers())) continue;
                map.put(f.getLong(null), f.getName());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return map;
    }

    public static String l2s(Map<Long, String> map, String ckx, long l) {
        String s = map.get(l);
        if (s != null) {
            return s;
        }
        return String.format("unknown %s constant 0x%08x", ckx, l);
    }

    public static String f2s(Map<Long, String> l2s, long flags) {
        StringBuilder sb = new StringBuilder();
        String sep = "";
        for (int i = 63; i >= 0; --i) {
            long mask = 1L << i;
            if ((flags & mask) == 0L) continue;
            sb.append(sep);
            sb.append(PKCS11Impl.l2s(l2s, "CKF", mask));
            sep = "|";
        }
        return sb.toString();
    }
}

