/*
 * Decompiled with CFR 0.152.
 */
package com.anf.pkcs11.jna;

import com.sun.jna.Memory;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;

public class LongArray
extends PointerType {
    private long[] list;
    private int listLen;

    public LongArray() {
        this(null);
    }

    public LongArray(long[] list) {
        this.list = list;
        int n = this.listLen = list == null ? 0 : list.length;
        if (this.listLen == 0) {
            return;
        }
        this.setPointer((Pointer)new Memory((long)(this.listLen * NativeLong.SIZE)));
        if (NativeLong.SIZE == 8) {
            this.getPointer().write(0L, list, 0, this.listLen);
        } else {
            for (int i = 0; i < this.listLen; ++i) {
                this.getPointer().setInt((long)i, (int)list[i]);
            }
        }
    }

    public void update() {
        if (this.listLen == 0) {
            return;
        }
        if (NativeLong.SIZE == 8) {
            this.getPointer().read(0L, this.list, 0, this.listLen);
        } else {
            for (int i = 0; i < this.listLen; ++i) {
                this.list[i] = this.getPointer().getInt((long)(i * NativeLong.SIZE));
            }
        }
    }
}

