/*
 * Decompiled with CFR 0.152.
 */
package com.anf.pkcs11.jna;

import com.anf.pkcs11.jna.CKM;
import com.anf.pkcs11.jna.CK_ATTRIBUTE;
import com.anf.pkcs11.jna.CK_C_INITIALIZE_ARGS;
import com.anf.pkcs11.jna.CK_INFO;
import com.anf.pkcs11.jna.CK_MECHANISM_INFO;
import com.anf.pkcs11.jna.CK_NOTIFY;
import com.anf.pkcs11.jna.CK_SESSION_INFO;
import com.anf.pkcs11.jna.CK_SLOT_INFO;
import com.anf.pkcs11.jna.CK_TOKEN_INFO;
import com.anf.pkcs11.jna.JNANative;
import com.anf.pkcs11.jna.JNA_CKM;
import com.anf.pkcs11.jna.JNA_CK_C_INITIALIZE_ARGS;
import com.anf.pkcs11.jna.JNA_CK_INFO;
import com.anf.pkcs11.jna.JNA_CK_MECHANISM_INFO;
import com.anf.pkcs11.jna.JNA_CK_NOTIFY;
import com.anf.pkcs11.jna.JNA_CK_SESSION_INFO;
import com.anf.pkcs11.jna.JNA_CK_SLOT_INFO;
import com.anf.pkcs11.jna.JNA_CK_TOKEN_INFO;
import com.anf.pkcs11.jna.LongArray;
import com.anf.pkcs11.jna.LongRef;
import com.anf.pkcs11.jna.NativePointer;
import com.anf.pkcs11.jna.NativeProvider;
import com.anf.pkcs11.jna.Template;
import com.anf.pkcs11.jna.ULong;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.NativeLongByReference;

public class JNA
implements NativeProvider {
    JNANative instance;

    public JNA(String pkcs11) {
        this.instance = (JNANative)Native.load((String)pkcs11, JNANative.class);
        System.out.println();
        ULong.ULONG_SIZE = NativeLong.SIZE == 4 ? ULong.ULongSize.ULONG4 : ULong.ULongSize.ULONG8;
    }

    @Override
    public long C_Initialize(CK_C_INITIALIZE_ARGS pInitArgs) {
        if (pInitArgs == null) {
            return this.instance.C_Initialize(null);
        }
        return this.instance.C_Initialize(new JNA_CK_C_INITIALIZE_ARGS(pInitArgs));
    }

    @Override
    public long C_Finalize(NativePointer pReserved) {
        return this.instance.C_Finalize(new Pointer(pReserved.getAddress()));
    }

    @Override
    public long C_GetInfo(CK_INFO pInfo) {
        JNA_CK_INFO jna_pInfo = new JNA_CK_INFO().readFrom(pInfo);
        long rv = this.instance.C_GetInfo(jna_pInfo);
        jna_pInfo.writeTo(pInfo);
        return rv;
    }

    @Override
    public long C_GetSlotList(boolean tokenPresent, long[] pSlotList, LongRef pulCount) {
        LongArray jna_pSlotList = new LongArray(pSlotList);
        NativeLongByReference jna_pulCount = JNA.NLP(pulCount.value);
        long rv = this.instance.C_GetSlotList(tokenPresent ? (byte)1 : 0, jna_pSlotList, jna_pulCount);
        jna_pSlotList.update();
        pulCount.value = jna_pulCount.getValue().longValue();
        return rv;
    }

    @Override
    public long C_GetSlotInfo(long slotID, CK_SLOT_INFO pInfo) {
        JNA_CK_SLOT_INFO jna_pInfo = new JNA_CK_SLOT_INFO().readFrom(pInfo);
        long rv = this.instance.C_GetSlotInfo(JNA.NL(slotID), jna_pInfo);
        jna_pInfo.writeTo(pInfo);
        return rv;
    }

    @Override
    public long C_GetTokenInfo(long slotID, CK_TOKEN_INFO pInfo) {
        JNA_CK_TOKEN_INFO jna_pInfo = new JNA_CK_TOKEN_INFO().readFrom(pInfo);
        long rv = this.instance.C_GetTokenInfo(JNA.NL(slotID), jna_pInfo);
        jna_pInfo.writeTo(pInfo);
        return rv;
    }

    @Override
    public long C_WaitForSlotEvent(long flags, LongRef pSlot, NativePointer pReserved) {
        return 84L;
    }

    @Override
    public long C_GetMechanismList(long slotID, long[] pMechanismList, LongRef pulCount) {
        LongArray jna_pMechanismList = new LongArray(pMechanismList);
        NativeLongByReference jna_pulCount = JNA.NLP(pulCount.value);
        long rv = this.instance.C_GetMechanismList(JNA.NL(slotID), jna_pMechanismList, jna_pulCount);
        jna_pMechanismList.update();
        pulCount.value = jna_pulCount.getValue().longValue();
        return rv;
    }

    @Override
    public long C_GetMechanismInfo(long slotID, long type, CK_MECHANISM_INFO pInfo) {
        JNA_CK_MECHANISM_INFO jna_pInfo = new JNA_CK_MECHANISM_INFO().readFrom(pInfo);
        long rv = this.instance.C_GetMechanismInfo(JNA.NL(slotID), JNA.NL(type), jna_pInfo);
        jna_pInfo.writeTo(pInfo);
        return rv;
    }

    @Override
    public long C_InitToken(long slotID, byte[] pPin, long ulPinLen, byte[] pLabel32) {
        return this.instance.C_InitToken(JNA.NL(slotID), pPin, JNA.NL(ulPinLen), pLabel32);
    }

    @Override
    public long C_InitPIN(long hSession, byte[] pPin, long ulPinLen) {
        return this.instance.C_InitPIN(JNA.NL(hSession), pPin, JNA.NL(ulPinLen));
    }

    @Override
    public long C_SetPIN(long hSession, byte[] pOldPin, long ulOldLen, byte[] pNewPin, long ulNewLen) {
        return this.instance.C_SetPIN(JNA.NL(hSession), pOldPin, JNA.NL(ulOldLen), pNewPin, JNA.NL(ulNewLen));
    }

    @Override
    public long C_OpenSession(long slotID, long flags, NativePointer application, final CK_NOTIFY notify, LongRef phSession) {
        Pointer jna_application = new Pointer(application.getAddress());
        JNA_CK_NOTIFY jna_notify = new JNA_CK_NOTIFY(){

            @Override
            public NativeLong invoke(NativeLong hSession, NativeLong event, Pointer pApplication) {
                return JNA.NL(notify.invoke(hSession.longValue(), event.longValue(), new NativePointer(Pointer.nativeValue((Pointer)pApplication))));
            }
        };
        NativeLongByReference jna_phSession = JNA.NLP(phSession.value);
        long rv = this.instance.C_OpenSession(JNA.NL(slotID), JNA.NL(flags), jna_application, jna_notify, jna_phSession);
        application.setAddress(Pointer.nativeValue((Pointer)jna_application));
        phSession.value = jna_phSession.getValue().longValue();
        return rv;
    }

    @Override
    public long C_CloseSession(long hSession) {
        return this.instance.C_CloseSession(JNA.NL(hSession));
    }

    @Override
    public long C_CloseAllSessions(long slotID) {
        return this.instance.C_CloseAllSessions(JNA.NL(slotID));
    }

    @Override
    public long C_GetSessionInfo(long hSession, CK_SESSION_INFO pInfo) {
        JNA_CK_SESSION_INFO jna_pInfo = new JNA_CK_SESSION_INFO().readFrom(pInfo);
        long rv = this.instance.C_GetSessionInfo(JNA.NL(hSession), jna_pInfo);
        jna_pInfo.writeTo(pInfo);
        return rv;
    }

    @Override
    public long C_GetOperationState(long hSession, byte[] pOperationState, LongRef pulOperationStateLen) {
        NativeLongByReference jna_pulOperationStateLen = JNA.NLP(pulOperationStateLen.value);
        long rv = this.instance.C_GetOperationState(JNA.NL(hSession), pOperationState, jna_pulOperationStateLen);
        pulOperationStateLen.value = jna_pulOperationStateLen.getValue().longValue();
        return rv;
    }

    @Override
    public long C_SetOperationState(long hSession, byte[] pOperationState, long ulOperationStateLen, long hEncryptionKey, long hAuthenticationKey) {
        return this.instance.C_SetOperationState(JNA.NL(hSession), pOperationState, JNA.NL(ulOperationStateLen), JNA.NL(hEncryptionKey), JNA.NL(hAuthenticationKey));
    }

    @Override
    public long C_Login(long hSession, long userType, byte[] pPin, long ulPinLen) {
        return this.instance.C_Login(JNA.NL(hSession), JNA.NL(userType), pPin, JNA.NL(ulPinLen));
    }

    @Override
    public long C_Logout(long hSession) {
        return this.instance.C_Logout(JNA.NL(hSession));
    }

    @Override
    public long C_CreateObject(long hSession, CK_ATTRIBUTE[] pTemplate, long ulCount, LongRef phObject) {
        Template jna_pTemplate = new Template(pTemplate);
        NativeLongByReference jna_phObject = JNA.NLP(phObject.value);
        long rv = this.instance.C_CreateObject(JNA.NL(hSession), jna_pTemplate, JNA.NL(ulCount), jna_phObject);
        jna_pTemplate.update();
        phObject.value = jna_phObject.getValue().longValue();
        return rv;
    }

    @Override
    public long C_CopyObject(long hSession, long hObject, CK_ATTRIBUTE[] pTemplate, long ulCount, LongRef phNewObject) {
        Template jna_pTemplate = new Template(pTemplate);
        NativeLongByReference jna_phNewObject = JNA.NLP(phNewObject.value);
        long rv = this.instance.C_CopyObject(JNA.NL(hSession), JNA.NL(hObject), jna_pTemplate, JNA.NL(ulCount), jna_phNewObject);
        jna_pTemplate.update();
        phNewObject.value = jna_phNewObject.getValue().longValue();
        return rv;
    }

    @Override
    public long C_DestroyObject(long hSession, long hObject) {
        return this.instance.C_DestroyObject(JNA.NL(hSession), JNA.NL(hObject));
    }

    @Override
    public long C_GetObjectSize(long hSession, long hObject, LongRef pulSize) {
        NativeLongByReference jna_pulSize = JNA.NLP(pulSize.value);
        long rv = this.instance.C_GetObjectSize(JNA.NL(hSession), JNA.NL(hObject), jna_pulSize);
        pulSize.value = jna_pulSize.getValue().longValue();
        return rv;
    }

    @Override
    public long C_GetAttributeValue(long hSession, long hObject, CK_ATTRIBUTE[] pTemplate, long ulCount) {
        Template jna_pTemplate = new Template(pTemplate);
        long rv = this.instance.C_GetAttributeValue(JNA.NL(hSession), JNA.NL(hObject), jna_pTemplate, JNA.NL(ulCount));
        jna_pTemplate.update();
        return rv;
    }

    @Override
    public long C_SetAttributeValue(long hSession, long hObject, CK_ATTRIBUTE[] pTemplate, long ulCount) {
        Template jna_pTemplate = new Template(pTemplate);
        long rv = this.instance.C_SetAttributeValue(JNA.NL(hSession), JNA.NL(hObject), jna_pTemplate, JNA.NL(ulCount));
        jna_pTemplate.update();
        return rv;
    }

    @Override
    public long C_FindObjectsInit(long hSession, CK_ATTRIBUTE[] pTemplate, long ulCount) {
        Template jna_pTemplate = new Template(pTemplate);
        long rv = this.instance.C_FindObjectsInit(JNA.NL(hSession), jna_pTemplate, JNA.NL(ulCount));
        jna_pTemplate.update();
        return rv;
    }

    @Override
    public long C_FindObjects(long hSession, long[] phObject, long ulMaxObjectCount, LongRef pulObjectCount) {
        LongArray jna_phObject = new LongArray(phObject);
        NativeLongByReference jna_pulObjectCOunt = JNA.NLP(pulObjectCount.value);
        long rv = this.instance.C_FindObjects(JNA.NL(hSession), jna_phObject, JNA.NL(ulMaxObjectCount), jna_pulObjectCOunt);
        jna_phObject.update();
        pulObjectCount.value = jna_pulObjectCOunt.getValue().longValue();
        return rv;
    }

    @Override
    public long C_FindObjectsFinal(long hSession) {
        return this.instance.C_FindObjectsFinal(JNA.NL(hSession));
    }

    @Override
    public long C_EncryptInit(long hSession, CKM pMechanism, long hKey) {
        JNA_CKM jna_pMechanism = new JNA_CKM().readFrom(pMechanism);
        return this.instance.C_EncryptInit(JNA.NL(hSession), jna_pMechanism, JNA.NL(hKey));
    }

    @Override
    public long C_Encrypt(long hSession, byte[] pData, long ulDataLen, byte[] pEncryptedData, LongRef pulEncryptedDataLen) {
        NativeLongByReference jna_pulEncryptedDataLen = JNA.NLP(pulEncryptedDataLen.value);
        long rv = this.instance.C_Encrypt(JNA.NL(hSession), pData, JNA.NL(ulDataLen), pEncryptedData, jna_pulEncryptedDataLen);
        pulEncryptedDataLen.value = jna_pulEncryptedDataLen.getValue().longValue();
        return rv;
    }

    @Override
    public long C_EncryptUpdate(long hSession, byte[] pPart, long ulPartLen, byte[] pEncryptedPart, LongRef pulEncryptedPartLen) {
        NativeLongByReference jna_pulEncryptedPartLen = JNA.NLP(pulEncryptedPartLen.value);
        long rv = this.instance.C_EncryptUpdate(JNA.NL(hSession), pPart, JNA.NL(ulPartLen), pEncryptedPart, jna_pulEncryptedPartLen);
        pulEncryptedPartLen.value = jna_pulEncryptedPartLen.getValue().longValue();
        return rv;
    }

    @Override
    public long C_EncryptFinal(long hSession, byte[] pLastEncryptedPart, LongRef pulLastEncryptedPartLen) {
        NativeLongByReference jna_pulLastEncryptedPartLen = JNA.NLP(pulLastEncryptedPartLen.value);
        long rv = this.instance.C_EncryptFinal(JNA.NL(hSession), pLastEncryptedPart, jna_pulLastEncryptedPartLen);
        pulLastEncryptedPartLen.value = jna_pulLastEncryptedPartLen.getValue().longValue();
        return rv;
    }

    @Override
    public long C_DecryptInit(long hSession, CKM pMechanism, long hKey) {
        JNA_CKM jna_pMechanism = new JNA_CKM().readFrom(pMechanism);
        return this.instance.C_DecryptInit(JNA.NL(hSession), jna_pMechanism, JNA.NL(hKey));
    }

    @Override
    public long C_Decrypt(long hSession, byte[] pEncryptedData, long ulEncryptedDataLen, byte[] pData, LongRef pulDataLen) {
        NativeLongByReference jna_pulDataLen = JNA.NLP(pulDataLen.value);
        long rv = this.instance.C_Decrypt(JNA.NL(hSession), pEncryptedData, JNA.NL(ulEncryptedDataLen), pData, jna_pulDataLen);
        pulDataLen.value = jna_pulDataLen.getValue().longValue();
        return rv;
    }

    @Override
    public long C_DecryptUpdate(long hSession, byte[] pEncryptedPart, long ulEncryptedPartLen, byte[] pData, LongRef pulDataLen) {
        NativeLongByReference jna_pulDataLen = JNA.NLP(pulDataLen.value);
        long rv = this.instance.C_DecryptUpdate(JNA.NL(hSession), pEncryptedPart, JNA.NL(ulEncryptedPartLen), pData, jna_pulDataLen);
        pulDataLen.value = jna_pulDataLen.getValue().longValue();
        return rv;
    }

    @Override
    public long C_DecryptFinal(long hSession, byte[] pLastPart, LongRef pulLastPartLen) {
        NativeLongByReference jna_pulLastPartLen = JNA.NLP(pulLastPartLen.value);
        long rv = this.instance.C_DecryptFinal(JNA.NL(hSession), pLastPart, jna_pulLastPartLen);
        pulLastPartLen.value = jna_pulLastPartLen.getValue().longValue();
        return rv;
    }

    @Override
    public long C_DigestInit(long hSession, CKM pMechanism) {
        JNA_CKM jna_pMechanism = new JNA_CKM().readFrom(pMechanism);
        return this.instance.C_DigestInit(JNA.NL(hSession), jna_pMechanism);
    }

    @Override
    public long C_Digest(long hSession, byte[] pData, long ulDataLen, byte[] pDigest, LongRef pulDigestLen) {
        NativeLongByReference jna_pulDigestLen = JNA.NLP(pulDigestLen.value);
        long rv = this.instance.C_Digest(JNA.NL(hSession), pData, JNA.NL(ulDataLen), pDigest, jna_pulDigestLen);
        pulDigestLen.value = jna_pulDigestLen.getValue().longValue();
        return rv;
    }

    @Override
    public long C_DigestUpdate(long hSession, byte[] pPart, long ulPartLen) {
        return this.instance.C_DigestUpdate(JNA.NL(hSession), pPart, JNA.NL(ulPartLen));
    }

    @Override
    public long C_DigestKey(long hSession, long hKey) {
        return this.instance.C_DigestKey(JNA.NL(hSession), JNA.NL(hKey));
    }

    @Override
    public long C_DigestFinal(long hSession, byte[] pDigest, LongRef pulDigestLen) {
        NativeLongByReference jna_pulDigestLen = JNA.NLP(pulDigestLen.value);
        long rv = this.instance.C_DigestFinal(JNA.NL(hSession), pDigest, jna_pulDigestLen);
        pulDigestLen.value = jna_pulDigestLen.getValue().longValue();
        return rv;
    }

    @Override
    public long C_SignInit(long hSession, CKM pMechanism, long hKey) {
        JNA_CKM jna_pMechanism = new JNA_CKM().readFrom(pMechanism);
        return this.instance.C_SignInit(JNA.NL(hSession), jna_pMechanism, JNA.NL(hKey));
    }

    @Override
    public long C_Sign(long hSession, byte[] pData, long ulDataLen, byte[] pSignature, LongRef pulSignatureLen) {
        NativeLongByReference jna_pulSignatureLen = JNA.NLP(pulSignatureLen.value);
        long rv = this.instance.C_Sign(JNA.NL(hSession), pData, JNA.NL(ulDataLen), pSignature, jna_pulSignatureLen);
        pulSignatureLen.value = jna_pulSignatureLen.getValue().longValue();
        return rv;
    }

    @Override
    public long C_SignUpdate(long hSession, byte[] pPart, long ulPartLen) {
        return this.instance.C_SignUpdate(JNA.NL(hSession), pPart, JNA.NL(ulPartLen));
    }

    @Override
    public long C_SignFinal(long hSession, byte[] pSignature, LongRef pulSignatureLen) {
        NativeLongByReference jna_pulSignatureLen = JNA.NLP(pulSignatureLen.value);
        long rv = this.instance.C_SignFinal(JNA.NL(hSession), pSignature, jna_pulSignatureLen);
        pulSignatureLen.value = jna_pulSignatureLen.getValue().longValue();
        return rv;
    }

    @Override
    public long C_SignRecoverInit(long hSession, CKM pMechanism, long hKey) {
        JNA_CKM jna_pMechanism = new JNA_CKM().readFrom(pMechanism);
        return this.instance.C_SignRecoverInit(JNA.NL(hSession), jna_pMechanism, JNA.NL(hKey));
    }

    @Override
    public long C_SignRecover(long hSession, byte[] pData, long ulDataLen, byte[] pSignature, LongRef pulSignatureLen) {
        NativeLongByReference jna_pulSignatureLen = JNA.NLP(pulSignatureLen.value);
        long rv = this.instance.C_SignRecover(JNA.NL(hSession), pData, JNA.NL(ulDataLen), pSignature, jna_pulSignatureLen);
        pulSignatureLen.value = jna_pulSignatureLen.getValue().longValue();
        return rv;
    }

    @Override
    public long C_VerifyInit(long hSession, CKM pMechanism, long hKey) {
        JNA_CKM jna_pMechanism = new JNA_CKM().readFrom(pMechanism);
        return this.instance.C_VerifyInit(JNA.NL(hSession), jna_pMechanism, JNA.NL(hKey));
    }

    @Override
    public long C_Verify(long hSession, byte[] pData, long ulDataLen, byte[] pSignature, long ulSignatureLen) {
        return this.instance.C_Verify(JNA.NL(hSession), pData, JNA.NL(ulDataLen), pSignature, JNA.NL(ulSignatureLen));
    }

    @Override
    public long C_VerifyUpdate(long hSession, byte[] pPart, long ulPartLen) {
        return this.instance.C_VerifyUpdate(JNA.NL(hSession), pPart, JNA.NL(ulPartLen));
    }

    @Override
    public long C_VerifyFinal(long hSession, byte[] pSignature, long ulSignatureLen) {
        return this.instance.C_VerifyFinal(JNA.NL(hSession), pSignature, JNA.NL(ulSignatureLen));
    }

    @Override
    public long C_VerifyRecoverInit(long hSession, CKM pMechanism, long hKey) {
        JNA_CKM jna_pMechanism = new JNA_CKM().readFrom(pMechanism);
        return this.instance.C_VerifyRecoverInit(JNA.NL(hSession), jna_pMechanism, JNA.NL(hKey));
    }

    @Override
    public long C_VerifyRecover(long hSession, byte[] pSignature, long ulSignatureLen, byte[] pData, LongRef pulDataLen) {
        NativeLongByReference jna_pulDataLen = JNA.NLP(pulDataLen.value);
        long rv = this.instance.C_VerifyRecover(JNA.NL(hSession), pSignature, JNA.NL(ulSignatureLen), pData, jna_pulDataLen);
        pulDataLen.value = jna_pulDataLen.getValue().longValue();
        return rv;
    }

    @Override
    public long C_DigestEncryptUpdate(long hSession, byte[] pPart, long ulPartLen, byte[] pEncryptedPart, LongRef pulEncryptedPartLen) {
        NativeLongByReference jna_pulEncryptedPartLen = JNA.NLP(pulEncryptedPartLen.value);
        long rv = this.instance.C_DigestEncryptUpdate(JNA.NL(hSession), pPart, JNA.NL(ulPartLen), pEncryptedPart, jna_pulEncryptedPartLen);
        pulEncryptedPartLen.value = jna_pulEncryptedPartLen.getValue().longValue();
        return rv;
    }

    @Override
    public long C_DecryptDigestUpdate(long hSession, byte[] pEncryptedPart, long ulEncryptedPartLen, byte[] pPart, LongRef pulPartLen) {
        NativeLongByReference jna_pulPartLen = JNA.NLP(pulPartLen.value);
        long rv = this.instance.C_DecryptDigestUpdate(JNA.NL(hSession), pEncryptedPart, JNA.NL(ulEncryptedPartLen), pPart, jna_pulPartLen);
        pulPartLen.value = jna_pulPartLen.getValue().longValue();
        return rv;
    }

    @Override
    public long C_SignEncryptUpdate(long hSession, byte[] pPart, long ulPartLen, byte[] pEncryptedPart, LongRef pulEncryptedPartLen) {
        NativeLongByReference jna_pulEncryptPartLen = JNA.NLP(pulEncryptedPartLen.value);
        long rv = this.instance.C_SignEncryptUpdate(JNA.NL(hSession), pPart, JNA.NL(ulPartLen), pEncryptedPart, jna_pulEncryptPartLen);
        pulEncryptedPartLen.value = jna_pulEncryptPartLen.getValue().longValue();
        return rv;
    }

    @Override
    public long C_DecryptVerifyUpdate(long hSession, byte[] pEncryptedPart, long ulEncryptedPartLen, byte[] pPart, LongRef pulPartLen) {
        NativeLongByReference jna_pulPartLen = JNA.NLP(pulPartLen.value);
        long rv = this.instance.C_DecryptVerifyUpdate(JNA.NL(hSession), pEncryptedPart, JNA.NL(ulEncryptedPartLen), pPart, jna_pulPartLen);
        pulPartLen.value = jna_pulPartLen.getValue().longValue();
        return rv;
    }

    @Override
    public long C_GenerateKey(long hSession, CKM pMechanism, CK_ATTRIBUTE[] pTemplate, long ulCount, LongRef phKey) {
        JNA_CKM jna_pMechanism = new JNA_CKM().readFrom(pMechanism);
        Template jna_pTemplate = new Template(pTemplate);
        NativeLongByReference jna_phKey = JNA.NLP(phKey.value);
        long rv = this.instance.C_GenerateKey(JNA.NL(hSession), jna_pMechanism, jna_pTemplate, JNA.NL(ulCount), jna_phKey);
        phKey.value = jna_phKey.getValue().longValue();
        return rv;
    }

    @Override
    public long C_GenerateKeyPair(long hSession, CKM pMechanism, CK_ATTRIBUTE[] pPublicKeyTemplate, long ulPublicKeyAttributeCount, CK_ATTRIBUTE[] pPrivateKeyTemplate, long ulPrivateKeyAttributeCount, LongRef phPublicKey, LongRef phPrivateKey) {
        JNA_CKM jna_pMechanism = new JNA_CKM().readFrom(pMechanism);
        Template jna_pPublicKeyTemplate = new Template(pPublicKeyTemplate);
        Template jna_pPrivateKeyTemplate = new Template(pPrivateKeyTemplate);
        NativeLongByReference jna_phPublicKey = JNA.NLP(phPublicKey.value);
        NativeLongByReference jna_phPrivateKey = JNA.NLP(phPrivateKey.value);
        long rv = this.instance.C_GenerateKeyPair(JNA.NL(hSession), jna_pMechanism, jna_pPublicKeyTemplate, JNA.NL(ulPublicKeyAttributeCount), jna_pPrivateKeyTemplate, JNA.NL(ulPrivateKeyAttributeCount), jna_phPublicKey, jna_phPrivateKey);
        phPublicKey.value = jna_phPublicKey.getValue().longValue();
        phPrivateKey.value = jna_phPrivateKey.getValue().longValue();
        return rv;
    }

    @Override
    public long C_WrapKey(long hSession, CKM pMechanism, long hWrappingKey, long hKey, byte[] pWrappedKey, LongRef pulWrappedKeyLen) {
        JNA_CKM jna_pMechanism = new JNA_CKM().readFrom(pMechanism);
        NativeLongByReference jna_pulWrappedKeyLen = JNA.NLP(pulWrappedKeyLen.value);
        long rv = this.instance.C_WrapKey(JNA.NL(hSession), jna_pMechanism, JNA.NL(hWrappingKey), JNA.NL(hKey), pWrappedKey, jna_pulWrappedKeyLen);
        pulWrappedKeyLen.value = jna_pulWrappedKeyLen.getValue().longValue();
        return rv;
    }

    @Override
    public long C_UnwrapKey(long hSession, CKM pMechanism, long hUnwrappingKey, byte[] pWrappedKey, long ulWrappedKeyLen, CK_ATTRIBUTE[] pTemplate, long ulAttributeCount, LongRef phKey) {
        JNA_CKM jna_pMechanism = new JNA_CKM().readFrom(pMechanism);
        Template jna_pTemplate = new Template(pTemplate);
        NativeLongByReference jna_phKey = JNA.NLP(phKey.value);
        long rv = this.instance.C_UnwrapKey(JNA.NL(hSession), jna_pMechanism, JNA.NL(hUnwrappingKey), pWrappedKey, JNA.NL(ulWrappedKeyLen), jna_pTemplate, JNA.NL(ulAttributeCount), jna_phKey);
        phKey.value = jna_phKey.getValue().longValue();
        return rv;
    }

    @Override
    public long C_DeriveKey(long hSession, CKM pMechanism, long hBaseKey, CK_ATTRIBUTE[] pTemplate, long ulAttributeCount, LongRef phKey) {
        JNA_CKM jna_pMechanism = new JNA_CKM().readFrom(pMechanism);
        Template jna_pTemplate = new Template(pTemplate);
        NativeLongByReference jna_phKey = JNA.NLP(phKey.value);
        long rv = this.instance.C_DeriveKey(JNA.NL(hSession), jna_pMechanism, JNA.NL(hBaseKey), jna_pTemplate, JNA.NL(ulAttributeCount), jna_phKey);
        phKey.value = jna_phKey.getValue().longValue();
        return rv;
    }

    @Override
    public long C_SeedRandom(long hSession, byte[] pSeed, long ulSeedLen) {
        return this.instance.C_SeedRandom(JNA.NL(hSession), pSeed, JNA.NL(ulSeedLen));
    }

    @Override
    public long C_GenerateRandom(long hSession, byte[] pRandomData, long ulRandomLen) {
        return this.instance.C_GenerateRandom(JNA.NL(hSession), pRandomData, JNA.NL(ulRandomLen));
    }

    @Override
    public long C_GetFunctionStatus(long hSession) {
        return this.instance.C_GetFunctionStatus(JNA.NL(hSession));
    }

    @Override
    public long C_CancelFunction(long hSession) {
        return this.instance.C_CancelFunction(JNA.NL(hSession));
    }

    private static NativeLong NL(long l) {
        return new NativeLong(l);
    }

    private static NativeLongByReference NLP(long l) {
        return new NativeLongByReference(new NativeLong(l));
    }
}

