/*
 * Decompiled with CFR 0.152.
 */
package com.anf.pkcs11.jna;

import com.anf.pkcs11.jna.Buf;
import com.anf.pkcs11.jna.CK_VERSION;
import com.anf.pkcs11.jna.PKCS11Impl;
import java.util.Map;

public class CK_TOKEN_INFO {
    public static final long CKF_RNG = 1L;
    public static final long CKF_WRITE_PROTECTED = 2L;
    public static final long CKF_LOGIN_REQUIRED = 4L;
    public static final long CKF_USER_PIN_INITIALIZED = 8L;
    public static final long CKF_RESTORE_KEY_NOT_NEEDED = 32L;
    public static final long CKF_CLOCK_ON_TOKEN = 64L;
    public static final long CKF_PROTECTED_AUTHENTICATION_PATH = 256L;
    public static final long CKF_DUAL_CRYPTO_OPERATIONS = 512L;
    public static final long CKF_TOKEN_INITIALIZED = 1024L;
    public static final long CKF_SECONDARY_AUTHENTICATION = 2048L;
    public static final long CKF_USER_PIN_COUNT_LOW = 65536L;
    public static final long CKF_USER_PIN_FINAL_TRY = 131072L;
    public static final long CKF_USER_PIN_LOCKED = 262144L;
    public static final long CKF_USER_PIN_TO_BE_CHANGED = 524288L;
    public static final long CKF_SO_PIN_COUNT_LOW = 0x100000L;
    public static final long CKF_SO_PIN_FINAL_TRY = 0x200000L;
    public static final long CKF_SO_PIN_LOCKED = 0x400000L;
    public static final long CKF_SO_PIN_TO_BE_CHANGED = 0x800000L;
    private static final Map<Long, String> L2S = PKCS11Impl.createL2SMap(CK_TOKEN_INFO.class);
    private byte[] label = new byte[32];
    private byte[] manufacturerID = new byte[32];
    private byte[] model = new byte[16];
    private byte[] serialNumber = new byte[16];
    private long flags;
    private long ulMaxSessionCount;
    private long ulSessionCount;
    private long ulMaxRwSessionCount;
    private long ulRwSessionCount;
    private long ulMaxPinLen;
    private long ulMinPinLen;
    private long ulTotalPublicMemory;
    private long ulFreePublicMemory;
    private long ulTotalPrivateMemory;
    private long ulFreePrivateMemory;
    private CK_VERSION hardwareVersion = new CK_VERSION();
    private CK_VERSION firmwareVersion = new CK_VERSION();
    private byte[] utcTime = new byte[16];

    public static final String L2S(long ckf) {
        return PKCS11Impl.l2s(L2S, "CKF", ckf);
    }

    public static String f2s(long flags) {
        return PKCS11Impl.f2s(L2S, flags);
    }

    public String toString() {
        return String.format("(\n  label=%s\n  manufacturerID=%s\n  model=%s\n  serialNumber=%s\n  flags=0x%08x{%s}\n  maxSessionCount=%d\n  sessionCount=%d\n  maxRwSessionCount=%d\n  rwSessionCount=%d\n  maxPinLen=%d\n  minPinLen=%d\n  totalPublicMemory=%d\n  freePublicMemory=%d\n  totalPrivateMemory=%d\n  freePrivateMemory=%d\n  hardwareVersion=%d.%d\n  firmwareVersion=%d.%d\n  utcTime=%s\n)", Buf.escstr(this.label), Buf.escstr(this.manufacturerID), Buf.escstr(this.model), Buf.escstr(this.serialNumber), this.flags, CK_TOKEN_INFO.f2s(this.flags), this.ulMaxSessionCount, this.ulSessionCount, this.ulMaxRwSessionCount, this.ulRwSessionCount, this.ulMaxPinLen, this.ulMinPinLen, this.ulTotalPublicMemory, this.ulFreePublicMemory, this.ulTotalPrivateMemory, this.ulFreePrivateMemory, this.hardwareVersion.major & 0xFF, this.hardwareVersion.minor & 0xFF, this.firmwareVersion.major & 0xFF, this.firmwareVersion.minor & 0xFF, Buf.escstr(this.utcTime));
    }

    public CK_TOKEN_INFO() {
    }

    public CK_TOKEN_INFO(CK_TOKEN_INFO tokenInfo) {
        this.label = tokenInfo.getLabel();
        this.manufacturerID = tokenInfo.getManufacturerID();
        this.model = tokenInfo.getModel();
        this.serialNumber = tokenInfo.getSerialNumber();
        this.flags = tokenInfo.getFlags();
        this.ulMaxSessionCount = tokenInfo.getUlMaxSessionCount();
        this.ulSessionCount = tokenInfo.getUlSessionCount();
        this.ulMaxRwSessionCount = tokenInfo.getUlMaxRwSessionCount();
        this.ulRwSessionCount = tokenInfo.getUlRwSessionCount();
        this.ulMaxPinLen = tokenInfo.getUlMaxPinLen();
        this.ulMinPinLen = tokenInfo.getUlMinPinLen();
        this.ulTotalPublicMemory = tokenInfo.getUlTotalPublicMemory();
        this.ulFreePublicMemory = tokenInfo.getUlFreePublicMemory();
        this.ulTotalPrivateMemory = tokenInfo.getUlTotalPrivateMemory();
        this.ulFreePrivateMemory = tokenInfo.getUlFreePrivateMemory();
        this.hardwareVersion = tokenInfo.getHardwareVersion();
        this.firmwareVersion = tokenInfo.getFirmwareVersion();
        this.utcTime = tokenInfo.getUtcTime();
    }

    public byte[] getLabel() {
        return this.label;
    }

    public void setLabel(byte[] label) {
        this.label = label;
    }

    public byte[] getManufacturerID() {
        return this.manufacturerID;
    }

    public void setManufacturerID(byte[] manufacturerID) {
        this.manufacturerID = manufacturerID;
    }

    public byte[] getModel() {
        return this.model;
    }

    public void setModel(byte[] model) {
        this.model = model;
    }

    public byte[] getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(byte[] serialNumber) {
        this.serialNumber = serialNumber;
    }

    public long getFlags() {
        return this.flags;
    }

    public void setFlags(long flags) {
        this.flags = flags;
    }

    public long getUlMaxSessionCount() {
        return this.ulMaxSessionCount;
    }

    public void setUlMaxSessionCount(long ulMaxSessionCount) {
        this.ulMaxSessionCount = ulMaxSessionCount;
    }

    public long getUlSessionCount() {
        return this.ulSessionCount;
    }

    public void setUlSessionCount(long ulSessionCount) {
        this.ulSessionCount = ulSessionCount;
    }

    public long getUlMaxRwSessionCount() {
        return this.ulMaxRwSessionCount;
    }

    public void setUlMaxRwSessionCount(long ulMaxRwSessionCount) {
        this.ulMaxRwSessionCount = ulMaxRwSessionCount;
    }

    public long getUlRwSessionCount() {
        return this.ulRwSessionCount;
    }

    public void setUlRwSessionCount(long ulRwSessionCount) {
        this.ulRwSessionCount = ulRwSessionCount;
    }

    public long getUlMaxPinLen() {
        return this.ulMaxPinLen;
    }

    public void setUlMaxPinLen(long ulMaxPinLen) {
        this.ulMaxPinLen = ulMaxPinLen;
    }

    public long getUlMinPinLen() {
        return this.ulMinPinLen;
    }

    public void setUlMinPinLen(long ulMinPinLen) {
        this.ulMinPinLen = ulMinPinLen;
    }

    public long getUlTotalPublicMemory() {
        return this.ulTotalPublicMemory;
    }

    public void setUlTotalPublicMemory(long ulTotalPublicMemory) {
        this.ulTotalPublicMemory = ulTotalPublicMemory;
    }

    public long getUlFreePublicMemory() {
        return this.ulFreePublicMemory;
    }

    public void setUlFreePublicMemory(long ulFreePublicMemory) {
        this.ulFreePublicMemory = ulFreePublicMemory;
    }

    public long getUlTotalPrivateMemory() {
        return this.ulTotalPrivateMemory;
    }

    public void setUlTotalPrivateMemory(long ulTotalPrivateMemory) {
        this.ulTotalPrivateMemory = ulTotalPrivateMemory;
    }

    public long getUlFreePrivateMemory() {
        return this.ulFreePrivateMemory;
    }

    public void setUlFreePrivateMemory(long ulFreePrivateMemory) {
        this.ulFreePrivateMemory = ulFreePrivateMemory;
    }

    public CK_VERSION getHardwareVersion() {
        return this.hardwareVersion;
    }

    public void setHardwareVersion(CK_VERSION hardwareVersion) {
        this.hardwareVersion = hardwareVersion;
    }

    public CK_VERSION getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public void setFirmwareVersion(CK_VERSION firmwareVersion) {
        this.firmwareVersion = firmwareVersion;
    }

    public byte[] getUtcTime() {
        return this.utcTime;
    }

    public void setUtcTime(byte[] utcTime) {
        this.utcTime = utcTime;
    }
}

