/*
 * Decompiled with CFR 0.152.
 */
package com.anf.pkcs11.jna;

import com.anf.pkcs11.jna.Hex;

public class Buf {
    public static final int[] LKP_ESCAPES;

    public static byte[] cat(byte[] ... bufs) {
        if (bufs == null) {
            return null;
        }
        int l = 0;
        for (int i = 0; i < bufs.length; ++i) {
            l += bufs[i] == null ? 0 : bufs[i].length;
        }
        byte[] result = new byte[l];
        Buf.cat(result, 0, bufs);
        return result;
    }

    public static void cat(byte[] dest, int start, byte[] ... bufs) {
        if (bufs == null) {
            return;
        }
        for (int i = 0; i < bufs.length; ++i) {
            if (bufs[i] == null) continue;
            System.arraycopy(bufs[i], 0, dest, start, bufs[i].length);
            start += bufs[i].length;
        }
    }

    public static byte[] substring(byte[] src, int start, int len) {
        if (len < 0) {
            throw new IllegalArgumentException("len cannot be negative, got: " + len);
        }
        if (src == null) {
            src = new byte[]{};
        }
        if (src != null && start == 0 && len == src.length) {
            return src;
        }
        if (len == src.length && (start == 0 || start == -src.length)) {
            return src;
        }
        byte[] result = new byte[len];
        if (start >= 0 && start < src.length) {
            int tocopy = Math.min(len, src.length - start);
            System.arraycopy(src, start, result, 0, tocopy);
        } else if (start < 0 && start + src.length + len > 0) {
            int tocopy = (start += src.length) < 0 ? Math.min(len + start, src.length) : Math.min(len, src.length - start);
            System.arraycopy(src, Math.max(0, start), result, len - tocopy, tocopy);
        }
        return result;
    }

    public static String escstr(byte[] buf) {
        if (buf == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(buf.length + 2);
        sb.append('\"');
        for (int i = 0; i < buf.length; ++i) {
            int c = buf[i] & 0xFF;
            int escape = LKP_ESCAPES[c];
            if (escape == 0) {
                sb.append((char)c);
                continue;
            }
            if (escape != -1) {
                sb.append('\\').append((char)escape);
                continue;
            }
            sb.append("\\u00").append(Hex.HEX_B2S[buf[i] & 0xFF]);
        }
        sb.append('\"');
        return sb.toString();
    }

    public static byte[] c2b(char[] c) {
        if (c == null) {
            return null;
        }
        byte[] result = new byte[c.length];
        for (int i = 0; i < c.length; ++i) {
            result[i] = (byte)c[i];
        }
        return result;
    }

    public static byte[] c2b(String s) {
        if (s == null) {
            return null;
        }
        return Buf.c2b(s.toCharArray());
    }

    static {
        int i;
        LKP_ESCAPES = new int[256];
        for (i = 0; i < 32; ++i) {
            Buf.LKP_ESCAPES[i] = -1;
        }
        for (i = 127; i < 256; ++i) {
            Buf.LKP_ESCAPES[i] = -1;
        }
        Buf.LKP_ESCAPES[8] = 98;
        Buf.LKP_ESCAPES[9] = 116;
        Buf.LKP_ESCAPES[10] = 110;
        Buf.LKP_ESCAPES[13] = 114;
        Buf.LKP_ESCAPES[12] = 102;
        Buf.LKP_ESCAPES[34] = 34;
        Buf.LKP_ESCAPES[39] = 39;
        Buf.LKP_ESCAPES[92] = 92;
    }
}

