/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.validation;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.DigestDocument;
import eu.europa.esig.dss.utils.Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;

public class PrecomputedDigestCalculatorProvider
implements DigestCalculatorProvider {
    private final DigestDocument digestDocument;

    public PrecomputedDigestCalculatorProvider(DigestDocument digestDocument) {
        this.digestDocument = digestDocument;
    }

    public DigestCalculator get(final AlgorithmIdentifier digestAlgorithmIdentifier) throws OperatorCreationException {
        ASN1ObjectIdentifier algorithmOid = digestAlgorithmIdentifier.getAlgorithm();
        final byte[] digestBase64 = this.digestDocument.getDigestValue(DigestAlgorithm.forOID((String)algorithmOid.getId()));
        return new DigestCalculator(){
            final /* synthetic */ PrecomputedDigestCalculatorProvider this$0;
            {
                this.this$0 = this$0;
            }

            public OutputStream getOutputStream() {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                try {
                    Utils.write((byte[])this.getDigest(), (OutputStream)os);
                }
                catch (IOException e) {
                    throw new DSSException("Unable to get outputstream", (Throwable)e);
                }
                return os;
            }

            public byte[] getDigest() {
                return digestBase64;
            }

            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return digestAlgorithmIdentifier;
            }
        };
    }
}

