/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.signature;

import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.cades.CMSUtils;
import eu.europa.esig.dss.cades.signature.CAdESLevelBaselineB;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SignerInfoGeneratorBuilder;
import org.bouncycastle.cms.SimpleAttributeTableGenerator;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;

public class CMSSignerInfoGeneratorBuilder {
    private boolean includeUnsignedAttributes;

    public CMSSignerInfoGeneratorBuilder setIncludeUnsignedAttributes(boolean includeUnsignedAttributes) {
        this.includeUnsignedAttributes = includeUnsignedAttributes;
        return this;
    }

    public SignerInfoGenerator build(CAdESSignatureParameters parameters, ContentSigner contentSigner) {
        return this.build(null, parameters, contentSigner);
    }

    public SignerInfoGenerator build(DSSDocument toSignDocument, CAdESSignatureParameters parameters, ContentSigner contentSigner) {
        SignerInfoGeneratorBuilder signerInfoGeneratorBuilder = this.getSignerInfoGeneratorBuilder(parameters, toSignDocument);
        return this.getSignerInfoGenerator(signerInfoGeneratorBuilder, contentSigner, parameters);
    }

    protected SignerInfoGeneratorBuilder getSignerInfoGeneratorBuilder(CAdESSignatureParameters parameters, DSSDocument contentToSign) {
        DigestCalculatorProvider dcp = CMSUtils.getDigestCalculatorProvider(contentToSign, parameters.getReferenceDigestAlgorithm());
        CAdESLevelBaselineB cadesProfile = new CAdESLevelBaselineB(contentToSign);
        AttributeTable signedAttributes = cadesProfile.getSignedAttributes(parameters);
        AttributeTable unsignedAttributes = null;
        if (this.includeUnsignedAttributes) {
            unsignedAttributes = cadesProfile.getUnsignedAttributes();
        }
        return this.getSignerInfoGeneratorBuilder(dcp, signedAttributes, unsignedAttributes);
    }

    protected SignerInfoGeneratorBuilder getSignerInfoGeneratorBuilder(DigestCalculatorProvider digestCalculatorProvider, AttributeTable signedAttributes, AttributeTable unsignedAttributes) {
        if (CMSUtils.isEmpty(signedAttributes)) {
            signedAttributes = null;
        }
        DefaultSignedAttributeTableGenerator signedAttributeGenerator = new DefaultSignedAttributeTableGenerator(signedAttributes);
        if (CMSUtils.isEmpty(unsignedAttributes)) {
            unsignedAttributes = null;
        }
        SimpleAttributeTableGenerator unsignedAttributeGenerator = new SimpleAttributeTableGenerator(unsignedAttributes);
        SignerInfoGeneratorBuilder sigInfoGeneratorBuilder = new SignerInfoGeneratorBuilder(digestCalculatorProvider);
        sigInfoGeneratorBuilder.setSignedAttributeGenerator((CMSAttributeTableGenerator)signedAttributeGenerator);
        sigInfoGeneratorBuilder.setUnsignedAttributeGenerator((CMSAttributeTableGenerator)unsignedAttributeGenerator);
        return sigInfoGeneratorBuilder;
    }

    private SignerInfoGenerator getSignerInfoGenerator(SignerInfoGeneratorBuilder signerInfoGeneratorBuilder, ContentSigner contentSigner, CAdESSignatureParameters parameters) {
        try {
            if (parameters.getSigningCertificate() == null) {
                if (parameters.isGenerateTBSWithoutCertificate()) {
                    SignerId signerId = new SignerId(DSSUtils.EMPTY_BYTE_ARRAY);
                    return signerInfoGeneratorBuilder.build(contentSigner, signerId.getSubjectKeyIdentifier());
                }
                throw new IllegalArgumentException("Signing-certificate is not provided! Use #setGenerateWithoutCertificates(true) method.");
            }
            X509CertificateHolder certHolder = DSSASN1Utils.getX509CertificateHolder((CertificateToken)parameters.getSigningCertificate());
            return signerInfoGeneratorBuilder.build(contentSigner, certHolder);
        }
        catch (OperatorCreationException e) {
            throw new DSSException(String.format("Unable to create a SignerInfoGenerator. Reason : %s", e.getMessage()), (Throwable)e);
        }
    }
}

