/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.signature;

import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.cades.CMSUtils;
import eu.europa.esig.dss.cades.signature.CAdESCounterSignatureParameters;
import eu.europa.esig.dss.cades.signature.CMSSignedDocument;
import eu.europa.esig.dss.cades.signature.CMSSignerInfoGeneratorBuilder;
import eu.europa.esig.dss.cades.signature.CustomContentSigner;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.cades.validation.CMSDocumentAnalyzer;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.model.ManifestFile;
import eu.europa.esig.dss.model.SignatureValue;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.x509.BaselineBCertificateSelector;
import eu.europa.esig.dss.spi.x509.CMSSignedDataBuilder;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.utils.Utils;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAdESCounterSignatureBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(CAdESCounterSignatureBuilder.class);
    private final CertificateVerifier certificateVerifier;
    private ManifestFile manifestFile;

    public CAdESCounterSignatureBuilder(CertificateVerifier certificateVerifier) {
        this.certificateVerifier = certificateVerifier;
    }

    public void setManifestFile(ManifestFile manifestFile) {
        this.manifestFile = manifestFile;
    }

    public CMSSignedDocument addCounterSignature(CMSSignedData originalCMSSignedData, CAdESCounterSignatureParameters parameters, SignatureValue signatureValue) {
        List<SignerInformation> updatedSignerInfo = this.getUpdatedSignerInformations(originalCMSSignedData, originalCMSSignedData.getSignerInfos(), parameters, signatureValue, null);
        CMSSignedData updatedCMSSignedData = CMSSignedData.replaceSigners((CMSSignedData)originalCMSSignedData, (SignerInformationStore)new SignerInformationStore(updatedSignerInfo));
        updatedCMSSignedData = CMSUtils.populateDigestAlgorithmSet(updatedCMSSignedData, originalCMSSignedData);
        updatedCMSSignedData = this.addNewCertificates(updatedCMSSignedData, parameters);
        return new CMSSignedDocument(updatedCMSSignedData);
    }

    private List<SignerInformation> getUpdatedSignerInformations(CMSSignedData originalCMSSignedData, SignerInformationStore signerInformationStore, CAdESCounterSignatureParameters parameters, SignatureValue signatureValue, CAdESSignature masterSignature) {
        LinkedList<SignerInformation> result = new LinkedList<SignerInformation>();
        for (SignerInformation signerInformation : signerInformationStore) {
            CAdESSignature cades = new CAdESSignature(originalCMSSignedData, signerInformation);
            cades.setMasterSignature((AdvancedSignature)masterSignature);
            cades.setDetachedContents(parameters.getDetachedContents());
            cades.setManifestFile(this.manifestFile);
            if (Utils.areStringsEqual((String)cades.getId(), (String)parameters.getSignatureIdToCounterSign())) {
                if (masterSignature != null) {
                    throw new UnsupportedOperationException("Cannot recursively add a counter-signature");
                }
                this.assertCounterSignaturePossible(signerInformation);
                SignerInformationStore counterSignatureSignerInfoStore = this.generateCounterSignature(signerInformation, parameters, signatureValue);
                result.add(SignerInformation.addCounterSigners((SignerInformation)signerInformation, (SignerInformationStore)counterSignatureSignerInfoStore));
                continue;
            }
            if (signerInformation.getCounterSignatures().size() > 0) {
                List<SignerInformation> updatedCounterSigners = this.getUpdatedSignerInformations(originalCMSSignedData, signerInformation.getCounterSignatures(), parameters, signatureValue, cades);
                result.add(this.replaceCounterSigners(signerInformation, updatedCounterSigners));
                continue;
            }
            result.add(signerInformation);
        }
        return result;
    }

    private SignerInformation replaceCounterSigners(SignerInformation signerInformation, List<SignerInformation> updatedCounterSigners) {
        ASN1EncodableVector attrs = new ASN1EncodableVector();
        Attribute counterSignatureAttribute = this.getUpdatedCounterSignatureAttribute(updatedCounterSigners);
        AttributeTable currentUnsignedAttributes = signerInformation.getUnsignedAttributes();
        ASN1EncodableVector currentASN1EncodableVector = currentUnsignedAttributes.toASN1EncodableVector();
        for (int i = 0; i < currentASN1EncodableVector.size(); ++i) {
            ASN1Encodable asn1Encodable = currentASN1EncodableVector.get(i);
            if (this.isCounterSignatureAttribute(asn1Encodable)) {
                attrs.add((ASN1Encodable)counterSignatureAttribute);
                continue;
            }
            attrs.add(asn1Encodable);
        }
        return SignerInformation.replaceUnsignedAttributes((SignerInformation)signerInformation, (AttributeTable)new AttributeTable(attrs));
    }

    private boolean isCounterSignatureAttribute(ASN1Encodable asn1Encodable) {
        try {
            Attribute attribute = Attribute.getInstance((Object)asn1Encodable);
            return CMSAttributes.counterSignature.equals((ASN1Primitive)attribute.getAttrType());
        }
        catch (Exception e) {
            String errorMessage = "Unable to instantiate Attribute. Reason : {}";
            if (LOG.isDebugEnabled()) {
                LOG.warn(errorMessage, (Object)e.getMessage(), (Object)e);
            } else {
                LOG.warn(errorMessage, (Object)e.getMessage());
            }
            return false;
        }
    }

    private Attribute getUpdatedCounterSignatureAttribute(List<SignerInformation> updatedCounterSigners) {
        ASN1EncodableVector signers = new ASN1EncodableVector();
        for (SignerInformation counterSigner : updatedCounterSigners) {
            signers.add((ASN1Encodable)counterSigner.toASN1Structure());
        }
        return new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signers));
    }

    private CMSSignedData addNewCertificates(CMSSignedData updatedCMSSignedData, CAdESCounterSignatureParameters parameters) {
        List newCertificates = new BaselineBCertificateSelector(parameters.getSigningCertificate(), (Collection)parameters.getCertificateChain()).setTrustedCertificateSource((CertificateSource)this.certificateVerifier.getTrustedCertSources()).setTrustAnchorBPPolicy(parameters.bLevel().isTrustAnchorBPPolicy()).getCertificates();
        CMSSignedDataBuilder cmsSignedDataBuilder = new CMSSignedDataBuilder().setOriginalCMSSignedData(updatedCMSSignedData);
        return cmsSignedDataBuilder.extendCMSSignedData((Collection)newCertificates, Collections.emptyList(), Collections.emptyList());
    }

    private SignerInformationStore generateCounterSignature(SignerInformation signerInformation, CAdESCounterSignatureParameters parameters, SignatureValue signatureValue) {
        SignatureAlgorithm signatureAlgorithm = parameters.getSignatureAlgorithm();
        CustomContentSigner customContentSigner = new CustomContentSigner(signatureAlgorithm.getJCEId(), signatureValue.getValue());
        return this.generateCounterSignature(signerInformation, (CAdESSignatureParameters)parameters, customContentSigner);
    }

    public SignerInformationStore generateCounterSignature(SignerInformation signerInformation, CAdESSignatureParameters parameters, CustomContentSigner customContentSigner) {
        InMemoryDocument toSignDocument = new InMemoryDocument(signerInformation.getSignature());
        SignerInfoGenerator signerInfoGenerator = new CMSSignerInfoGeneratorBuilder().build((DSSDocument)toSignDocument, parameters, customContentSigner);
        CMSSignedDataGenerator cmsSignedDataGenerator = this.getCMSSignedDataBuilder(parameters).createCMSSignedDataGenerator(signerInfoGenerator);
        return CMSUtils.generateCounterSigners(cmsSignedDataGenerator, signerInformation);
    }

    private CMSSignedDataBuilder getCMSSignedDataBuilder(CAdESSignatureParameters parameters) {
        return new CMSSignedDataBuilder().setSigningCertificate(parameters.getSigningCertificate()).setCertificateChain((Collection)parameters.getCertificateChain()).setGenerateWithoutCertificates(parameters.isGenerateTBSWithoutCertificate()).setTrustAnchorBPPolicy(parameters.bLevel().isTrustAnchorBPPolicy()).setTrustedCertificateSource((CertificateSource)this.certificateVerifier.getTrustedCertSources()).setEncapsulate(false);
    }

    public SignerInformation getSignerInformationToBeCounterSigned(DSSDocument signatureDocument, CAdESCounterSignatureParameters parameters) {
        CAdESSignature cadesSignature = this.getSignatureById(signatureDocument, parameters);
        if (cadesSignature == null) {
            throw new IllegalArgumentException(String.format("CAdESSignature not found with the given dss id '%s'", parameters.getSignatureIdToCounterSign()));
        }
        return cadesSignature.getSignerInformation();
    }

    private CAdESSignature getSignatureById(DSSDocument signatureDocument, CAdESCounterSignatureParameters parameters) {
        Objects.requireNonNull(parameters.getSignatureIdToCounterSign(), "The Id of a signature to be counter signed shall be defined! Please use SerializableCounterSignatureParameters.setSignatureIdToCounterSign(signatureId) method.");
        CMSDocumentAnalyzer validator = new CMSDocumentAnalyzer(signatureDocument);
        validator.setDetachedContents(parameters.getDetachedContents());
        validator.setManifestFile(this.manifestFile);
        List signatures = validator.getSignatures();
        return this.findSignatureRecursive(signatures, parameters.getSignatureIdToCounterSign());
    }

    private CAdESSignature findSignatureRecursive(List<AdvancedSignature> signatures, String signatureId) {
        if (Utils.isCollectionNotEmpty(signatures)) {
            for (AdvancedSignature advancedSignature : signatures) {
                if (signatureId.equals(advancedSignature.getId())) {
                    CAdESSignature cades = (CAdESSignature)advancedSignature;
                    this.assertCounterSignaturePossible(cades.getSignerInformation());
                    return cades;
                }
                CAdESSignature counterSignatureById = this.findSignatureRecursive(advancedSignature.getCounterSignatures(), signatureId);
                if (counterSignatureById == null) continue;
                throw new UnsupportedOperationException("Nested counter signatures are not supported with CAdES!");
            }
        }
        return null;
    }

    private void assertCounterSignaturePossible(SignerInformation signerInformation) {
        if (CMSUtils.containsATSTv2(signerInformation)) {
            throw new IllegalInputException("Cannot add a counter signature to a CAdES containing an archiveTimestampV2");
        }
    }
}

