/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.reports;

import eu.europa.esig.dss.detailedreport.jaxb.XmlDetailedReport;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDiagnosticData;
import eu.europa.esig.dss.simplereport.SimpleReport;
import eu.europa.esig.dss.simplereport.SimpleReportFacade;
import eu.europa.esig.dss.simplereport.jaxb.XmlSimpleReport;
import eu.europa.esig.dss.validation.reports.AbstractReports;
import eu.europa.esig.dss.validation.reports.DSSReportException;
import eu.europa.esig.validationreport.ValidationReportFacade;
import eu.europa.esig.validationreport.jaxb.ValidationReportType;
import jakarta.xml.bind.JAXBException;
import java.io.IOException;
import org.xml.sax.SAXException;

public class Reports
extends AbstractReports {
    private final SimpleReport simpleReportWrapper;
    private String xmlSimpleReport;
    private final ValidationReportType etsiValidationReport;
    private String xmlEtsiValidationReport;

    public Reports(XmlDiagnosticData diagnosticDataJaxb, XmlDetailedReport detailedReport, XmlSimpleReport simpleReport, ValidationReportType validationReport) {
        super(diagnosticDataJaxb, detailedReport);
        this.simpleReportWrapper = new SimpleReport(simpleReport);
        this.etsiValidationReport = validationReport;
    }

    public SimpleReport getSimpleReport() {
        return this.simpleReportWrapper;
    }

    public XmlSimpleReport getSimpleReportJaxb() {
        return this.simpleReportWrapper.getJaxbModel();
    }

    public ValidationReportType getEtsiValidationReportJaxb() {
        return this.etsiValidationReport;
    }

    @Override
    public String getXmlSimpleReport() {
        try {
            if (this.xmlSimpleReport == null) {
                this.xmlSimpleReport = SimpleReportFacade.newFacade().marshall((Object)this.getSimpleReportJaxb(), this.validateXml);
            }
            return this.xmlSimpleReport;
        }
        catch (JAXBException | IOException | SAXException e) {
            throw new DSSReportException("An error occurred during marshalling of JAXB Simple Report", e);
        }
    }

    public String getXmlValidationReport() {
        try {
            if (this.xmlEtsiValidationReport == null) {
                this.xmlEtsiValidationReport = ValidationReportFacade.newFacade().marshall((Object)this.getEtsiValidationReportJaxb(), this.validateXml);
            }
            return this.xmlEtsiValidationReport;
        }
        catch (JAXBException | IOException | SAXException e) {
            throw new DSSReportException("An error occurred during marshalling of JAXB Etsi Validation Report", e);
        }
    }

    @Override
    public void print() {
        System.out.println("----------------Diagnostic data-----------------");
        System.out.println(this.getXmlDiagnosticData());
        System.out.println("----------------Validation report---------------");
        System.out.println(this.getXmlDetailedReport());
        System.out.println("----------------Simple report-------------------");
        System.out.println(this.getXmlSimpleReport());
        System.out.println("----------------ETSI validation report-------------------");
        if (this.etsiValidationReport != null) {
            System.out.println(this.getXmlValidationReport());
        } else {
            System.out.println("---------- ETSI validation report is disabled -----------");
        }
        System.out.println("---------------------------------------------------------");
    }
}

