/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp.checks.vts;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCRS;
import eu.europa.esig.dss.detailedreport.jaxb.XmlRFC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSAV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlVTS;
import eu.europa.esig.dss.diagnostic.CertificateRevocationWrapper;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.RevocationWrapper;
import eu.europa.esig.dss.diagnostic.TokenProxy;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.RevocationReason;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.SubContext;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.policy.jaxb.CertificateValuesConstraint;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.policy.jaxb.Model;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.bbb.sav.CertificateAcceptanceValidation;
import eu.europa.esig.dss.validation.process.bbb.sav.RevocationAcceptanceValidation;
import eu.europa.esig.dss.validation.process.bbb.xcv.rfc.RevocationFreshnessChecker;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.RevocationDataRequiredCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.POEExtraction;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.vts.ValidationTimeSlidingCertificateRevocationSelector;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.vts.checks.ControlTimeCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.vts.checks.SatisfyingRevocationDataExistsCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.vts.checks.SunsetDateCheck;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class ValidationTimeSliding
extends Chain<XmlVTS> {
    private final TokenProxy token;
    private final CertificateWrapper trustedCertificate;
    private final Date currentTime;
    private final Map<String, XmlBasicBuildingBlocks> bbbs;
    private final Context context;
    private final POEExtraction poe;
    private final ValidationPolicy policy;
    private Date controlTime;

    public ValidationTimeSliding(I18nProvider i18nProvider, TokenProxy token, CertificateWrapper trustedCertificate, Date currentTime, POEExtraction poe, Map<String, XmlBasicBuildingBlocks> bbbs, Context context, ValidationPolicy policy) {
        super(i18nProvider, new XmlVTS());
        this.token = token;
        this.trustedCertificate = trustedCertificate;
        this.currentTime = currentTime;
        this.bbbs = bbbs;
        this.context = context;
        this.poe = poe;
        this.policy = policy;
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.VALIDATION_TIME_SLIDING;
    }

    @Override
    protected void initChain() {
        XmlBasicBuildingBlocks tokenBBB = this.bbbs.get(this.token.getId());
        ChainItem<XmlVTS> item = null;
        if (this.trustedCertificate != null && this.trustedCertificate.getTrustSunsetDate() != null) {
            this.controlTime = this.trustedCertificate.getTrustSunsetDate();
            item = this.firstItem = this.sunsetDateCheck(this.trustedCertificate);
        } else {
            this.controlTime = this.currentTime;
        }
        List certificateChain = this.token.getCertificateChain();
        if (Utils.isCollectionNotEmpty((Collection)certificateChain)) {
            certificateChain = this.reduceChainUntilFirstTrustAnchor(certificateChain);
            certificateChain = Utils.reverseList(certificateChain);
            for (CertificateWrapper certificate : certificateChain) {
                XmlSAV revocationSAV;
                if (this.isTrustAnchor(certificate)) continue;
                CertificateRevocationWrapper latestCompliantRevocation = null;
                SubContext subContext = this.getSubContext(certificate);
                RevocationDataRequiredCheck<XmlVTS> revocationDataRequiredCheck = this.revocationDataRequired(certificate, subContext);
                boolean revocationDataRequired = revocationDataRequiredCheck.process();
                if (revocationDataRequired) {
                    LevelConstraint revocationIssuerSunsetDateConstraint = this.policy.getCertificateSunsetDateConstraint(Context.REVOCATION, SubContext.SIGNING_CERT);
                    List<CertificateRevocationWrapper> certificateRevocationData = SubContext.SIGNING_CERT.equals((Object)subContext) ? ValidationProcessUtils.getAcceptableRevocationDataForPSVIfExistOrReturnAll(this.token, certificate, this.currentTime, this.bbbs, this.poe, revocationIssuerSunsetDateConstraint) : certificate.getCertificateRevocationData();
                    ValidationTimeSlidingCertificateRevocationSelector certificateRevocationSelector = new ValidationTimeSlidingCertificateRevocationSelector(this.i18nProvider, certificate, certificateRevocationData, this.controlTime, this.bbbs, tokenBBB.getId(), this.poe, this.policy);
                    XmlCRS xmlCRS = (XmlCRS)certificateRevocationSelector.execute();
                    ((XmlVTS)this.result).getCRS().add(xmlCRS);
                    ChainItem<XmlVTS> satisfyingRevocationDataExists = this.satisfyingRevocationDataExists(xmlCRS, certificate, this.controlTime);
                    if (item == null) {
                        this.firstItem = satisfyingRevocationDataExists;
                        item = this.firstItem;
                    } else {
                        item = item.setNextItem(satisfyingRevocationDataExists);
                    }
                    latestCompliantRevocation = certificateRevocationSelector.getLatestAcceptableCertificateRevocation();
                } else if (item == null) {
                    this.firstItem = revocationDataRequiredCheck;
                    item = this.firstItem;
                } else {
                    item = item.setNextItem(revocationDataRequiredCheck);
                }
                if (latestCompliantRevocation != null) {
                    if (latestCompliantRevocation.isRevoked()) {
                        Model validationModel = this.policy.getValidationModel();
                        RevocationReason revocationReason = latestCompliantRevocation.getReason();
                        if (Model.SHELL.equals((Object)validationModel) || Model.HYBRID.equals((Object)validationModel) && SubContext.CA_CERTIFICATE.equals((Object)subContext) || RevocationReason.KEY_COMPROMISE.equals((Object)revocationReason) || RevocationReason.UNSPECIFIED.equals((Object)revocationReason)) {
                            this.controlTime = latestCompliantRevocation.getRevocationDate();
                        }
                    } else {
                        Date thisUpdate;
                        RevocationFreshnessChecker rfc = new RevocationFreshnessChecker(this.i18nProvider, (RevocationWrapper)latestCompliantRevocation, this.controlTime, this.context, subContext, this.policy);
                        XmlRFC execute = (XmlRFC)rfc.execute();
                        if (execute.getConclusion() != null && Indication.FAILED.equals((Object)execute.getConclusion().getIndication()) && (thisUpdate = latestCompliantRevocation.getThisUpdate()).before(this.controlTime)) {
                            this.controlTime = thisUpdate;
                        }
                    }
                }
                Date cryptoNotAfterDate = null;
                XmlSAV certificateSAV = this.getCertificateCryptographicAcceptanceResult(certificate, this.controlTime);
                if (!this.isValidConclusion(certificateSAV.getConclusion())) {
                    cryptoNotAfterDate = this.getCryptographicAlgorithmExpirationDateOrNull(certificateSAV);
                }
                if (latestCompliantRevocation != null && !this.isValidConclusion((revocationSAV = this.getRevocationCryptographicAcceptanceResult((RevocationWrapper)latestCompliantRevocation, this.controlTime)).getConclusion())) {
                    Date revCryptoNotAfter = this.getCryptographicAlgorithmExpirationDateOrNull(revocationSAV);
                    if (cryptoNotAfterDate == null || revCryptoNotAfter != null && revCryptoNotAfter.before(cryptoNotAfterDate)) {
                        cryptoNotAfterDate = revCryptoNotAfter;
                    }
                }
                if (cryptoNotAfterDate == null || !cryptoNotAfterDate.before(this.controlTime)) continue;
                this.controlTime = cryptoNotAfterDate;
            }
        }
        ChainItem<XmlVTS> controlTimeConclusiveCheck = this.controlTimeConclusive(this.controlTime);
        if (item == null) {
            this.firstItem = controlTimeConclusiveCheck;
            item = this.firstItem;
        } else {
            item = item.setNextItem(controlTimeConclusiveCheck);
        }
    }

    @Override
    protected void addAdditionalInfo() {
        ((XmlVTS)this.result).setControlTime(this.controlTime);
        ((XmlVTS)this.result).setTrustAnchor(this.trustedCertificate.getId());
    }

    private SubContext getSubContext(CertificateWrapper certificate) {
        return this.token.getSigningCertificate().getId().equals(certificate.getId()) ? SubContext.SIGNING_CERT : SubContext.CA_CERTIFICATE;
    }

    private List<CertificateWrapper> reduceChainUntilFirstTrustAnchor(List<CertificateWrapper> originalCertificateChain) {
        ArrayList<CertificateWrapper> result = new ArrayList<CertificateWrapper>();
        for (CertificateWrapper cert : originalCertificateChain) {
            result.add(cert);
            if (!this.isTrustAnchor(cert)) continue;
            break;
        }
        return result;
    }

    private boolean isTrustAnchor(CertificateWrapper certificate) {
        return certificate.equals((Object)this.trustedCertificate);
    }

    private Date getCryptographicAlgorithmExpirationDateOrNull(XmlSAV sav) {
        if (sav.getCryptographicValidation() != null && sav.getCryptographicValidation().getAlgorithm() != null) {
            return sav.getCryptographicValidation().getNotAfter();
        }
        return null;
    }

    private ChainItem<XmlVTS> sunsetDateCheck(CertificateWrapper trustedCertificate) {
        return new SunsetDateCheck(this.i18nProvider, (XmlVTS)this.result, trustedCertificate, this.getFailLevelConstraint());
    }

    private RevocationDataRequiredCheck<XmlVTS> revocationDataRequired(CertificateWrapper certificate, SubContext subContext) {
        CertificateValuesConstraint constraint = this.policy.getRevocationDataSkipConstraint(this.context, subContext);
        LevelConstraint sunsetDateConstraint = this.policy.getCertificateSunsetDateConstraint(this.context, subContext);
        return new RevocationDataRequiredCheck<XmlVTS>(this.i18nProvider, (XmlVTS)this.result, certificate, this.currentTime, sunsetDateConstraint, constraint);
    }

    private ChainItem<XmlVTS> satisfyingRevocationDataExists(XmlCRS crsResult, CertificateWrapper certificateWrapper, Date controlTime) {
        return new SatisfyingRevocationDataExistsCheck<XmlVTS>(this.i18nProvider, (XmlVTS)this.result, crsResult, certificateWrapper, controlTime, this.getFailLevelConstraint());
    }

    private ChainItem<XmlVTS> controlTimeConclusive(Date controlTime) {
        return new ControlTimeCheck(this.i18nProvider, (XmlVTS)this.result, controlTime, this.getFailLevelConstraint());
    }

    private XmlSAV getCertificateCryptographicAcceptanceResult(CertificateWrapper certificateWrapper, Date controlTime) {
        CertificateAcceptanceValidation cav = new CertificateAcceptanceValidation(this.i18nProvider, controlTime, certificateWrapper, this.policy);
        return (XmlSAV)cav.execute();
    }

    private XmlSAV getRevocationCryptographicAcceptanceResult(RevocationWrapper revocationWrapper, Date controlTime) {
        RevocationAcceptanceValidation rav = new RevocationAcceptanceValidation(this.i18nProvider, controlTime, revocationWrapper, this.policy);
        return (XmlSAV)rav.execute();
    }
}

