/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfltvd.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.RuleUtils;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.policy.jaxb.TimeConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;
import java.util.Date;

public class TimestampDelayCheck<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    private final SignatureWrapper signature;
    private final Date bestSignatureTime;
    private final TimeConstraint timeConstraint;

    public TimestampDelayCheck(I18nProvider i18nProvider, T result, SignatureWrapper signature, Date bestSignatureTime, TimeConstraint timeConstraint) {
        super(i18nProvider, result, (LevelConstraint)timeConstraint);
        this.signature = signature;
        this.bestSignatureTime = bestSignatureTime;
        this.timeConstraint = timeConstraint;
    }

    @Override
    protected boolean process() {
        Date signingTime = this.signature.getClaimedSigningTime();
        if (signingTime == null) {
            return false;
        }
        long delayMilliseconds = RuleUtils.convertDuration((TimeConstraint)this.timeConstraint);
        Date limit = delayMilliseconds == Long.MAX_VALUE ? new Date(Long.MAX_VALUE) : new Date(signingTime.getTime() + delayMilliseconds);
        return limit.after(this.bestSignatureTime);
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.ADEST_ISTPTDABST;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.ADEST_ISTPTDABST_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.SIG_CONSTRAINTS_FAILURE;
    }
}

