/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.trust.consistency;

import eu.europa.esig.dss.diagnostic.TrustServiceWrapper;
import eu.europa.esig.dss.enumerations.AdditionalServiceInformation;
import eu.europa.esig.dss.enumerations.ServiceQualification;
import eu.europa.esig.dss.validation.process.qualification.EIDASUtils;
import eu.europa.esig.dss.validation.process.qualification.trust.consistency.TrustServiceCondition;
import java.util.Date;
import java.util.List;

public class TrustServiceQualifierAndAdditionalServiceInfoPreEIDASConsistency
implements TrustServiceCondition {
    @Override
    public boolean isConsistent(TrustServiceWrapper trustService) {
        Date startDate = trustService.getStartDate();
        if (EIDASUtils.isPreEIDAS(startDate)) {
            List asis = trustService.getAdditionalServiceInfos();
            if (AdditionalServiceInformation.isForeSealsOnly((List)asis) || AdditionalServiceInformation.isForWebAuthOnly((List)asis)) {
                return false;
            }
            List qualifiers = trustService.getCapturedQualifierUris();
            if (ServiceQualification.isQcForEseal((List)qualifiers) || ServiceQualification.isQcForWSA((List)qualifiers)) {
                return false;
            }
        }
        return true;
    }
}

