/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBlockType;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.CertificateValuesConstraint;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.bbb.AbstractCertificateCheckItem;
import java.util.Date;

public class RevocationDataRequiredCheck<T extends XmlConstraintsConclusion>
extends AbstractCertificateCheckItem<T> {
    private final CertificateWrapper certificate;
    private final Date currentTime;
    private final LevelConstraint certificateSunsetDateConstraint;

    public RevocationDataRequiredCheck(I18nProvider i18nProvider, T result, CertificateWrapper certificate, Date currentTime, LevelConstraint certificateSunsetDateConstraint, CertificateValuesConstraint constraint) {
        super(i18nProvider, result, certificate, constraint);
        this.certificate = certificate;
        this.currentTime = currentTime;
        this.certificateSunsetDateConstraint = certificateSunsetDateConstraint;
    }

    @Override
    protected XmlBlockType getBlockType() {
        return XmlBlockType.RAC_SUB_XCV;
    }

    @Override
    public boolean process() {
        return !this.isTrustAnchor(this.certificate) && !this.certificate.isSelfSigned() && !this.processCertificateCheck(this.certificate);
    }

    private boolean isTrustAnchor(CertificateWrapper certificate) {
        return ValidationProcessUtils.isTrustAnchor(certificate, this.currentTime, this.certificateSunsetDateConstraint);
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_XCV_IRDCSFC;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_XCV_IRDCSFC_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.CERTIFICATE_CHAIN_GENERAL_FAILURE;
    }
}

