/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.fc.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.diagnostic.jaxb.XmlContainerInfo;
import eu.europa.esig.dss.diagnostic.jaxb.XmlManifestFile;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class AbstractSignedAndTimestampedFilesCoveredCheck<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    private final XmlContainerInfo containerInfo;
    private final String timestampFilename;

    protected AbstractSignedAndTimestampedFilesCoveredCheck(I18nProvider i18nProvider, T result, XmlContainerInfo containerInfo, String timestampFilename, LevelConstraint constraint) {
        super(i18nProvider, result, constraint);
        this.containerInfo = containerInfo;
        this.timestampFilename = timestampFilename;
    }

    @Override
    protected boolean process() {
        XmlManifestFile manifestFile = this.getCorrespondingManifestFile(this.timestampFilename);
        if (manifestFile != null) {
            return this.checkManifestFilesCovered(manifestFile) && this.isAnyRootLevelDocumentCovered(manifestFile);
        }
        return true;
    }

    private boolean checkManifestFilesCovered(XmlManifestFile timestampManifest) {
        return this.checkManifestFilesCoveredRecursively(timestampManifest, timestampManifest);
    }

    private boolean checkManifestFilesCoveredRecursively(XmlManifestFile timestampManifest, XmlManifestFile currentManifestFile) {
        if (currentManifestFile != null) {
            for (String manifestEntry : currentManifestFile.getEntries()) {
                if (!timestampManifest.getEntries().contains(manifestEntry)) {
                    return false;
                }
                XmlManifestFile entryManifest = this.getCorrespondingManifestFile(manifestEntry);
                if (entryManifest == null || this.checkManifestFilesCoveredRecursively(timestampManifest, entryManifest)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isAnyRootLevelDocumentCovered(XmlManifestFile timestampManifest) {
        List<String> rootLevelFiles = this.getRootLevelFiles(this.containerInfo.getContentFiles());
        return Utils.containsAny((Collection)timestampManifest.getEntries(), rootLevelFiles);
    }

    private XmlManifestFile getCorrespondingManifestFile(String filename) {
        for (XmlManifestFile manifestFile : this.containerInfo.getManifestFiles()) {
            if (!filename.equals(manifestFile.getSignatureFilename())) continue;
            return manifestFile;
        }
        return null;
    }

    private List<String> getRootLevelFiles(List<String> fileNames) {
        ArrayList<String> result = new ArrayList<String>();
        for (String fileName : fileNames) {
            if (!this.isRootDirectoryFile(fileName)) continue;
            result.add(fileName);
        }
        return result;
    }

    private boolean isRootDirectoryFile(String fileName) {
        return !fileName.contains("/") && !fileName.contains("\\");
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_FC_ISFP_ASTFORAMC;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_FC_ISFP_ASTFORAMC_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.FAILED;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.FORMAT_FAILURE;
    }
}

