/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.cv.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlCV;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestMatcher;
import eu.europa.esig.dss.enumerations.DigestMatcherType;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;
import java.util.List;
import java.util.stream.Collectors;

public class ManifestEntryExistenceCheck
extends ChainItem<XmlCV> {
    private final List<XmlDigestMatcher> digestMatchers;

    public ManifestEntryExistenceCheck(I18nProvider i18nProvider, XmlCV result, List<XmlDigestMatcher> digestMatchers, LevelConstraint constraint) {
        super(i18nProvider, result, constraint);
        this.digestMatchers = digestMatchers;
    }

    @Override
    protected boolean process() {
        for (XmlDigestMatcher xmlDigestMatcher : this.digestMatchers) {
            if (!DigestMatcherType.MANIFEST_ENTRY.equals((Object)xmlDigestMatcher.getType()) || !xmlDigestMatcher.isDataFound()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_CV_ISMEC;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        List manifestEntries = this.digestMatchers.stream().filter(d -> DigestMatcherType.MANIFEST_ENTRY == d.getType()).collect(Collectors.toList());
        if (Utils.isCollectionNotEmpty(manifestEntries) && manifestEntries.stream().noneMatch(XmlDigestMatcher::isDataFound)) {
            return MessageTag.BBB_CV_ISMEC_ANS_2;
        }
        return MessageTag.BBB_CV_ISMEC_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.SIGNED_DATA_NOT_FOUND;
    }
}

