/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.policy.jaxb.CertificateValuesConstraint;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.policy.jaxb.MultiValuesConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class AbstractCertificateCheckItem<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    private final CertificateValuesConstraint constraint;

    protected AbstractCertificateCheckItem(I18nProvider i18nProvider, T result, CertificateValuesConstraint constraint) {
        super(i18nProvider, result, (LevelConstraint)constraint);
        this.constraint = constraint;
    }

    protected AbstractCertificateCheckItem(I18nProvider i18nProvider, T result, CertificateWrapper certificate, CertificateValuesConstraint constraint) {
        super(i18nProvider, result, (LevelConstraint)constraint, certificate.getId());
        this.constraint = constraint;
    }

    protected boolean processCertificateCheck(CertificateWrapper certificate) {
        if (this.constraint == null) {
            return false;
        }
        MultiValuesConstraint certificateExtensionsConstraint = this.constraint.getCertificateExtensions();
        List expectedCertificateExtensions = certificateExtensionsConstraint != null ? certificateExtensionsConstraint.getId() : Collections.emptyList();
        MultiValuesConstraint certificatePoliciesConstraint = this.constraint.getCertificatePolicies();
        List expectedCertificatePolicies = certificatePoliciesConstraint != null ? certificatePoliciesConstraint.getId() : Collections.emptyList();
        return Utils.isCollectionNotEmpty((Collection)expectedCertificateExtensions) && Utils.isCollectionNotEmpty((Collection)certificate.getCertificateExtensionsOids()) && ValidationProcessUtils.processValuesCheck(certificate.getCertificateExtensionsOids(), expectedCertificateExtensions) || Utils.isCollectionNotEmpty((Collection)expectedCertificatePolicies) && Utils.isCollectionNotEmpty((Collection)certificate.getCertificatePoliciesOids()) && ValidationProcessUtils.processValuesCheck(certificate.getCertificatePoliciesOids(), expectedCertificatePolicies);
    }
}

