/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.policy.jaxb.BasicSignatureConstraints;
import eu.europa.esig.dss.policy.jaxb.Level;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.spi.validation.TrustAnchorVerifier;

public class TrustAnchorVerifierFactory {
    private final ValidationPolicy validationPolicy;

    public TrustAnchorVerifierFactory(ValidationPolicy validationPolicy) {
        this.validationPolicy = validationPolicy;
    }

    public TrustAnchorVerifier create() {
        TrustAnchorVerifier trustAnchorVerifier = TrustAnchorVerifier.createEmptyTrustAnchorVerifier();
        this.instantiateAcceptUntrustedCertificateChains(trustAnchorVerifier, this.validationPolicy);
        this.instantiateUseSunsetDate(trustAnchorVerifier, this.validationPolicy);
        return trustAnchorVerifier;
    }

    private void instantiateAcceptUntrustedCertificateChains(TrustAnchorVerifier trustAnchorVerifier, ValidationPolicy validationPolicy) {
        boolean acceptUntrustedCertificateChains;
        if (validationPolicy.getRevocationConstraints() != null) {
            acceptUntrustedCertificateChains = this.getAcceptUntrustedCertificateChains(validationPolicy.getRevocationConstraints().getBasicSignatureConstraints());
            trustAnchorVerifier.setAcceptRevocationUntrustedCertificateChains(acceptUntrustedCertificateChains);
        }
        if (validationPolicy.getTimestampConstraints() != null) {
            acceptUntrustedCertificateChains = this.getAcceptUntrustedCertificateChains(validationPolicy.getTimestampConstraints().getBasicSignatureConstraints());
            trustAnchorVerifier.setAcceptTimestampUntrustedCertificateChains(acceptUntrustedCertificateChains);
        }
    }

    private boolean getAcceptUntrustedCertificateChains(BasicSignatureConstraints basicSignatureConstraints) {
        if (basicSignatureConstraints != null) {
            LevelConstraint constraint = basicSignatureConstraints.getProspectiveCertificateChain();
            return constraint == null || !Level.FAIL.equals((Object)constraint.getLevel());
        }
        return true;
    }

    private void instantiateUseSunsetDate(TrustAnchorVerifier trustAnchorVerifier, ValidationPolicy validationPolicy) {
        boolean useSunsetDate = false;
        if (validationPolicy.getSignatureConstraints() != null) {
            useSunsetDate = this.getUseSunsetDate(validationPolicy.getSignatureConstraints().getBasicSignatureConstraints());
        }
        if (validationPolicy.getCounterSignatureConstraints() != null) {
            boolean bl = useSunsetDate = useSunsetDate || this.getUseSunsetDate(validationPolicy.getCounterSignatureConstraints().getBasicSignatureConstraints());
        }
        if (validationPolicy.getTimestampConstraints() != null) {
            boolean bl = useSunsetDate = useSunsetDate || this.getUseSunsetDate(validationPolicy.getTimestampConstraints().getBasicSignatureConstraints());
        }
        if (validationPolicy.getRevocationConstraints() != null) {
            useSunsetDate = useSunsetDate || this.getUseSunsetDate(validationPolicy.getRevocationConstraints().getBasicSignatureConstraints());
        }
        trustAnchorVerifier.setUseSunsetDate(useSunsetDate);
    }

    private boolean getUseSunsetDate(BasicSignatureConstraints basicSignatureConstraints) {
        if (basicSignatureConstraints != null) {
            LevelConstraint constraint;
            if (basicSignatureConstraints.getSigningCertificate() != null && (constraint = basicSignatureConstraints.getSigningCertificate().getSunsetDate()) != null && Level.FAIL.equals((Object)constraint.getLevel())) {
                return true;
            }
            if (basicSignatureConstraints.getCACertificate() != null && (constraint = basicSignatureConstraints.getCACertificate().getSunsetDate()) != null && Level.FAIL.equals((Object)constraint.getLevel())) {
                return true;
            }
        }
        return false;
    }
}

