/*
 * Decompiled with CFR 0.152.
 */
package com.anf.firmas.utils;

import com.anf.firmas.utils.CertificateVerificationException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.NoSuchProviderException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;

public class CRLValidation {
    public static void verifyCertificateCRLs(X509Certificate cert) throws CertificateVerificationException {
        try {
            List<String> crlDistPoints = CRLValidation.getCrlDistributionPoints(cert);
            for (String crlDP : crlDistPoints) {
                X509CRL crl = CRLValidation.downloadCRL(crlDP);
                if (!crl.isRevoked(cert)) continue;
                throw new CertificateVerificationException("The certificate is revoked by CRL: " + crlDP);
            }
        }
        catch (Exception ex) {
            if (ex instanceof CertificateVerificationException) {
                throw (CertificateVerificationException)ex;
            }
            throw new CertificateVerificationException("Can not verify CRL for certificate: " + cert.getSubjectX500Principal(), ex);
        }
    }

    public static X509CRL downloadCRL(String crlURL) throws IOException, CertificateException, CRLException, CertificateVerificationException, NamingException, NoSuchProviderException {
        if (crlURL.startsWith("http://") || crlURL.startsWith("https://") || crlURL.startsWith("ftp://")) {
            return CRLValidation.downloadCRLFromWeb(crlURL);
        }
        if (crlURL.startsWith("ldap://")) {
            return null;
        }
        throw new CertificateVerificationException("Can not download CRL from certificate distribution point: " + crlURL);
    }

    private static X509CRL downloadCRLFromLDAP(String ldapURL) throws CertificateException, NamingException, CRLException, CertificateVerificationException, NoSuchProviderException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", ldapURL);
        InitialDirContext ctx = new InitialDirContext(env);
        Attributes avals = ctx.getAttributes("");
        Attribute aval = avals.get("certificateRevocationList;binary");
        byte[] val = (byte[])aval.get();
        if (val == null || val.length == 0) {
            throw new CertificateVerificationException("Can not download CRL from: " + ldapURL);
        }
        ByteArrayInputStream inStream = new ByteArrayInputStream(val);
        CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
        return (X509CRL)cf.generateCRL(inStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X509CRL downloadCRLFromWeb(String crlURL) throws MalformedURLException, IOException, CertificateException, CRLException, NoSuchProviderException {
        URL url = new URL(crlURL);
        try (InputStream crlStream = url.openStream();){
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            X509CRL x509CRL = (X509CRL)cf.generateCRL(crlStream);
            return x509CRL;
        }
    }

    public static List<String> getCrlDistributionPoints(X509Certificate cert) {
        DistributionPoint[] distPoints;
        ArrayList<String> crls = new ArrayList<String>();
        byte[] crldpExt = cert.getExtensionValue(Extension.cRLDistributionPoints.getId());
        if (crldpExt == null) {
            return crls;
        }
        ASN1OctetString octec = ASN1OctetString.getInstance((Object)crldpExt);
        crldpExt = octec.getOctets();
        CRLDistPoint crldp = CRLDistPoint.getInstance((Object)crldpExt);
        for (DistributionPoint distPoint : distPoints = crldp.getDistributionPoints()) {
            GeneralName[] list;
            DistributionPointName point = distPoint.getDistributionPoint();
            if (point == null) continue;
            GeneralNames names = GeneralNames.getInstance((Object)point.getName());
            for (GeneralName name : list = names.getNames()) {
                if (name.getTagNo() != 6) continue;
                crls.add(name.getName().toString());
            }
        }
        return crls;
    }
}

