/*
 * Decompiled with CFR 0.152.
 */
package com.anf.firmas.jni;

import java.math.BigInteger;

public final class PartitionInfo {
    private BigInteger startOffset;
    BigInteger length;
    private int type;
    private boolean booteable;
    private boolean recognized;
    private float percent;

    public PartitionInfo(BigInteger startOffset, BigInteger length, int type, boolean booteable, boolean recognized) {
        this.startOffset = startOffset;
        this.length = length;
        this.type = type;
        this.booteable = booteable;
        this.recognized = recognized;
    }

    public BigInteger getStartOffset() {
        return this.startOffset;
    }

    public BigInteger getLength() {
        return this.length;
    }

    public long getSizeMB() {
        return this.length.divide(new BigInteger("1024")).longValue() / 1024L;
    }

    public long getSizeKB() {
        return this.length.divide(new BigInteger("1024")).longValue();
    }

    public long getStartOffSetMB() {
        return this.startOffset.divide(new BigInteger("1024")).longValue() / 1024L;
    }

    public long getStartOffSetKB() {
        return this.startOffset.divide(new BigInteger("1024")).longValue();
    }

    public int getType() {
        return this.type;
    }

    void setPercent(float f) {
        this.percent = f;
    }

    public float getPercent() {
        return this.percent;
    }

    public String getFormatType() {
        switch (this.type) {
            case 6: {
                return "FAT-32";
            }
            case 7: {
                return "NTFS";
            }
            case 94: {
                return "ANFP11";
            }
        }
        return "OTRO";
    }

    public boolean isBooteable() {
        return this.booteable;
    }

    public boolean isRecognized() {
        return this.recognized;
    }

    public String toString() {
        return this.getPercent() + "% | Start:" + this.getStartOffSetMB() + " MB, Size:" + this.getSizeMB() + " MB, boot:" + this.booteable + ", " + this.getFormatType();
    }
}

