/*
 * Decompiled with CFR 0.152.
 */
package com.anf.firmas.jni;

import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.tkmanager.PKCS11ModuleFactory;
import com.anf.cryptotoken.tkmanager.PKCS11Type;
import com.anf.cryptotoken.tkmanager.TKManagerFactory;
import com.anf.cryptotoken.tkmanager.token.ANFToken;
import com.anf.cryptotoken.tkmanager.token.ANFTokenFactory;
import com.anf.cryptotoken.ui.keyboard.handler.KeyBoardHandler;
import com.anf.firmas.jni.DeviceLayout;
import com.anf.pkcs11.jna.CK_TOKEN_INFO;
import com.anf.pkcs11.jna.P11Manager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.concurrent.TimeUnit;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class InitANFP11 {
    private static final Logger log = Logger.getLogger(InitANFP11.class);
    private static String PKCS11_FILENAME = "PKCS11Libs/anfp11/initANFP11";
    private static InitANFP11 inst;

    public String getSlotUnit(long slot) {
        String usbUnit = this.getUSBUnit(slot);
        if (usbUnit != null) {
            return usbUnit;
        }
        return null;
    }

    public String swapPartitionsVerified(long slot) {
        String unit = this.getSlotUnit(slot);
        if (unit != null) {
            File usb = new File(unit);
            long size = usb.getTotalSpace() / 0x100000L;
            log.info((Object)("antes de intercambiar las particiones del slot " + slot + ", la unidad es " + unit + ", y el tamano de la unidad es " + size + " MB"));
            String swapPartitions = this.swapPartitions(slot);
            log.info((Object)("swapPartitions returns " + swapPartitions));
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            usb = new File(unit);
            size = usb.getTotalSpace() / 0x100000L;
            log.info((Object)("justo despues de intercambiar las particiones del slot " + slot + ", la unidad es " + unit + ", y el tamano de la unidad es " + size + " MB"));
        } else {
            log.info((Object)("no se pudo obtener la unidad del slot " + slot + " al cambiar las particiones"));
        }
        return null;
    }

    public native String swapPartitions(long var1);

    private native String getUSBUnit(long var1);

    public native boolean isAdmin();

    private native boolean format(long var1, int var3, int var4);

    public native int getDeviceCount();

    public native int getANFP11TokenCount();

    private native boolean formatALL(int var1, int var2);

    public native int[] getDefaultPercents(long var1);

    public native int[] getMinPercents(long var1);

    public native int[] calculatePercents(long var1, int var3, int var4);

    private native String getTotalSize(long var1);

    private native DeviceLayout getLayout(long var1);

    public native boolean updateMBR(long var1);

    public DeviceLayout getDeviceLayout(long slot) {
        DeviceLayout layout = this.getLayout(slot);
        if (layout != null) {
            layout.setTotalSize(this.getTotalByteSize(slot));
            layout.compute();
            return layout;
        }
        return null;
    }

    public BigInteger getTotalByteSize(long slot) {
        String totalSize = this.getTotalSize(slot);
        if (totalSize != null) {
            return new BigInteger(totalSize);
        }
        return null;
    }

    public long getTotalKBSize(long slot) {
        String totalSize = this.getTotalSize(slot);
        if (totalSize != null) {
            long kb = new BigInteger(totalSize).divide(new BigInteger("1024")).longValue();
            return kb;
        }
        return -1L;
    }

    public long getTotalMBSize(long slot) {
        long kb = this.getTotalKBSize(slot);
        if (kb > 0L) {
            return kb / 1024L;
        }
        return -1L;
    }

    public boolean formatSlot(int slot, int percentPub, int percentPriv) {
        log.info((Object)("formateando slot " + slot + "con porcientos " + percentPub + " " + percentPriv));
        String unit = this.getSlotUnit(slot);
        if (unit != null) {
            File usb = new File(unit);
            long size = usb.getTotalSpace() / 0x100000L;
            log.info((Object)("antes de formatear el slot " + slot + ", la unidad es " + unit + ", y el tamano de la unidad es " + size + " MB"));
            DeviceLayout layout = this.getDeviceLayout(slot);
            log.info((Object)("DeviceLayout antes de formatear:\n" + layout));
        }
        boolean format = this.format(slot, percentPub, percentPriv);
        log.info((Object)("el formato es " + format));
        if (format) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            DeviceLayout layout = this.getDeviceLayout(slot);
            log.info((Object)("DeviceLayout antes de formatear con NTFS:\n" + layout));
            log.info((Object)"formateando la particion con NTFS");
            boolean doFormat = this.doFormat(slot);
            log.info((Object)("resultado de formatear la particion con NTFS: " + doFormat));
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            log.info((Object)"corrigiendo errores en particion 1");
            this.checkFixDisk(slot);
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            unit = this.getSlotUnit(slot);
            if (unit != null) {
                File usb = new File(unit);
                long size = usb.getTotalSpace() / 0x100000L;
                log.info((Object)("despues de formatear el slot " + slot + ", la unidad es " + unit + ", y el tamano de la unidad es " + size + " MB"));
                layout = this.getDeviceLayout(slot);
                log.info((Object)("DeviceLayout despues de formatear:\n" + layout));
            }
            log.info((Object)"formato completado");
        }
        return format;
    }

    public boolean checkFixDisk(int slot) {
        String unit = this.getSlotUnit(slot);
        return this.checkFixDisk(unit);
    }

    public boolean checkFixDisk(String unit) {
        if (unit != null) {
            try {
                Process proc = Runtime.getRuntime().exec(String.format("cmd /c Chkdsk %s /F /X /I /C", unit.replace(File.separator, "")));
                int counter = 0;
                while (proc != null && proc.isAlive()) {
                    proc.waitFor(1L, TimeUnit.MINUTES);
                    log.info((Object)"***********VISTA DE SALIDA DE CHECKDSK***************");
                    InputStream e = proc.getInputStream();
                    int available = e.available();
                    byte[] arr = new byte[available];
                    e.read(arr, 0, available);
                    String error = new String(arr);
                    log.info((Object)error);
                    log.info((Object)"***********FIN VISTA DE SALIDA DE CHECKDSK***************");
                    if (counter++ <= 15 || !proc.isAlive()) continue;
                    log.info((Object)"Chkdsk destroying");
                    proc.destroy();
                    return false;
                }
                log.info((Object)("Chkdsk returns " + proc.exitValue()));
                return proc.exitValue() == 0;
            }
            catch (Throwable e) {
                log.error((Object)e);
            }
        }
        return false;
    }

    public boolean formatSlot(int slot) {
        boolean format = this.formatSlot(slot, 0, 0);
        return format;
    }

    public boolean removeFormat(int slot) {
        boolean format = this.format(slot, 100, 0);
        return format;
    }

    public boolean doFormat(int slot) {
        String unit = this.getSlotUnit(slot);
        return InitANFP11.doFormat(unit);
    }

    public static boolean doFormat(String unit) {
        if (unit != null) {
            try {
                Process proc = Runtime.getRuntime().exec(String.format("cmd /c format.com %s /BACKUP /FS:NTFS /Q /X /V:eSign-ANF-AC", unit.replace(File.separator, "")));
                proc.waitFor();
                InputStream e = proc.getInputStream();
                int available = e.available();
                byte[] arr = new byte[available];
                e.read(arr, 0, available);
                String error = new String(arr);
                System.out.println(error);
                return proc.exitValue() == 0;
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private InitANFP11() {
    }

    public static InitANFP11 get() {
        return inst;
    }

    public static void main(String[] args) {
        InitANFP11 initAnfp11 = new InitANFP11();
        boolean admin = initAnfp11.isAdmin();
        if (admin) {
            boolean removeFormat = initAnfp11.removeFormat(0);
            System.out.println(removeFormat);
            boolean formatSlot = initAnfp11.formatSlot(0);
            System.out.println(formatSlot);
            System.exit(0);
        }
        System.out.println("ANFP11 FORMAT");
        JSpinner spin = new JSpinner(new SpinnerNumberModel(90, 1, 99, 1));
        JFrame f = KeyBoardHandler.getFrame();
        try {
            try {
                boolean updateMBR = initAnfp11.updateMBR(0L);
                System.out.println(updateMBR);
                String swapPartitions = initAnfp11.swapPartitions(0L);
                DeviceLayout layout = initAnfp11.getDeviceLayout(0L);
                System.out.println(layout);
            }
            catch (Throwable e1) {
                e1.printStackTrace();
            }
            int anfp11TokenCount = initAnfp11.getANFP11TokenCount();
            System.out.println(anfp11TokenCount);
            boolean removeFormat = initAnfp11.removeFormat(0);
            boolean doFormat = initAnfp11.doFormat(0);
            boolean adminn = initAnfp11.isAdmin();
            try {
                int[] real = initAnfp11.calculatePercents(0L, 70, 12);
                String totalSize = initAnfp11.getTotalSize(0L);
                long totalKBSize = initAnfp11.getTotalKBSize(0L);
                long totalMBSize = initAnfp11.getTotalMBSize(0L);
                int[] res = initAnfp11.getMinPercents(0L);
                int[] res2 = initAnfp11.getDefaultPercents(0L);
                System.out.println(String.format("%d %d %d", new Object[]{res}));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            initAnfp11.swapPartitions(0L);
            String usbUnit = initAnfp11.getSlotUnit(0L);
            boolean formatExe = initAnfp11.formatExe(0);
            int[] percents = new int[]{40};
            int[] percents2 = new int[]{40};
            for (int i = 0; i < percents.length; ++i) {
                int percent = percents[i];
                int percent2 = percents2[i];
                InitANFP11.format(initAnfp11, percent, percent2);
            }
            while (true) {
                int res;
                if ((res = JOptionPane.showConfirmDialog(f, "Desea formatear otra vez?", "Hey dime!", 0, 0)) == 0) {
                    int percent = 0;
                    while (percent == 0) {
                        res = JOptionPane.showConfirmDialog(f, spin, "Ahora dime: que porciento?", 2, 0);
                        if (res == 0) {
                            percent = (Integer)spin.getValue();
                            continue;
                        }
                        return;
                    }
                    int percent2 = 0;
                    while (percent2 == 0) {
                        res = JOptionPane.showConfirmDialog(f, spin, "Ahora dime: que porciento 2?", 2, 0);
                        if (res == 0) {
                            percent2 = (Integer)spin.getValue();
                            continue;
                        }
                        return;
                    }
                    if (percent <= 0 || percent2 <= 0) continue;
                    InitANFP11.format(initAnfp11, percent, percent2);
                    continue;
                }
                return;
            }
        }
        finally {
            f.dispose();
            System.exit(0);
        }
    }

    private static void testSwap() {
        long slot = 0L;
        for (int i = 0; i < 10; ++i) {
            InitANFP11.get().swapPartitionsVerified(slot);
        }
        log.info((Object)"System.exit(0); en testSwap");
        System.exit(0);
    }

    private static void format(InitANFP11 initAnfp11, int percentPub, int percentPriv) {
        System.out.println("\n\n\n*********COMENZANDO FORMATO ANFP11*************");
        int devs = initAnfp11.getDeviceCount();
        int tokens = initAnfp11.getANFP11TokenCount();
        System.out.println("Dispositivos USB conectados: " + devs);
        System.out.println("Tokens ANFP11 conectados: " + tokens);
        System.out.println();
        System.out.println("formateando con porciento: " + percentPub + " " + percentPriv);
        for (int slot = 0; slot < devs; ++slot) {
            System.out.println("Formateando dispositivo " + slot);
            boolean format = initAnfp11.formatSlot(slot, percentPub, percentPriv);
            System.out.println("formateo devuelve: " + format);
            log.info((Object)format);
        }
        if (devs > 0) {
            System.out.println("preparandose para inicializar los tokens ANFP11...");
            System.out.println("esperando 5 segundos");
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                log.error((Object)e);
            }
            try {
                CK_TOKEN_INFO[] tokenInfos = TKManagerFactory.getTokenInfos(PKCS11Type.ANFP11);
                System.out.println("cantidad de tokens ANFP11 conectados: " + tokenInfos.length);
                for (int slot = 0; slot < tokenInfos.length; ++slot) {
                    System.out.println("Inicializando el token " + slot);
                    P11Manager p11 = PKCS11ModuleFactory.getP11(PKCS11Type.ANFP11);
                    ANFToken token = ANFTokenFactory.getToken(PKCS11Type.ANFP11, p11.getTokenInfo((long)slot), slot);
                    p11.initToken((long)slot, token.getPINManufacturer(), token.getPINSOManufacturer(), token.getPINSODefault(), token.getLabelToken());
                    System.out.println();
                }
            }
            catch (Throwable e) {
                log.error((Object)e);
            }
        }
    }

    public boolean formatExe(int slot) {
        try {
            File exe = new File("PKCS11Libs/anfp11", "format-anfp11.exe").getCanonicalFile();
            if (exe.exists()) {
                Process proc = Runtime.getRuntime().exec(exe.getCanonicalPath() + " " + slot);
                proc.waitFor();
                InputStream e = proc.getInputStream();
                int available = e.available();
                byte[] arr = new byte[available];
                e.read(arr, 0, available);
                String out = new String(arr);
                System.out.println(out);
                e = proc.getErrorStream();
                available = e.available();
                arr = new byte[available];
                e.read(arr, 0, available);
                out = new String(arr);
                System.out.println(out);
                return out.isEmpty();
            }
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
        return false;
    }

    static {
        System.loadLibrary("PKCS11Libs/anfp11/msvcr71");
        System.loadLibrary("PKCS11Libs/anfp11/msvcr120d");
        System.loadLibrary("PKCS11Libs/anfp11/msvcp120d");
        System.loadLibrary("PKCS11Libs/anfp11/libeay32");
        System.loadLibrary("PKCS11Libs/anfp11/anfpkcs11");
        System.loadLibrary(PKCS11_FILENAME);
        inst = new InitANFP11();
    }
}

