/*
 * Decompiled with CFR 0.152.
 */
package com.anf.firmas.jni;

import com.anf.firmas.jni.PartitionInfo;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;

public class DeviceLayout {
    private int partitionCount = -1;
    private String signature = null;
    List<PartitionInfo> partitions = new ArrayList<PartitionInfo>();
    private BigInteger totalSize;

    public void setPartitionCount(int partitionCount) {
        this.partitionCount = partitionCount;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public void addPartition(String startOffSet, String length, int type, boolean booteable, boolean recognized) {
        this.partitions.add(new PartitionInfo(new BigInteger(startOffSet), new BigInteger(length), type, booteable, recognized));
    }

    public int getPartitionCount() {
        return this.partitionCount;
    }

    public List<PartitionInfo> getPartitions() {
        return this.partitions;
    }

    public String getSignature() {
        return this.signature;
    }

    public void compute() {
        for (int i = 0; i < this.partitions.size() && i < this.partitionCount; ++i) {
            if (!this.partitions.get((int)i).length.toString().equals("0")) continue;
            this.partitions.remove(i--);
        }
        for (PartitionInfo p : this.partitions) {
            BigDecimal r = new BigDecimal(p.getLength()).multiply(new BigDecimal("100")).divide(new BigDecimal(this.totalSize), 3, RoundingMode.HALF_UP);
            p.setPercent(Float.valueOf(r.toString()).floatValue());
        }
        this.partitionCount = this.partitions.size();
    }

    public void setTotalSize(BigInteger totalByteSize) {
        this.totalSize = totalByteSize;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Size: " + this.totalSize + " bytes");
        sb.append("\n");
        int i = 1;
        for (PartitionInfo p : this.partitions) {
            sb.append("Part " + i++ + ": " + p + "\n");
        }
        return sb.toString();
    }
}

