/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.ui.tray;

import java.awt.AWTException;
import java.awt.Image;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.imageio.ImageIO;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TrayIconNotificationHandler {
    private static final Logger log = LogManager.getLogger(TrayIconNotificationHandler.class);
    private Image image;
    private String title;
    private String toolTip;
    private String caption;
    private String message;
    private TrayIcon.MessageType type = TrayIcon.MessageType.NONE;
    private static TrayIcon trayIcon = null;

    public TrayIconNotificationHandler(String img, String title, String toolTip, String caption, String message, TrayIcon.MessageType type) {
        this(ClassLoader.getSystemClassLoader().getResource(img), title, toolTip, caption, message, type);
    }

    public TrayIconNotificationHandler(URL imgUrl, String title, String toolTip, String caption, String message, TrayIcon.MessageType type) {
        this(Toolkit.getDefaultToolkit().createImage(imgUrl), title, toolTip, caption, message, type);
    }

    public TrayIconNotificationHandler(Image image, String title, String toolTip, String caption, String message, TrayIcon.MessageType type) {
        this.image = image;
        this.title = title;
        this.toolTip = toolTip;
        this.caption = caption;
        this.message = message;
        this.type = type;
    }

    public TrayIconNotificationHandler(String title, String toolTip, String caption, String message, TrayIcon.MessageType type) {
        this.title = title;
        this.toolTip = toolTip;
        this.caption = caption;
        this.message = message;
        this.type = type;
        this.setDefaultImage();
    }

    public TrayIconNotificationHandler(String title, String message, TrayIcon.MessageType type) {
        this.title = title;
        this.message = message;
        this.type = type;
        this.setDefaultImage();
    }

    private void setDefaultImage() {
        try {
            this.image = ImageIO.read(ClassLoader.getSystemClassLoader().getResourceAsStream("images/icon_anf.png"));
        }
        catch (IOException e) {
            log.error("error cargando la imagen del tray notification", (Throwable)e);
        }
    }

    public TrayIconNotificationHandler(String title, String message) {
        this.title = title;
        this.message = message;
        this.setDefaultImage();
    }

    public static void removeTray() {
        if (SystemTray.isSupported()) {
            SystemTray systemTray = SystemTray.getSystemTray();
        }
    }

    public void displayTray() throws AWTException, MalformedURLException {
        if (SystemTray.isSupported()) {
            SystemTray tray = SystemTray.getSystemTray();
            if (this.image != null) {
                this.image.flush();
            }
            if (trayIcon == null) {
                trayIcon = new TrayIcon(this.image, this.toolTip);
                trayIcon.setImageAutoSize(true);
                tray.add(trayIcon);
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    Thread thread = new Thread(() -> {
                        try {
                            tray.remove(trayIcon);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    });
                    thread.setDaemon(true);
                    thread.start();
                }));
            }
            if (trayIcon.getToolTip() != null && !trayIcon.getToolTip().isEmpty() && this.toolTip != null && !this.toolTip.isEmpty()) {
                trayIcon.setToolTip(this.toolTip);
            }
            log.info("displaying notification caption: {}, message: {}, type: {}", (Object)this.caption, (Object)this.message, (Object)this.type);
            trayIcon.displayMessage(this.caption, this.message, this.type);
        }
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getToolTip() {
        return this.toolTip;
    }

    public void setToolTip(String toolTip) {
        this.toolTip = toolTip;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public TrayIcon.MessageType getType() {
        return this.type;
    }

    public void setType(TrayIcon.MessageType type) {
        this.type = type;
    }

    public static TrayIcon getTrayIcon() {
        return trayIcon;
    }
}

