/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.ui.message.impl;

import com.anf.cryptotoken.ui.message.MessageController;
import com.anf.cryptotoken.ui.message.MessageResult;
import com.anf.utils.OSUtils;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class MessageSwingController
implements MessageController {
    public JFrame getFrame() {
        JFrame f = new JFrame();
        f.setAlwaysOnTop(true);
        f.setUndecorated(true);
        if (!OSUtils.isLinux()) {
            f.setOpacity(0.0f);
        }
        f.setLocationRelativeTo(null);
        f.setSize(80, 80);
        f.setFocusable(true);
        f.requestFocus();
        f.setVisible(true);
        return f;
    }

    @Override
    public MessageResult showInfoMessage(Object message, String title) {
        JFrame f = this.getFrame();
        JOptionPane.showMessageDialog(f, message, title, 1);
        f.dispose();
        return MessageResult.OK;
    }

    @Override
    public MessageResult showErrorMessage(Object message, String title) {
        JFrame f = this.getFrame();
        JOptionPane.showMessageDialog(f, message, title, 0);
        f.dispose();
        return MessageResult.OK;
    }

    @Override
    public MessageResult showConfirmMessage(Object header, String title) {
        JFrame f = this.getFrame();
        int res = JOptionPane.showConfirmDialog(f, header.toString(), title, 0);
        f.dispose();
        MessageResult result = MessageResult.CANCEL;
        switch (res) {
            case 0: {
                result = MessageResult.YES;
                break;
            }
            case 1: {
                result = MessageResult.NO;
                break;
            }
        }
        return result;
    }
}

