/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.ui.keyboard.password;

import com.anf.cryptotoken.ui.keyboard.password.PasswordValidation;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class PasswordPolicy {
    public static PasswordValidation validatePassword(String pass) {
        if (pass.length() < 8) {
            return new PasswordValidation(false, "PASSWORD_TOO_SHORT");
        }
        if (pass.length() > 36) {
            return new PasswordValidation(false, "PASSWORD_TOO_LONG");
        }
        if (pass.equals("12341234") || pass.equals("12345678") || pass.equals("12121212") || pass.equals("abcd1234") || pass.equals("1234abcd") || pass.equals("abcdabcd") || pass.equals("aaaa1111") || pass.equals("bbbb1111") || pass.equals("1111aaaa") || pass.equals("1111bbbb") || pass.equals("0000aaaa") || pass.equals("0000bbbb") || pass.equals("a1a2a3a4") || pass.equals("b1b2b3b4") || pass.contains("1234") || PasswordPolicy.repeatedChars(pass)) {
            return new PasswordValidation(false, "PASSWORD_NAME_INVALID");
        }
        if (!PasswordPolicy.minimalAcceptablePassword(pass)) {
            return new PasswordValidation(false, "PASSWORD_CHARACTER_COUNT");
        }
        return new PasswordValidation();
    }

    private static boolean minimalAcceptablePassword(String pass) {
        int letters = 0;
        int numbers = 0;
        int special = 0;
        char[] chars = pass.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (Character.isLetter(chars[i])) {
                ++letters;
                continue;
            }
            if (Character.isDigit(chars[i])) {
                ++numbers;
                continue;
            }
            ++special;
        }
        return letters + numbers + special >= 8 && letters > 0 && numbers > 0;
    }

    private static boolean repeatedChars(String pass) {
        char[] characters = pass.toCharArray();
        HashMap<Character, Integer> charMap = new HashMap<Character, Integer>();
        char[] cArray = characters;
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character ch = Character.valueOf(cArray[i]);
            if (charMap.containsKey(ch)) {
                charMap.put(ch, (Integer)charMap.get(ch) + 1);
                continue;
            }
            charMap.put(ch, 1);
        }
        int countRepeatedBiggerThan2 = 0;
        Set set = charMap.entrySet();
        for (Map.Entry entry : set) {
            if ((Integer)entry.getValue() <= 2) continue;
            ++countRepeatedBiggerThan2;
        }
        return countRepeatedBiggerThan2 > 1;
    }
}

