/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.ui.keyboard.keys;

import com.anf.cryptotoken.ui.keyboard.keys.CharacterKey;
import com.anf.cryptotoken.ui.keyboard.keys.ExtendedKey;
import com.anf.cryptotoken.ui.keyboard.keys.KeyController;
import com.anf.cryptotoken.ui.keyboard.keys.LetterKey;
import com.anf.cryptotoken.ui.keyboard.keys.NumberKey;
import com.anf.cryptotoken.ui.keyboard.keys.SpaceBarKey;
import com.anf.cryptotoken.ui.keyboard.keys.SymbolKey;
import java.util.Collections;
import java.util.LinkedList;
import javafx.scene.layout.HBox;

public class KeySetGenerator {
    private static final String baseImgResources = "images/keyboard";
    private static final String lettersResources = "images/keyboard/letters";
    private static final String numbersResources = "images/keyboard/numbers";
    private static final String symbolsResources = "images/keyboard/symbols";
    private static final String actionsResources = "images/keyboard/actions";
    private static final String pinResources = "images/keyboard/pin";
    private HBox topBox;
    private HBox centerBox;
    private HBox bottomBox;
    private HBox actionsBox;
    LinkedList<CharacterKey> letterKeys;
    LinkedList<CharacterKey> letterUpperCaseKeys;
    LinkedList<CharacterKey> numberAndSymbolKeys;
    ExtendedKey lettersSwitcher;
    SpaceBarKey space;
    ExtendedKey numSymbolsSwitcher;
    ExtendedKey actionKey;
    ExtendedKey returnKey;
    ExtendedKey deleteKey;
    ExtendedKey showPinKey;
    ExtendedKey soundKey;
    ExtendedKey closeKey;
    ExtendedKey helpKey;
    KeyController controller;

    public KeySetGenerator(KeyController controller, HBox topBox, HBox centerBox, HBox bottomBox, HBox actionsBox) {
        this.topBox = topBox;
        this.centerBox = centerBox;
        this.bottomBox = bottomBox;
        this.actionsBox = actionsBox;
        this.controller = controller;
        this.createActions();
        this.createLetters(true);
        this.createLetters(false);
        this.createNumbersAndSymbols();
    }

    public void createActions() {
        this.lettersSwitcher = new ExtendedKey("images/keyboard/actions/abc_lower.png", 3, 1);
        this.actionsBox.getChildren().add((Object)this.lettersSwitcher.getButton());
        this.space = new SpaceBarKey("images/keyboard/actions/spacebar.png");
        this.actionsBox.getChildren().add((Object)this.space.getButton());
        this.numSymbolsSwitcher = new ExtendedKey("images/keyboard/actions/numsymb.png", 3, 1);
        this.actionsBox.getChildren().add((Object)this.numSymbolsSwitcher.getButton());
        this.actionKey = new ExtendedKey("images/keyboard/actions/action.png", 3, 1);
        this.actionsBox.getChildren().add((Object)this.actionKey.getButton());
    }

    public void createLetters(boolean upperCase) {
        LinkedList<LetterKey> keys = new LinkedList<LetterKey>();
        String letters = "abcdefghijklmnopqrstuvwxyz";
        for (int i = 0; i < letters.length(); ++i) {
            char c = letters.charAt(i);
            String res = "images/keyboard/letters/" + c + ".png";
            LetterKey key = new LetterKey(res, upperCase ? Character.toUpperCase(c) : c);
            key.setController(this.controller);
            if (!upperCase) {
                key.translateY(1);
            }
            keys.add(key);
        }
        String res = "images/keyboard/letters/enye.png";
        LetterKey key = new LetterKey(res, upperCase ? (char)'\u00d1' : '\u00f1');
        key.setController(this.controller);
        if (!upperCase) {
            key.translateY(1);
        }
        keys.add(key);
        if (upperCase) {
            this.letterUpperCaseKeys = keys;
        } else {
            this.letterKeys = keys;
        }
    }

    public void createNumbersAndSymbols() {
        CharacterKey key;
        String res;
        int i;
        LinkedList<CharacterKey> keys = new LinkedList<CharacterKey>();
        String numbers = "0123456789";
        for (i = 0; i < numbers.length(); ++i) {
            char c = numbers.charAt(i);
            res = "images/keyboard/numbers/" + c + ".png";
            key = new NumberKey(res, c - 48);
            key.setController(this.controller);
            keys.add(key);
        }
        i = 0;
        while (i++ < 30) {
            String id = "simb_" + i;
            res = "images/keyboard/symbols/" + id + ".png";
            try {
                key = new SymbolKey(res, KeySetGenerator.defineSymbol(id).charAt(0));
                key.setController(this.controller);
                keys.add(key);
            }
            catch (Exception exception) {}
        }
        this.numberAndSymbolKeys = keys;
    }

    private static String defineSymbol(String tecla) {
        if (tecla.equalsIgnoreCase("simb_1")) {
            return "{";
        }
        if (tecla.equalsIgnoreCase("simb_2")) {
            return "}";
        }
        if (tecla.equalsIgnoreCase("simb_3")) {
            return "\u00bf";
        }
        if (tecla.equalsIgnoreCase("simb_4")) {
            return "?";
        }
        if (tecla.equalsIgnoreCase("simb_5")) {
            return "&";
        }
        if (tecla.equalsIgnoreCase("simb_7")) {
            return "\u00aa";
        }
        if (tecla.equalsIgnoreCase("simb_8")) {
            return "_";
        }
        if (tecla.equalsIgnoreCase("simb_10")) {
            return "%";
        }
        if (tecla.equalsIgnoreCase("simb_11")) {
            return "$";
        }
        if (tecla.equalsIgnoreCase("simb_12")) {
            return "/";
        }
        if (tecla.equalsIgnoreCase("simb_13")) {
            return ";";
        }
        if (tecla.equalsIgnoreCase("simb_14")) {
            return ",";
        }
        if (tecla.equalsIgnoreCase("simb_15")) {
            return "*";
        }
        if (tecla.equalsIgnoreCase("simb_16")) {
            return "#";
        }
        if (tecla.equalsIgnoreCase("simb_17")) {
            return ".";
        }
        if (tecla.equalsIgnoreCase("simb_18")) {
            return ":";
        }
        if (tecla.equalsIgnoreCase("simb_19")) {
            return "+";
        }
        if (tecla.equalsIgnoreCase("simb_20")) {
            return "-";
        }
        if (tecla.equalsIgnoreCase("simb_21")) {
            return "!";
        }
        if (tecla.equalsIgnoreCase("simb_22")) {
            return "@";
        }
        return "";
    }

    private void fillWithKeys(LinkedList<CharacterKey> keys, int top, int center, int bottom) {
        int i;
        Collections.shuffle(keys);
        this.clearBoxes();
        for (i = 0; i < top; ++i) {
            if (keys.isEmpty()) continue;
            this.topBox.getChildren().add((Object)keys.removeFirst().getButton());
        }
        for (i = 0; i < center; ++i) {
            if (keys.isEmpty()) continue;
            this.centerBox.getChildren().add((Object)keys.removeFirst().getButton());
        }
        for (i = 0; i < bottom; ++i) {
            if (keys.isEmpty()) continue;
            this.bottomBox.getChildren().add((Object)keys.removeFirst().getButton());
        }
    }

    private void clearBoxes() {
        this.topBox.getChildren().clear();
        this.centerBox.getChildren().clear();
        this.bottomBox.getChildren().clear();
    }

    public HBox getTopBox() {
        return this.topBox;
    }

    public void setTopBox(HBox topBox) {
        this.topBox = topBox;
    }

    public HBox getCenterBox() {
        return this.centerBox;
    }

    public void setCenterBox(HBox centerBox) {
        this.centerBox = centerBox;
    }

    public HBox getBottomBox() {
        return this.bottomBox;
    }

    public void setBottomBox(HBox bottomBox) {
        this.bottomBox = bottomBox;
    }

    public ExtendedKey getLettersSwitcher() {
        return this.lettersSwitcher;
    }

    public SpaceBarKey getSpace() {
        return this.space;
    }

    public ExtendedKey getActionKey() {
        return this.actionKey;
    }

    public ExtendedKey getNumSymbolsSwitcher() {
        return this.numSymbolsSwitcher;
    }

    public void switchLetters(boolean upperCase) {
        String name = "abc_lower.png";
        if (upperCase) {
            name = "abc_upper.png";
        }
        this.lettersSwitcher.updateImage("images/keyboard/actions/" + name);
        LinkedList<CharacterKey> keys = upperCase ? this.letterUpperCaseKeys : this.letterKeys;
        this.fillWithKeys(new LinkedList<CharacterKey>(keys), 10, 9, 8);
    }

    public void switchNumbers() {
        this.fillWithKeys(new LinkedList<CharacterKey>(this.numberAndSymbolKeys), 10, 10, 10);
    }

    public void createPinSection(HBox pinLeftBox, HBox pinRightBox, HBox pinBox) {
        this.returnKey = new ExtendedKey("images/keyboard/pin/return.png", 3, 1);
        this.returnKey.setController(this.controller);
        pinLeftBox.getChildren().add(0, (Object)this.returnKey.getButton());
        this.deleteKey = new ExtendedKey("images/keyboard/pin/delete.png", 3, 1);
        this.deleteKey.setController(this.controller);
        pinRightBox.getChildren().add((Object)this.deleteKey.getButton());
        this.showPinKey = new ExtendedKey("images/keyboard/pin/showpin.png", 3, 1);
        this.showPinKey.setController(this.controller);
        pinRightBox.getChildren().add((Object)this.showPinKey.getButton());
    }

    public void createTopSection(HBox soundBox, HBox helpBox, HBox closeBox) {
        this.soundKey = new ExtendedKey("images/keyboard/sound.png", 3, 1);
        this.soundKey.setController(this.controller);
        soundBox.getChildren().add(0, (Object)this.soundKey.getButton());
        this.closeKey = this.createCloseKey();
        this.closeKey.setController(this.controller);
        closeBox.getChildren().add(0, (Object)this.closeKey.getButton());
        this.helpKey = new ExtendedKey("images/keyboard/help.png", 3, 1);
        this.helpKey.setController(this.controller);
        helpBox.getChildren().add(0, (Object)this.helpKey.getButton());
    }

    public ExtendedKey createCloseKey() {
        return new ExtendedKey("images/keyboard/close.png", 3, 1);
    }

    public LinkedList<CharacterKey> getLetterKeys() {
        return this.letterKeys;
    }

    public LinkedList<CharacterKey> getLetterUpperCaseKeys() {
        return this.letterUpperCaseKeys;
    }

    public LinkedList<CharacterKey> getNumberAndSymbolKeys() {
        return this.numberAndSymbolKeys;
    }

    public ExtendedKey getReturnKey() {
        return this.returnKey;
    }

    public void setReturnKey(ExtendedKey returnKey) {
        this.returnKey = returnKey;
    }

    public ExtendedKey getDeleteKey() {
        return this.deleteKey;
    }

    public void setDeleteKey(ExtendedKey deleteKey) {
        this.deleteKey = deleteKey;
    }

    public ExtendedKey getShowPinKey() {
        return this.showPinKey;
    }

    public void setShowPinKey(ExtendedKey showPinKey) {
        this.showPinKey = showPinKey;
    }

    public ExtendedKey getSoundKey() {
        return this.soundKey;
    }

    public void setSoundKey(ExtendedKey soundKey) {
        this.soundKey = soundKey;
    }

    public ExtendedKey getCloseKey() {
        return this.closeKey;
    }

    public void setCloseKey(ExtendedKey closeKey) {
        this.closeKey = closeKey;
    }

    public ExtendedKey getHelpKey() {
        return this.helpKey;
    }

    public void setHelpKey(ExtendedKey helpKey) {
        this.helpKey = helpKey;
    }

    public KeyController getController() {
        return this.controller;
    }

    public void setController(KeyController controller) {
        this.controller = controller;
    }

    public void setLettersSwitcher(ExtendedKey lettersSwitcher) {
        this.lettersSwitcher = lettersSwitcher;
    }

    public void setSpace(SpaceBarKey space) {
        this.space = space;
    }

    public void setNumSymbolsSwitcher(ExtendedKey numSymbolsSwitcher) {
        this.numSymbolsSwitcher = numSymbolsSwitcher;
    }

    public void setActionKey(ExtendedKey actionKey) {
        this.actionKey = actionKey;
    }
}

