/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.ui.keyboard.keys;

import com.anf.cryptotoken.ui.keyboard.keys.GenericKey;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelReader;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;

public class ExtendedKey
extends GenericKey {
    protected int xpositions;
    protected int ypositions;
    protected int xpos = 0;
    protected int ypos = 0;
    protected boolean xtranslation = true;

    public ExtendedKey(String resource, int xpositions, int ypositions) {
        super(resource);
        this.xpositions = xpositions;
        this.ypositions = ypositions;
        this.setWidth(this.image.getWidth() / (double)xpositions);
        this.setHeight(this.image.getHeight() / (double)ypositions);
        this.getButton().setContentDisplay(ContentDisplay.CENTER);
        this.getButton().setWrapText(false);
        this.getButton().setEllipsisString("");
        this.getButton().setFont(Font.font((String)Font.getDefault().getFamily(), (FontWeight)FontWeight.BOLD, (double)Font.getDefault().getSize()));
        this.getButton().setTextFill((Paint)Color.web((String)"#535353"));
        this.translate(this.xpos, this.ypos);
        this.update();
        this.button.setOnMouseEntered(event -> {
            if (this.xtranslation) {
                this.translateX(1);
            } else {
                this.translateY(1);
            }
        });
        this.button.setOnMouseExited(event -> {
            if (this.xtranslation) {
                this.translateX(0);
            } else {
                this.translateY(0);
            }
        });
        this.button.setOnMousePressed(event -> {
            if (this.xtranslation) {
                this.translateX(2);
            } else {
                this.translateY(2);
            }
        });
        this.button.setOnMouseReleased(event -> {
            if (this.button.contains(new Point2D(event.getX(), event.getY()))) {
                if (this.xtranslation) {
                    this.translateX(1);
                } else {
                    this.translateY(1);
                }
            } else if (this.xtranslation) {
                this.translateX(0);
            } else {
                this.translateY(0);
            }
        });
    }

    public void setText(String text) {
        this.getButton().setText(text);
        double withFontScaleFactor = 1.3;
        double size = Math.min(withFontScaleFactor * this.getButton().getPrefWidth() / (double)text.length(), Font.getDefault().getSize());
        this.getButton().setFont(Font.font((String)Font.getDefault().getFamily(), (FontWeight)FontWeight.BOLD, (double)size));
    }

    @Override
    public void updateImage(String resource) {
        super.updateImage(resource);
        if (this.xpositions > 0) {
            this.setWidth(this.image.getWidth() / (double)this.xpositions);
        }
        if (this.ypositions > 0) {
            this.setHeight(this.image.getHeight() / (double)this.ypositions);
        }
    }

    public void translateX(int pos) {
        this.xpos = pos % this.xpositions;
        this.update();
    }

    public void translateY(int pos) {
        this.ypos = pos % this.ypositions;
        this.update();
    }

    public void translate(int xpos, int ypos) {
        this.xpos = xpos % this.xpositions;
        this.ypos = ypos % this.ypositions;
        this.update();
    }

    protected void update() {
        PixelReader reader = this.image.getPixelReader();
        WritableImage img = new WritableImage(reader, this.xpos * (int)this.getWidth(), this.ypos * (int)this.getHeight(), (int)this.getWidth(), (int)this.getHeight());
        this.button.setGraphic((Node)new ImageView((Image)img));
    }
}

