/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.ui.keyboard.handler;

import com.anf.cryptotoken.api.tkmanager.exception.ANFPrivateKeyException;
import com.anf.cryptotoken.api.tkmanager.exception.NOPINException;
import com.anf.cryptotoken.auth.PasswordContainer;
import com.anf.cryptotoken.auth.PasswordContainerFactory;
import com.anf.cryptotoken.config.Confis;
import com.anf.cryptotoken.io.LockerImpl;
import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.tkmanager.controller.AuthHandler;
import com.anf.cryptotoken.tkmanager.dto.LoginParams;
import com.anf.cryptotoken.tkmanager.dto.LoginResult;
import com.anf.cryptotoken.tkmanager.dto.PrivateKeyLogin;
import com.anf.cryptotoken.ui.keyboard.KeyBoard;
import com.anf.cryptotoken.ui.keyboard.behaviour.KeyBoardBehaviour;
import com.anf.cryptotoken.ui.keyboard.behaviour.impl.PasswordCounterBehaviour;
import com.anf.cryptotoken.ui.keyboard.handler.auth.AuthType;
import com.anf.cryptotoken.ui.keyboard.handler.auth.PINConfig;
import com.anf.cryptotoken.utils.DatosPersonales;
import com.anf.utils.OSUtils;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import org.apache.logging.log4j.Level;

public class KeyBoardHandler {
    private static final Logger log = Logger.getLogger(KeyBoardHandler.class);
    private static boolean showMessages = true;
    private static boolean useCheck = false;
    private static String checkText = "";
    private static boolean checkValue = false;
    private static TreeMap<AuthType, Boolean> lowSecurity = new TreeMap();
    private static TreeMap<AuthType, Boolean> hightSecurity = new TreeMap();
    private static TreeMap<AuthType, Boolean> security = lowSecurity;
    public static boolean erase;
    private static Map<String, PasswordContainer> passwords;
    private static LinkedList<PasswordContainer> availables;
    private static TreeSet<String> lockedDevices;
    private static int session;
    private static boolean useVirtualKeyboard;
    private static PINConfig pinConfig;
    private static ArrayList<Eraser> erasers;

    public static int newKeyBoardSession() {
        return ++session;
    }

    public static int getSession() {
        return session;
    }

    public static int removeAllInSession(int ses) {
        LockerImpl locker = LockerImpl.get((String)KeyBoardHandler.class.toString());
        int count = 0;
        try {
            count = (Integer)locker.lock(ignore -> {
                int c = 0;
                for (int i = 0; i < erasers.size(); ++i) {
                    if (KeyBoardHandler.erasers.get((int)i).session != ses) continue;
                    Eraser e = erasers.remove(i--);
                    KeyBoardHandler.remove(e.id);
                    ++c;
                }
                return c;
            }, (Object)ses);
        }
        catch (Throwable e) {
            log.error((Object)e);
        }
        return count;
    }

    public static <LOGINRESULT> LOGINRESULT checkPassword(String id, String title, Function<PrivateKeyLogin, LoginResult<LOGINRESULT>> loginAction, boolean doublePIN, boolean isPUK, AuthHandler handler, X509Certificate[] certChain, int start, int maxTries, Function<Integer, Integer> wrongPIN) throws Throwable {
        if (!showMessages) {
            KeyBoardHandler.warnDisabledMessages();
            throw new NOPINException();
        }
        if (!lockedDevices.contains(id)) {
            PasswordContainer container = KeyBoardHandler.get(id);
            if (container != null) {
                return loginAction.apply(new PrivateKeyLogin(container.getPassword().toCharArray())).getResult();
            }
            LoginParams loginParams = new LoginParams(id, title, handler, doublePIN, isPUK, certChain);
            DIALOG_TYPE type = DIALOG_TYPE.SIMPLE;
            if (certChain != null) {
                type = DIALOG_TYPE.CERT_INFO;
            }
            PasswordCounterBehaviour<LOGINRESULT> boardBehaviour = new PasswordCounterBehaviour<LOGINRESULT>(loginAction, wrongPIN, maxTries, start, id);
            LoginResult<LOGINRESULT> result = KeyBoardHandler.callDialog(type, loginParams, boardBehaviour);
            return result.getResult();
        }
        return null;
    }

    private static void warnDisabledMessages() {
        log.warn((Object)"visual messages is disabled");
    }

    public static void setLowSecurity(boolean lowSec) {
        security = lowSec ? lowSecurity : hightSecurity;
    }

    public static boolean isLowSecurity() {
        return security == lowSecurity;
    }

    public static boolean isHightSecurity() {
        return security == hightSecurity;
    }

    public static boolean isAvailable(AuthType type) {
        Boolean accepted = security.get((Object)type);
        return accepted != null ? accepted : false;
    }

    public static char[] getPassword(String id, String title, boolean doublePIN, boolean isPUK, AuthHandler handler) throws NOPINException {
        if (!showMessages) {
            KeyBoardHandler.warnDisabledMessages();
            throw new NOPINException();
        }
        PasswordContainer container = KeyBoardHandler.get(id);
        if (container != null) {
            return container.getPassword().toCharArray();
        }
        LoginParams loginParams = new LoginParams(id, title, handler, doublePIN, isPUK);
        PasswordCounterBehaviour boardBehaviour = new PasswordCounterBehaviour(login -> {
            if (login.getError() != null) {
                return new LoginResult(login.getError());
            }
            PasswordContainer c = PasswordContainerFactory.getContainer();
            c.setPassword(new String(login.getPin()));
            return new LoginResult<PasswordContainer>(c);
        }, null, 1, 0, id);
        LoginResult result = KeyBoardHandler.callDialog(DIALOG_TYPE.SIMPLE, loginParams, boardBehaviour);
        if (result.getError() != null) {
            throw new ANFPrivateKeyException(result.getError());
        }
        PasswordContainer pjni = (PasswordContainer)result.getResult();
        if (pjni == null) {
            throw new NOPINException();
        }
        return pjni.getPassword().toCharArray();
    }

    public static JFrame getFrame() {
        JFrame f = new JFrame();
        f.setAlwaysOnTop(true);
        f.setUndecorated(true);
        if (!OSUtils.isLinux()) {
            f.setOpacity(0.0f);
        }
        f.setLocationRelativeTo(null);
        f.setSize(80, 80);
        f.setFocusable(true);
        f.requestFocus();
        f.setVisible(true);
        return f;
    }

    public static void msg(Object message) {
        if (showMessages) {
            JFrame f = KeyBoardHandler.getFrame();
            JOptionPane.showMessageDialog(f, message);
            f.dispose();
        } else {
            KeyBoardHandler.warnDisabledMessages();
        }
    }

    public static int msgConfirm(Object message, String title, int option) {
        if (showMessages) {
            JFrame f = KeyBoardHandler.getFrame();
            int res = JOptionPane.showConfirmDialog(f, message, title, option);
            f.dispose();
            return res;
        }
        KeyBoardHandler.warnDisabledMessages();
        return -1;
    }

    public static void msg(Object message, String title, int type) {
        if (showMessages) {
            JFrame f = KeyBoardHandler.getFrame();
            JOptionPane.showMessageDialog(f, message, title, type);
            f.dispose();
        } else {
            KeyBoardHandler.warnDisabledMessages();
        }
    }

    public static void msgOption(Object message, String title, int type, int sel, JButton ... options) {
        if (showMessages) {
            JFrame f = KeyBoardHandler.getFrame();
            ActionListener closeListener = e -> f.dispose();
            if (options == null || options.length == 0) {
                JButton ok = new JButton("OK");
                options = new JButton[]{ok};
            }
            if (sel < 0 || sel > options.length) {
                sel = 0;
            }
            for (int i = 0; i < options.length; ++i) {
                options[i].addActionListener(closeListener);
            }
            JOptionPane.showOptionDialog(f, message, title, -1, type, null, options, sel < options.length ? options[sel] : null);
            f.dispose();
        } else {
            KeyBoardHandler.warnDisabledMessages();
        }
    }

    public static void remove(String id) {
        try (LockerImpl locker = LockerImpl.lock((String)KeyBoardHandler.class.toString());){
            PasswordContainer p = passwords.remove(id);
            if (p != null) {
                log.info((Object)("eliminado contenedor de password con id:" + id));
                availables.add(p);
            }
        }
        catch (Throwable e) {
            log.error((Object)e);
        }
    }

    public static PasswordContainer get(String id) {
        PasswordContainer passwordContainer;
        block8: {
            LockerImpl locker = LockerImpl.get((String)KeyBoardHandler.class.toString()).acquireLock();
            try {
                log.info((Object)("cargando contenedor de password " + id));
                PasswordContainer p = passwords.get(id);
                log.debug((Object)("contenedor de password " + id + " cargado " + p != null ? 1 : 0));
                passwordContainer = p;
                if (locker == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (locker != null) {
                        try {
                            locker.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    log.error((Object)e);
                    return null;
                }
            }
            locker.close();
        }
        return passwordContainer;
    }

    public static void add(String id, PasswordContainer container) {
        try (LockerImpl locker = LockerImpl.get((String)KeyBoardHandler.class.toString()).acquireLock();){
            if (id != null && container != null) {
                passwords.put(id, container);
                log.debug((Object)("creado contenedor de password con id " + id));
            }
            KeyBoardHandler.addEraser(id);
        }
        catch (Throwable e) {
            log.error((Object)e);
        }
    }

    public static char[] getPasswordForCertificates(String id, X509Certificate[] certChain, String title, boolean doublePIN, boolean isPUK, AuthHandler handler) throws NOPINException {
        if (!showMessages) {
            log.info(new Object[]{"visual messages is disabled", Level.WARN});
            throw new NOPINException();
        }
        PasswordContainer container = KeyBoardHandler.get(id);
        if (container != null) {
            return container.getPassword().toCharArray();
        }
        LoginParams loginParams = new LoginParams(id, title, handler, doublePIN, isPUK, certChain);
        PasswordCounterBehaviour boardBehaviour = new PasswordCounterBehaviour(LoginResult::new, null, 1, 0, id);
        LoginResult result = KeyBoardHandler.callDialog(DIALOG_TYPE.CERT_INFO, loginParams, boardBehaviour);
        if (result.getError() != null) {
            throw new ANFPrivateKeyException(result.getError());
        }
        return ((PrivateKeyLogin)result.getResult()).getPin();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <LOGINRESULT> LoginResult<LOGINRESULT> callDialog(DIALOG_TYPE type, LoginParams loginParams, KeyBoardBehaviour<LOGINRESULT> boardBehaviour) throws NOPINException {
        LoginResult<LOGINRESULT> result = null;
        KeyBoard keyBoard = new KeyBoard();
        boolean ok = false;
        try (LockerImpl locker = LockerImpl.lock((String)KeyBoardHandler.class.toString());){
            String title = loginParams.getTitle();
            PasswordContainer passwordContainer = !availables.isEmpty() ? availables.removeFirst() : PasswordContainerFactory.getContainer();
            passwordContainer.reset();
            switch (type) {
                case SIMPLE: {
                    try {
                        if (!useVirtualKeyboard) {
                            result = KeyBoardHandler.showPasswordDialog(passwordContainer, loginParams, boardBehaviour);
                            break;
                        }
                        if (loginParams.isPuk()) {
                            result = keyBoard.showPUKKeyBoard(passwordContainer, loginParams, boardBehaviour);
                            break;
                        }
                        result = keyBoard.showPINKeyBoard(passwordContainer, loginParams, boardBehaviour);
                    }
                    catch (Exception e) {
                        log.error((Object)e);
                    }
                    break;
                }
                case CERT_INFO: {
                    X509Certificate[] chain = loginParams.getChain();
                    if (chain == null || chain.length <= 0) break;
                    try {
                        if (!useVirtualKeyboard) {
                            DatosPersonales dp = new DatosPersonales(chain[0].getSubjectX500Principal());
                            String certTitle = title + "\n" + dp.getCN() + ", " + dp.getOU() + ", SN:" + chain[0].getSerialNumber();
                            loginParams.setTitle(certTitle);
                            result = KeyBoardHandler.showPasswordDialog(passwordContainer, loginParams, boardBehaviour);
                            break;
                        }
                        result = keyBoard.showCertKeyBoard(passwordContainer, loginParams, boardBehaviour);
                    }
                    catch (Exception e) {
                        log.error((Object)e);
                    }
                    break;
                }
            }
            if (!useVirtualKeyboard || result != null && result.getError() == null) {
                String id = loginParams.getId();
                KeyBoardHandler.add(id, passwordContainer);
                LoginResult<LOGINRESULT> loginResult = result;
                return loginResult;
            }
            availables.add(passwordContainer);
            throw new NOPINException();
        }
        catch (NOPINException e) {
            throw e;
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new NOPINException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <LOGINRESULT> LoginResult<LOGINRESULT> showPasswordDialog(PasswordContainer pass, LoginParams loginParams, KeyBoardBehaviour<LOGINRESULT> boardBehaviour) throws NOPINException {
        LoginResult<LOGINRESULT> loginResult = null;
        JFrame f = KeyBoardHandler.getFrame();
        try {
            boolean ok = false;
            String title = loginParams.getTitle();
            String result = KeyBoardHandler.getPasswordFromDialog(title, f);
            if (loginParams.isDoublePin()) {
                int attempts = 3;
                while (!ok && attempts-- > 0) {
                    String result2 = KeyBoardHandler.getPasswordFromDialog(title, f);
                    if (!result.equals(result2)) continue;
                    ok = true;
                }
                if (!ok) {
                    KeyBoardHandler.msg(Confis.get().getString("MAX_TRIES", new Object[0]));
                }
            } else {
                ok = true;
            }
            if (ok) {
                pass.reset();
                pass.setPassword(result);
                boolean res = boardBehaviour.accept(new PrivateKeyLogin(result.toCharArray()), message -> KeyBoardHandler.msg(message));
                loginResult = boardBehaviour.getResult();
            }
        }
        finally {
            f.dispose();
        }
        return loginResult;
    }

    private static String getPasswordFromDialog(String title, JFrame f) throws NOPINException {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(2, 1));
        JLabel label = new JLabel(title);
        JPasswordField pass = new JPasswordField(10);
        panel.add(label);
        panel.add(pass);
        pass.setFocusable(true);
        pass.requestFocus();
        pass.requestFocusInWindow();
        Object[] options = new String[]{"OK", "Cancel"};
        int option = JOptionPane.showOptionDialog(f, panel, Confis.get().getString("192", new Object[0]), 1, -1, null, options, options[0]);
        if (option == 0) {
            char[] password = pass.getPassword();
            return new String(password);
        }
        KeyBoardHandler.msg(Confis.get().getString("33", new Object[0]));
        throw new NOPINException();
    }

    public static void setPINConfig(PINConfig pIN_CONFIG) {
        pinConfig = pIN_CONFIG;
    }

    public static PINConfig getPinConfig() {
        return pinConfig;
    }

    private static void addEraser(String id) {
        Eraser e = null;
        switch (pinConfig) {
            case DONT_ERASE: {
                e = new Eraser(id, 0);
                break;
            }
            case ERASE_AFTER_SECS: {
                e = new Eraser(id);
                break;
            }
            case ERASE_INMEDIATLY: {
                KeyBoardHandler.remove(id);
            }
        }
        if (e != null) {
            log.info((Object)("creado contenedor de password con id:" + id));
            erasers.add(e);
            e.start();
        }
    }

    public static void setCheck(String text) {
        useCheck = text != null;
        checkText = text;
        checkValue = false;
    }

    public static boolean checkValue() {
        return checkValue;
    }

    public static boolean isUseCheck() {
        return useCheck;
    }

    public static String getCheckText() {
        return checkText;
    }

    public static void setCheckValue(boolean checkValue) {
        KeyBoardHandler.checkValue = checkValue;
    }

    public static void setShowMessages(boolean b) {
        showMessages = b;
    }

    public static boolean isShowMessages() {
        return showMessages;
    }

    public static void setUseVirtualKeyboard(boolean useVirtualKeyboard) {
        if (!OSUtils.isLinux()) {
            throw new RuntimeException("this is for linux and you are not in linux");
        }
        KeyBoardHandler.useVirtualKeyboard = useVirtualKeyboard;
    }

    static {
        lowSecurity.put(AuthType.PIN, true);
        lowSecurity.put(AuthType.FINGER_PRINT, true);
        hightSecurity.put(AuthType.BOTH, true);
        erase = true;
        passwords = new TreeMap<String, PasswordContainer>();
        availables = new LinkedList();
        lockedDevices = new TreeSet();
        session = 0;
        useVirtualKeyboard = true;
        pinConfig = PINConfig.ERASE_AFTER_SECS;
        erasers = new ArrayList();
    }

    private static enum DIALOG_TYPE {
        SIMPLE,
        CERT_INFO,
        SIGN_DOCS;

    }

    private static class Eraser
    extends Thread {
        private String id;
        private int session = session;
        private int seconds = 20;
        private static final int DEFAULT_SECONDS = 20;

        public Eraser(String id) {
            this.id = id;
        }

        public Eraser(String id, int seconds) {
            this.id = id;
            this.seconds = seconds;
        }

        @Override
        public void run() {
            if (this.seconds > 0) {
                try {
                    TimeUnit.SECONDS.sleep(this.seconds);
                }
                catch (InterruptedException e) {
                    log.error((Object)e);
                }
                KeyBoardHandler.remove(this.id);
            }
        }
    }
}

