/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.ui.keyboard.behaviour.impl;

import com.anf.cryptotoken.api.tkmanager.exception.ANFPrivateKeyException;
import com.anf.cryptotoken.api.tkmanager.exception.PINLOCKEDException;
import com.anf.cryptotoken.config.Confis;
import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.tkmanager.dto.LoginResult;
import com.anf.cryptotoken.tkmanager.dto.PrivateKeyLogin;
import com.anf.cryptotoken.ui.keyboard.behaviour.KeyBoardBehaviour;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class PasswordCounterBehaviour<LOGINRESULT>
implements KeyBoardBehaviour<LOGINRESULT> {
    private static final Logger log = Logger.getLogger(PasswordCounterBehaviour.class);
    Function<PrivateKeyLogin, LoginResult<LOGINRESULT>> loginAction;
    Function<Integer, Integer> wrongPIN;
    LoginResult<LOGINRESULT> result;
    int iterator = 0;
    int maxTries;
    int start;
    String id;
    Supplier<Boolean> restartOnClose = () -> false;
    Supplier<Boolean> wrongPin = () -> {
        boolean restart = false;
        try {
            Integer iteration;
            if (this.wrongPIN != null && (iteration = this.wrongPIN.apply(this.iterator)) != null) {
                restart = this.iterator >= this.maxTries && iteration == 0;
                this.iterator = iteration;
                if (this.start > this.iterator) {
                    this.start = this.iterator;
                }
            }
            log.info((Object)("checkPassword:(iterator <= tries) " + this.iterator + " <= " + this.maxTries));
        }
        catch (Throwable e) {
            this.result = new LoginResult(e);
        }
        return restart;
    };

    public PasswordCounterBehaviour(Function<PrivateKeyLogin, LoginResult<LOGINRESULT>> loginAction, Function<Integer, Integer> wrongPIN, int maxTries, int start, String id) {
        this.loginAction = loginAction;
        this.wrongPIN = wrongPIN;
        this.maxTries = maxTries;
        this.start = start;
        this.id = id;
        this.iterator = start;
    }

    @Override
    public boolean accept(PrivateKeyLogin login, Consumer<String> messageConsumer) {
        String message;
        boolean success = false;
        boolean exit = false;
        if (this.iterator <= this.maxTries) {
            try {
                try {
                    LoginResult<LOGINRESULT> loginResult = this.loginAction.apply(login);
                    if (loginResult == null) {
                        throw new ANFPrivateKeyException();
                    }
                    this.result = loginResult;
                    if (loginResult.getError() != null) {
                        throw loginResult.getError();
                    }
                    exit = true;
                    success = true;
                }
                catch (Exception e) {
                    for (Throwable cursor = e.getCause(); cursor != null && cursor.getCause() != null && cursor.getCause() != cursor; cursor = cursor.getCause()) {
                        if (cursor.getCause().getMessage() == null || !cursor.getCause().getMessage().contains("CKR_PIN_LOCKED")) continue;
                        this.iterator = this.maxTries;
                        break;
                    }
                    ++this.iterator;
                    log.error((Object)e);
                    success = false;
                    boolean bl = exit = this.iterator >= this.maxTries;
                }
                if (!success && !exit) {
                    this.wrongPin.get();
                } else if (!success) {
                    this.restartOnClose = this.wrongPin;
                }
            }
            catch (Throwable e) {
                this.result = new LoginResult(e);
                ++this.iterator;
            }
        } else {
            this.result = new LoginResult(new PINLOCKEDException());
        }
        if ((message = this.handlePinIteration()) != null) {
            messageConsumer.accept(message);
        }
        return exit;
    }

    @Override
    public LoginResult<LOGINRESULT> getResult() {
        return this.result;
    }

    public String handlePinIteration() {
        Object text = null;
        if (this.iterator > this.start) {
            Object message = Confis.get().getString("PIN_INCORRECT", new Object[0]);
            String lastAttempt = Confis.get().getString("LAST_TRY", new Object[0]);
            String maxAttempts = Confis.get().getString("MAX_TRIES", new Object[0]);
            String errorTitle = Confis.get().getString("ERROR", new Object[0]);
            if (this.iterator == this.maxTries - 1) {
                message = (String)message + ". " + lastAttempt;
            }
            text = this.iterator >= this.maxTries ? (String)message + ". " + maxAttempts : message;
        }
        return text;
    }

    @Override
    public boolean restartOnClose() {
        return this.restartOnClose.get();
    }
}

