/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.ui.keyboard;

import com.anf.cryptotoken.log.Logger;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class TimeoutThread
extends Thread {
    private static final Logger log = Logger.getLogger(TimeoutThread.class);
    private String name;
    private Runnable run;
    private Date closeDate;

    public TimeoutThread(String name, Runnable run) {
        this.name = name;
        this.run = run;
    }

    public void setCloseDate(long seconds) {
        Calendar cal = Calendar.getInstance();
        cal.add(13, (int)seconds);
        this.setCloseDate(cal.getTime());
    }

    public synchronized void setCloseDate(Date closeDate) {
        this.closeDate = closeDate;
        log.info((Object)(this.name + " set timeout in " + closeDate));
        this.notifyAll();
    }

    @Override
    public void run() {
        while (true) {
            this.waitForUpdate();
            while (this.closeDate != null && this.closeDate.after(new Date())) {
                this.sleep();
            }
            if (this.closeDate == null) {
                log.info((Object)(this.name + " timeout canceled"));
            }
            if (this.closeDate == null) continue;
            log.info((Object)(this.name + " timeout reached"));
            this.run.run();
        }
    }

    private void sleep() {
        try {
            TimeUnit.SECONDS.sleep(1L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private synchronized void waitForUpdate() {
        try {
            this.wait();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void cancel() {
        this.setCloseDate(null);
    }
}

